/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDependencyFilter
implements DependencyFilter {
    private final Collection<DependencyFilter> filters = new LinkedHashSet<DependencyFilter>();

    public AndDependencyFilter(DependencyFilter ... dependencyFilterArray) {
        if (dependencyFilterArray != null) {
            Collections.addAll(this.filters, dependencyFilterArray);
        }
    }

    public AndDependencyFilter(Collection<DependencyFilter> collection) {
        if (collection != null) {
            this.filters.addAll(collection);
        }
    }

    public static DependencyFilter newInstance(DependencyFilter dependencyFilter, DependencyFilter dependencyFilter2) {
        if (dependencyFilter == null) {
            return dependencyFilter2;
        }
        if (dependencyFilter2 == null) {
            return dependencyFilter;
        }
        return new AndDependencyFilter(dependencyFilter, dependencyFilter2);
    }

    @Override
    public boolean accept(DependencyNode dependencyNode, List<DependencyNode> list) {
        for (DependencyFilter dependencyFilter : this.filters) {
            if (dependencyFilter.accept(dependencyNode, list)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AndDependencyFilter andDependencyFilter = (AndDependencyFilter)object;
        return ((Object)this.filters).equals(andDependencyFilter.filters);
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        n2 = n2 * 31 + ((Object)this.filters).hashCode();
        return n2;
    }
}

