/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.util.filter.AndDependencyFilter;
import zz.org.sonatype.aether.util.filter.NotDependencyFilter;
import zz.org.sonatype.aether.util.filter.OrDependencyFilter;
import zz.org.sonatype.aether.util.filter.ScopeDependencyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyFilterUtils {
    private DependencyFilterUtils() {
    }

    public static DependencyFilter notFilter(DependencyFilter dependencyFilter) {
        return new NotDependencyFilter(dependencyFilter);
    }

    public static DependencyFilter andFilter(DependencyFilter ... dependencyFilterArray) {
        if (dependencyFilterArray != null && dependencyFilterArray.length == 1) {
            return dependencyFilterArray[0];
        }
        return new AndDependencyFilter(dependencyFilterArray);
    }

    public static DependencyFilter andFilter(Collection<DependencyFilter> collection) {
        if (collection != null && collection.size() == 1) {
            return collection.iterator().next();
        }
        return new AndDependencyFilter(collection);
    }

    public static DependencyFilter orFilter(DependencyFilter ... dependencyFilterArray) {
        if (dependencyFilterArray != null && dependencyFilterArray.length == 1) {
            return dependencyFilterArray[0];
        }
        return new OrDependencyFilter(dependencyFilterArray);
    }

    public static DependencyFilter orFilter(Collection<DependencyFilter> collection) {
        if (collection != null && collection.size() == 1) {
            return collection.iterator().next();
        }
        return new OrDependencyFilter(collection);
    }

    public static DependencyFilter classpathFilter(String ... stringArray) {
        return DependencyFilterUtils.classpathFilter(stringArray != null ? Arrays.asList(stringArray) : null);
    }

    public static DependencyFilter classpathFilter(Collection<String> collection) {
        HashSet<String> hashSet2 = new HashSet<String>();
        if (collection != null) {
            for (String hashSet3 : collection) {
                String[] stringArray;
                for (String string : stringArray = hashSet3.split("[+,]")) {
                    if ((string = string.trim()).length() <= 0) continue;
                    hashSet2.add(string);
                }
            }
        }
        HashSet hashSet4 = new HashSet();
        for (String string : hashSet2) {
            if ("compile".equals(string)) {
                Collections.addAll(hashSet4, "compile", "provided", "system");
                continue;
            }
            if ("runtime".equals(string)) {
                Collections.addAll(hashSet4, "compile", "runtime");
                continue;
            }
            if ("test".equals(string)) {
                Collections.addAll(hashSet4, "compile", "provided", "system", "runtime", "test");
                continue;
            }
            hashSet4.add(string);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, "compile", "provided", "system", "runtime", "test");
        hashSet.removeAll(hashSet4);
        return new ScopeDependencyFilter(null, hashSet);
    }
}

