/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionsDependencyFilter
implements DependencyFilter {
    private final Collection<String> excludes = new HashSet<String>();

    public ExclusionsDependencyFilter(Collection<String> collection) {
        if (collection != null) {
            this.excludes.addAll(collection);
        }
    }

    @Override
    public boolean accept(DependencyNode dependencyNode, List<DependencyNode> list) {
        Dependency dependency = dependencyNode.getDependency();
        if (dependency == null) {
            return true;
        }
        String string = dependency.getArtifact().getArtifactId();
        if (this.excludes.contains(string)) {
            return false;
        }
        string = dependency.getArtifact().getGroupId() + ':' + string;
        return !this.excludes.contains(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExclusionsDependencyFilter exclusionsDependencyFilter = (ExclusionsDependencyFilter)object;
        return ((Object)this.excludes).equals(exclusionsDependencyFilter.excludes);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + ((Object)this.excludes).hashCode();
        return n2;
    }
}

