/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.version.InvalidVersionSpecificationException;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionRange;
import zz.org.sonatype.aether.version.VersionScheme;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternInclusionsDependencyFilter
implements DependencyFilter {
    private final Collection<String> patterns = new HashSet<String>();
    private final VersionScheme versionScheme;

    public PatternInclusionsDependencyFilter(String ... stringArray) {
        this((VersionScheme)null, stringArray);
    }

    public PatternInclusionsDependencyFilter(VersionScheme versionScheme, String ... stringArray) {
        this(versionScheme, stringArray == null ? null : Arrays.asList(stringArray));
    }

    public PatternInclusionsDependencyFilter(Collection<String> collection) {
        this(null, collection);
    }

    public PatternInclusionsDependencyFilter(VersionScheme versionScheme, Collection<String> collection) {
        if (collection != null) {
            this.patterns.addAll(collection);
        }
        this.versionScheme = versionScheme;
    }

    @Override
    public boolean accept(DependencyNode dependencyNode, List<DependencyNode> list) {
        Dependency dependency = dependencyNode.getDependency();
        if (dependency == null) {
            return true;
        }
        Artifact artifact = dependency.getArtifact();
        for (String string : this.patterns) {
            boolean bl2 = this.accept(artifact, string);
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    private boolean accept(Artifact artifact, String string) {
        String[] stringArray = new String[]{artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getBaseVersion()};
        String[] stringArray2 = string.split(":");
        boolean bl2 = stringArray2.length <= stringArray.length;
        for (int i2 = 0; bl2 && i2 < stringArray2.length; ++i2) {
            bl2 = this.matches(stringArray[i2], stringArray2[i2]);
        }
        return bl2;
    }

    private boolean matches(String string, String string2) {
        boolean bl2;
        if ("*".equals(string2) || string2.length() == 0) {
            bl2 = true;
        } else if (string2.startsWith("*") && string2.endsWith("*")) {
            String string3 = string2.substring(1, string2.length() - 1);
            bl2 = string.indexOf(string3) != -1;
        } else if (string2.startsWith("*")) {
            String string4 = string2.substring(1, string2.length());
            bl2 = string.endsWith(string4);
        } else if (string2.endsWith("*")) {
            String string5 = string2.substring(0, string2.length() - 1);
            bl2 = string.startsWith(string5);
        } else {
            bl2 = string2.startsWith("[") || string2.startsWith("(") ? this.isVersionIncludedInRange(string, string2) : string.equals(string2);
        }
        return bl2;
    }

    private boolean isVersionIncludedInRange(String string, String string2) {
        if (this.versionScheme == null) {
            return false;
        }
        try {
            Version version = this.versionScheme.parseVersion(string);
            VersionRange versionRange = this.versionScheme.parseVersionRange(string2);
            return versionRange.containsVersion(version);
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            return false;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PatternInclusionsDependencyFilter patternInclusionsDependencyFilter = (PatternInclusionsDependencyFilter)object;
        return ((Object)this.patterns).equals(patternInclusionsDependencyFilter.patterns) && (this.versionScheme == null ? patternInclusionsDependencyFilter.versionScheme == null : this.versionScheme.equals(patternInclusionsDependencyFilter.versionScheme));
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + ((Object)this.patterns).hashCode();
        n2 = n2 * 31 + (this.versionScheme == null ? 0 : this.versionScheme.hashCode());
        return n2;
    }
}

