/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDependencyFilter
implements DependencyFilter {
    private final Collection<String> included = new HashSet<String>();
    private final Collection<String> excluded = new HashSet<String>();

    public ScopeDependencyFilter(Collection<String> collection, Collection<String> collection2) {
        if (collection != null) {
            this.included.addAll(collection);
        }
        if (collection2 != null) {
            this.excluded.addAll(collection2);
        }
    }

    public ScopeDependencyFilter(String ... stringArray) {
        if (stringArray != null) {
            this.excluded.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public boolean accept(DependencyNode dependencyNode, List<DependencyNode> list) {
        Dependency dependency = dependencyNode.getDependency();
        if (dependency == null) {
            return true;
        }
        String string = dependencyNode.getDependency().getScope();
        return !(!this.included.isEmpty() && !this.included.contains(string) || !this.excluded.isEmpty() && this.excluded.contains(string));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ScopeDependencyFilter scopeDependencyFilter = (ScopeDependencyFilter)object;
        return ((Object)this.included).equals(scopeDependencyFilter.included) && ((Object)this.excluded).equals(scopeDependencyFilter.excluded);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + ((Object)this.included).hashCode();
        n2 = n2 * 31 + ((Object)this.excluded).hashCode();
        return n2;
    }
}

