/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import java.io.File;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.graph.DependencyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDepthFirstNodeListGenerator
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    protected final List<DependencyNode> nodes = new ArrayList<DependencyNode>(128);

    public AbstractDepthFirstNodeListGenerator() {
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
    }

    public List<DependencyNode> getNodes() {
        return this.nodes;
    }

    public List<Dependency> getDependencies(boolean bl2) {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>(this.getNodes().size());
        for (DependencyNode dependencyNode : this.getNodes()) {
            Dependency dependency = dependencyNode.getDependency();
            if (dependency == null || !bl2 && dependency.getArtifact().getFile() == null) continue;
            arrayList.add(dependency);
        }
        return arrayList;
    }

    public List<Artifact> getArtifacts(boolean bl2) {
        ArrayList<Artifact> arrayList = new ArrayList<Artifact>(this.getNodes().size());
        for (DependencyNode dependencyNode : this.getNodes()) {
            if (dependencyNode.getDependency() == null) continue;
            Artifact artifact = dependencyNode.getDependency().getArtifact();
            if (!bl2 && artifact.getFile() == null) continue;
            arrayList.add(artifact);
        }
        return arrayList;
    }

    public List<File> getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>(this.getNodes().size());
        for (DependencyNode dependencyNode : this.getNodes()) {
            File file;
            if (dependencyNode.getDependency() == null || (file = dependencyNode.getDependency().getArtifact().getFile()) == null) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public String getClassPath() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        Iterator<DependencyNode> iterator = this.getNodes().iterator();
        while (iterator.hasNext()) {
            Artifact artifact;
            DependencyNode dependencyNode = iterator.next();
            if (dependencyNode.getDependency() == null || (artifact = dependencyNode.getDependency().getArtifact()).getFile() == null) continue;
            stringBuilder.append(artifact.getFile().getAbsolutePath());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(File.pathSeparatorChar);
        }
        return stringBuilder.toString();
    }

    protected boolean setVisited(DependencyNode dependencyNode) {
        return this.visitedNodes.put(dependencyNode, Boolean.TRUE) == null;
    }

    @Override
    public abstract boolean visitEnter(DependencyNode var1);

    @Override
    public abstract boolean visitLeave(DependencyNode var1);
}

