/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.graph.DependencyVisitor;
import zz.org.sonatype.aether.repository.RemoteRepository;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencyNode
implements DependencyNode {
    private List<DependencyNode> children = new ArrayList<DependencyNode>(0);
    private Dependency dependency;
    private List<Artifact> relocations = Collections.emptyList();
    private Collection<Artifact> aliases = Collections.emptyList();
    private VersionConstraint versionConstraint;
    private Version version;
    private String premanagedVersion;
    private String premanagedScope;
    private List<RemoteRepository> repositories = Collections.emptyList();
    private String context = "";
    private Map<Object, Object> data = Collections.emptyMap();

    public DefaultDependencyNode() {
    }

    public DefaultDependencyNode(Dependency dependency) {
        this.dependency = dependency;
    }

    public DefaultDependencyNode(DependencyNode dependencyNode) {
        this.setDependency(dependencyNode.getDependency());
        this.setAliases(dependencyNode.getAliases());
        this.setRequestContext(dependencyNode.getRequestContext());
        this.setPremanagedScope(dependencyNode.getPremanagedScope());
        this.setPremanagedVersion(dependencyNode.getPremanagedVersion());
        this.setRelocations(dependencyNode.getRelocations());
        this.setRepositories(dependencyNode.getRepositories());
        this.setVersion(dependencyNode.getVersion());
        this.setVersionConstraint(dependencyNode.getVersionConstraint());
        this.setData(dependencyNode.getData());
    }

    @Override
    public List<DependencyNode> getChildren() {
        return this.children;
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public void setArtifact(Artifact artifact) {
        this.dependency = this.dependency.setArtifact(artifact);
    }

    @Override
    public List<Artifact> getRelocations() {
        return this.relocations;
    }

    public void setRelocations(List<Artifact> list) {
        this.relocations = list == null || list.isEmpty() ? Collections.emptyList() : list;
    }

    @Override
    public Collection<Artifact> getAliases() {
        return this.aliases;
    }

    public void setAliases(Collection<Artifact> collection) {
        this.aliases = collection == null || collection.isEmpty() ? Collections.emptyList() : collection;
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public void setScope(String string) {
        this.dependency = this.dependency.setScope(string);
    }

    @Override
    public String getPremanagedVersion() {
        return this.premanagedVersion;
    }

    public void setPremanagedVersion(String string) {
        this.premanagedVersion = string;
    }

    @Override
    public String getPremanagedScope() {
        return this.premanagedScope;
    }

    public void setPremanagedScope(String string) {
        this.premanagedScope = string;
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(List<RemoteRepository> list) {
        this.repositories = list == null || list.isEmpty() ? Collections.emptyList() : list;
    }

    @Override
    public String getRequestContext() {
        return this.context;
    }

    @Override
    public void setRequestContext(String string) {
        this.context = string != null ? string : "";
    }

    @Override
    public Map<Object, Object> getData() {
        return this.data;
    }

    public void setData(Map<Object, Object> map) {
        this.data = map == null ? Collections.emptyMap() : map;
    }

    @Override
    public void setData(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (object2 == null) {
            if (!this.data.isEmpty()) {
                this.data.remove(object);
                if (this.data.isEmpty()) {
                    this.data = Collections.emptyMap();
                }
            }
        } else {
            if (this.data.isEmpty()) {
                this.data = new HashMap<Object, Object>();
            }
            this.data.put(object, object2);
        }
    }

    @Override
    public boolean accept(DependencyVisitor dependencyVisitor) {
        block1: {
            if (!dependencyVisitor.visitEnter(this)) break block1;
            for (DependencyNode dependencyNode : this.getChildren()) {
                if (!dependencyNode.accept(dependencyVisitor)) break;
            }
        }
        return dependencyVisitor.visitLeave(this);
    }

    public String toString() {
        Dependency dependency = this.getDependency();
        if (dependency == null) {
            return String.valueOf(this.getChildren());
        }
        return dependency.toString();
    }
}

