/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.graph.DependencyVisitor;
import zz.org.sonatype.aether.util.graph.Stack;

public class FilteringDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final DependencyVisitor visitor;
    private final Stack<Boolean> accepts;
    private final Stack<DependencyNode> parents;

    public FilteringDependencyVisitor(DependencyVisitor dependencyVisitor, DependencyFilter dependencyFilter) {
        if (dependencyVisitor == null) {
            throw new IllegalArgumentException("dependency visitor not specified");
        }
        this.visitor = dependencyVisitor;
        this.filter = dependencyFilter;
        this.accepts = new Stack();
        this.parents = new Stack();
    }

    public DependencyVisitor getVisitor() {
        return this.visitor;
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public boolean visitEnter(DependencyNode dependencyNode) {
        boolean bl2 = this.filter == null || this.filter.accept(dependencyNode, this.parents);
        this.accepts.push(bl2);
        this.parents.push(dependencyNode);
        if (bl2) {
            return this.visitor.visitEnter(dependencyNode);
        }
        return true;
    }

    public boolean visitLeave(DependencyNode dependencyNode) {
        this.parents.pop();
        Boolean bl2 = this.accepts.pop();
        if (bl2.booleanValue()) {
            return this.visitor.visitLeave(dependencyNode);
        }
        return true;
    }
}

