/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.graph.DependencyVisitor;
import zz.org.sonatype.aether.util.graph.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathRecordingDependencyVisitor
implements DependencyVisitor {
    private final DependencyFilter filter;
    private final List<List<DependencyNode>> paths;
    private final Stack<DependencyNode> parents;
    private final boolean excludeChildrenOfMatches;

    public PathRecordingDependencyVisitor(DependencyFilter dependencyFilter) {
        this(dependencyFilter, true);
    }

    public PathRecordingDependencyVisitor(DependencyFilter dependencyFilter, boolean bl2) {
        this.filter = dependencyFilter;
        this.excludeChildrenOfMatches = bl2;
        this.paths = new ArrayList<List<DependencyNode>>();
        this.parents = new Stack();
    }

    public DependencyFilter getFilter() {
        return this.filter;
    }

    public List<List<DependencyNode>> getPaths() {
        return this.paths;
    }

    @Override
    public boolean visitEnter(DependencyNode dependencyNode) {
        boolean bl2 = this.filter == null || this.filter.accept(dependencyNode, this.parents);
        this.parents.push(dependencyNode);
        if (bl2) {
            DependencyNode[] dependencyNodeArray = new DependencyNode[this.parents.size()];
            int n2 = this.parents.size() - 1;
            Iterator iterator = this.parents.iterator();
            while (iterator.hasNext()) {
                DependencyNode dependencyNode2;
                dependencyNodeArray[n2] = dependencyNode2 = (DependencyNode)iterator.next();
                --n2;
            }
            this.paths.add(Arrays.asList(dependencyNodeArray));
        }
        return !this.excludeChildrenOfMatches || !bl2;
    }

    @Override
    public boolean visitLeave(DependencyNode dependencyNode) {
        this.parents.pop();
        return true;
    }
}

