/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import java.util.AbstractList;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Stack<E>
extends AbstractList<E>
implements RandomAccess {
    private Object[] elements = new Object[64];
    private int size;

    Stack() {
    }

    public void push(E e2) {
        if (this.size >= this.elements.length) {
            Object[] objectArray = new Object[this.size + 64];
            System.arraycopy(this.elements, 0, objectArray, 0, this.elements.length);
            this.elements = objectArray;
        }
        this.elements[this.size++] = e2;
    }

    public E pop() {
        if (this.size <= 0) {
            throw new NoSuchElementException();
        }
        return (E)this.elements[--this.size];
    }

    public E peek() {
        if (this.size <= 0) {
            return null;
        }
        return (E)this.elements[this.size - 1];
    }

    @Override
    public E get(int n2) {
        if (n2 < 0 || n2 >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
        }
        return (E)this.elements[this.size - n2 - 1];
    }

    @Override
    public int size() {
        return this.size;
    }
}

