/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.graph.DependencyVisitor;
import zz.org.sonatype.aether.util.graph.Stack;

public class TreeDependencyVisitor
implements DependencyVisitor {
    private final Map<DependencyNode, Object> visitedNodes;
    private final DependencyVisitor visitor;
    private final Stack<Boolean> visits;

    public TreeDependencyVisitor(DependencyVisitor dependencyVisitor) {
        if (dependencyVisitor == null) {
            throw new IllegalArgumentException("no visitor delegate specified");
        }
        this.visitor = dependencyVisitor;
        this.visitedNodes = new IdentityHashMap<DependencyNode, Object>(512);
        this.visits = new Stack();
    }

    public boolean visitEnter(DependencyNode dependencyNode) {
        boolean bl2 = this.visitedNodes.put(dependencyNode, Boolean.TRUE) != null;
        this.visits.push(bl2);
        if (bl2) {
            return false;
        }
        return this.visitor.visitEnter(dependencyNode);
    }

    public boolean visitLeave(DependencyNode dependencyNode) {
        Boolean bl2 = this.visits.pop();
        if (bl2.booleanValue()) {
            return true;
        }
        return this.visitor.visitLeave(dependencyNode);
    }
}

