/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.manager;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.collection.DependencyCollectionContext;
import zz.org.sonatype.aether.collection.DependencyManagement;
import zz.org.sonatype.aether.collection.DependencyManager;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassicDependencyManager
implements DependencyManager {
    private final int depth;
    private final Map<Object, String> managedVersions;
    private final Map<Object, String> managedScopes;
    private final Map<Object, String> managedLocalPaths;
    private final Map<Object, Collection<Exclusion>> managedExclusions;

    public ClassicDependencyManager() {
        this(0, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    private ClassicDependencyManager(int n2, Map<Object, String> map, Map<Object, String> map2, Map<Object, String> map3, Map<Object, Collection<Exclusion>> map4) {
        this.depth = n2;
        this.managedVersions = map;
        this.managedScopes = map2;
        this.managedLocalPaths = map3;
        this.managedExclusions = map4;
    }

    @Override
    public DependencyManager deriveChildManager(DependencyCollectionContext dependencyCollectionContext) {
        if (this.depth >= 2) {
            return this;
        }
        if (this.depth == 1) {
            return new ClassicDependencyManager(this.depth + 1, this.managedVersions, this.managedScopes, this.managedLocalPaths, this.managedExclusions);
        }
        Map<Object, String> map = this.managedVersions;
        Map<Object, String> map2 = this.managedScopes;
        Map<Object, String> map3 = this.managedLocalPaths;
        Map<Object, Collection<Exclusion>> map4 = this.managedExclusions;
        for (Dependency dependency : dependencyCollectionContext.getManagedDependencies()) {
            Collection<Exclusion> collection;
            Collection<Exclusion> collection2;
            String string;
            String string2;
            Artifact artifact = dependency.getArtifact();
            Object object = this.getKey(artifact);
            String string3 = artifact.getVersion();
            if (string3.length() > 0 && !map.containsKey(object)) {
                if (map == this.managedVersions) {
                    map = new HashMap<Object, String>(this.managedVersions);
                }
                map.put(object, string3);
            }
            if ((string2 = dependency.getScope()).length() > 0 && !map2.containsKey(object)) {
                if (map2 == this.managedScopes) {
                    map2 = new HashMap<Object, String>(this.managedScopes);
                }
                map2.put(object, string2);
            }
            if ((string = dependency.getArtifact().getProperty("localPath", null)) != null && !map3.containsKey(object)) {
                if (map3 == this.managedLocalPaths) {
                    map3 = new HashMap<Object, String>(this.managedLocalPaths);
                }
                map3.put(object, string);
            }
            if ((collection2 = dependency.getExclusions()).isEmpty()) continue;
            if (map4 == this.managedExclusions) {
                map4 = new HashMap<Object, Collection<Exclusion>>(this.managedExclusions);
            }
            if ((collection = map4.get(object)) == null) {
                collection = new LinkedHashSet<Exclusion>();
                map4.put(object, collection);
            }
            collection.addAll(collection2);
        }
        return new ClassicDependencyManager(this.depth + 1, map, map2, map3, map4);
    }

    @Override
    public DependencyManagement manageDependency(Dependency dependency) {
        Object object;
        Object object2;
        DependencyManagement dependencyManagement = null;
        Object object3 = this.getKey(dependency.getArtifact());
        if (this.depth >= 2) {
            Object object4;
            object2 = this.managedVersions.get(object3);
            if (object2 != null) {
                if (dependencyManagement == null) {
                    dependencyManagement = new DependencyManagement();
                }
                dependencyManagement.setVersion((String)object2);
            }
            if ((object = this.managedScopes.get(object3)) != null) {
                if (dependencyManagement == null) {
                    dependencyManagement = new DependencyManagement();
                }
                dependencyManagement.setScope((String)object);
                if (!"system".equals(object) && dependency.getArtifact().getProperty("localPath", null) != null) {
                    object4 = new HashMap<String, String>(dependency.getArtifact().getProperties());
                    object4.remove("localPath");
                    dependencyManagement.setProperties((Map<String, String>)object4);
                }
            }
            if ((object != null && "system".equals(object) || object == null && "system".equals(dependency.getScope())) && (object4 = this.managedLocalPaths.get(object3)) != null) {
                if (dependencyManagement == null) {
                    dependencyManagement = new DependencyManagement();
                }
                HashMap<String, String> hashMap = new HashMap<String, String>(dependency.getArtifact().getProperties());
                hashMap.put("localPath", (String)object4);
                dependencyManagement.setProperties(hashMap);
            }
        }
        if ((object2 = this.managedExclusions.get(object3)) != null) {
            if (dependencyManagement == null) {
                dependencyManagement = new DependencyManagement();
            }
            object = new LinkedHashSet<Exclusion>(dependency.getExclusions());
            object.addAll(object2);
            dependencyManagement.setExclusions((Collection<Exclusion>)object);
        }
        return dependencyManagement;
    }

    private Object getKey(Artifact artifact) {
        return new Key(artifact);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ClassicDependencyManager classicDependencyManager = (ClassicDependencyManager)object;
        return this.depth == classicDependencyManager.depth && ((Object)this.managedVersions).equals(classicDependencyManager.managedVersions) && ((Object)this.managedScopes).equals(classicDependencyManager.managedScopes) && ((Object)this.managedExclusions).equals(classicDependencyManager.managedExclusions);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + this.depth;
        n2 = n2 * 31 + ((Object)this.managedVersions).hashCode();
        n2 = n2 * 31 + ((Object)this.managedScopes).hashCode();
        n2 = n2 * 31 + ((Object)this.managedExclusions).hashCode();
        return n2;
    }

    static class Key {
        private final Artifact artifact;
        private final int hashCode;

        public Key(Artifact artifact) {
            this.artifact = artifact;
            int n2 = 17;
            n2 = n2 * 31 + artifact.getGroupId().hashCode();
            this.hashCode = n2 = n2 * 31 + artifact.getArtifactId().hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return this.artifact.getArtifactId().equals(key.artifact.getArtifactId()) && this.artifact.getGroupId().equals(key.artifact.getGroupId()) && this.artifact.getExtension().equals(key.artifact.getExtension()) && this.artifact.getClassifier().equals(key.artifact.getClassifier());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

