/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import zz.org.sonatype.aether.collection.DependencyCollectionContext;
import zz.org.sonatype.aether.collection.DependencySelector;
import zz.org.sonatype.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndDependencySelector
implements DependencySelector {
    private final Collection<DependencySelector> selectors;

    public AndDependencySelector(DependencySelector ... dependencySelectorArray) {
        if (dependencySelectorArray != null && dependencySelectorArray.length > 0) {
            this.selectors = new LinkedHashSet<DependencySelector>();
            Collections.addAll(this.selectors, dependencySelectorArray);
        } else {
            this.selectors = Collections.emptySet();
        }
    }

    public AndDependencySelector(Set<DependencySelector> set) {
        this.selectors = set != null && !set.isEmpty() ? set : Collections.emptySet();
    }

    public static DependencySelector newInstance(DependencySelector dependencySelector, DependencySelector dependencySelector2) {
        if (dependencySelector == null) {
            return dependencySelector2;
        }
        if (dependencySelector2 == null) {
            return dependencySelector;
        }
        return new AndDependencySelector(dependencySelector, dependencySelector2);
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        for (DependencySelector dependencySelector : this.selectors) {
            if (dependencySelector.selectDependency(dependency)) continue;
            return false;
        }
        return true;
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext dependencyCollectionContext) {
        int n2 = 0;
        LinkedHashSet<DependencySelector> linkedHashSet = null;
        for (DependencySelector dependencySelector : this.selectors) {
            DependencySelector dependencySelector2 = dependencySelector.deriveChildSelector(dependencyCollectionContext);
            if (linkedHashSet != null) {
                linkedHashSet.add(dependencySelector2);
                continue;
            }
            if (!dependencySelector.equals(dependencySelector2)) {
                linkedHashSet = new LinkedHashSet<DependencySelector>();
                if (n2 > 0) {
                    for (DependencySelector dependencySelector3 : this.selectors) {
                        if (linkedHashSet.size() >= n2) break;
                        linkedHashSet.add(dependencySelector3);
                    }
                }
                linkedHashSet.add(dependencySelector2);
                continue;
            }
            ++n2;
        }
        return linkedHashSet != null ? new AndDependencySelector(linkedHashSet) : this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AndDependencySelector andDependencySelector = (AndDependencySelector)object;
        return ((Object)this.selectors).equals(andDependencySelector.selectors);
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        n2 = n2 * 31 + ((Object)this.selectors).hashCode();
        return n2;
    }
}

