/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.collection.DependencyCollectionContext;
import zz.org.sonatype.aether.collection.DependencySelector;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.Exclusion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExclusionDependencySelector
implements DependencySelector {
    private final Collection<Exclusion> exclusions;

    public ExclusionDependencySelector() {
        this(Collections.emptySet());
    }

    public ExclusionDependencySelector(Set<Exclusion> set) {
        this.exclusions = set != null && !set.isEmpty() ? set : Collections.emptySet();
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        Artifact artifact = dependency.getArtifact();
        for (Exclusion exclusion : this.exclusions) {
            if (!this.matches(exclusion, artifact)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Exclusion exclusion, Artifact artifact) {
        if (!this.matches(exclusion.getArtifactId(), artifact.getArtifactId())) {
            return false;
        }
        if (!this.matches(exclusion.getGroupId(), artifact.getGroupId())) {
            return false;
        }
        if (!this.matches(exclusion.getExtension(), artifact.getExtension())) {
            return false;
        }
        return this.matches(exclusion.getClassifier(), artifact.getClassifier());
    }

    private boolean matches(String string, String string2) {
        return "*".equals(string) || string.equals(string2);
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext dependencyCollectionContext) {
        Collection<Exclusion> collection;
        Dependency dependency = dependencyCollectionContext.getDependency();
        Collection<Exclusion> collection2 = collection = dependency != null ? dependency.getExclusions() : null;
        if (collection == null || collection.isEmpty()) {
            return this;
        }
        LinkedHashSet<Exclusion> linkedHashSet = new LinkedHashSet<Exclusion>();
        linkedHashSet.addAll(this.exclusions);
        linkedHashSet.addAll(collection);
        return new ExclusionDependencySelector(linkedHashSet);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ExclusionDependencySelector exclusionDependencySelector = (ExclusionDependencySelector)object;
        return ((Object)this.exclusions).equals(exclusionDependencySelector.exclusions);
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        n2 = n2 * 31 + ((Object)this.exclusions).hashCode();
        return n2;
    }
}

