/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.selector;

import zz.org.sonatype.aether.collection.DependencyCollectionContext;
import zz.org.sonatype.aether.collection.DependencySelector;
import zz.org.sonatype.aether.graph.Dependency;

public class OptionalDependencySelector
implements DependencySelector {
    private final int depth;

    public OptionalDependencySelector() {
        this.depth = 0;
    }

    private OptionalDependencySelector(int n2) {
        this.depth = n2;
    }

    public boolean selectDependency(Dependency dependency) {
        return this.depth < 2 || !dependency.isOptional();
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext dependencyCollectionContext) {
        if (this.depth >= 2) {
            return this;
        }
        return new OptionalDependencySelector(this.depth + 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        OptionalDependencySelector optionalDependencySelector = (OptionalDependencySelector)object;
        return this.depth == optionalDependencySelector.depth;
    }

    public int hashCode() {
        int n2 = this.getClass().hashCode();
        n2 = n2 * 31 + this.depth;
        return n2;
    }
}

