/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.selector;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import zz.org.sonatype.aether.collection.DependencyCollectionContext;
import zz.org.sonatype.aether.collection.DependencySelector;
import zz.org.sonatype.aether.graph.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeDependencySelector
implements DependencySelector {
    private final boolean transitive;
    private final Collection<String> included;
    private final Collection<String> excluded;

    public ScopeDependencySelector(Collection<String> collection, Collection<String> collection2) {
        this.transitive = false;
        if (collection != null) {
            this.included = new HashSet<String>();
            this.included.addAll(collection);
        } else {
            this.included = Collections.emptySet();
        }
        if (collection2 != null) {
            this.excluded = new HashSet<String>();
            this.excluded.addAll(collection2);
        } else {
            this.excluded = Collections.emptySet();
        }
    }

    public ScopeDependencySelector(String ... stringArray) {
        this(null, Arrays.asList(stringArray));
    }

    private ScopeDependencySelector(boolean bl2, Collection<String> collection, Collection<String> collection2) {
        this.transitive = bl2;
        this.included = collection;
        this.excluded = collection2;
    }

    @Override
    public boolean selectDependency(Dependency dependency) {
        if (!this.transitive) {
            return true;
        }
        String string = dependency.getScope();
        return !(!this.included.isEmpty() && !this.included.contains(string) || !this.excluded.isEmpty() && this.excluded.contains(string));
    }

    @Override
    public DependencySelector deriveChildSelector(DependencyCollectionContext dependencyCollectionContext) {
        if (this.transitive || dependencyCollectionContext.getDependency() == null) {
            return this;
        }
        return new ScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ScopeDependencySelector scopeDependencySelector = (ScopeDependencySelector)object;
        return this.transitive == scopeDependencySelector.transitive && ((Object)this.included).equals(scopeDependencySelector.included) && ((Object)this.excluded).equals(scopeDependencySelector.excluded);
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + (this.transitive ? 1 : 0);
        n2 = n2 * 31 + ((Object)this.included).hashCode();
        n2 = n2 * 31 + ((Object)this.excluded).hashCode();
        return n2;
    }
}

