/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.util.graph.transformer.ConflictMarker;
import zz.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictIdSorter
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext dependencyGraphTransformationContext) throws RepositoryException {
        Object object;
        Map map = (Map)dependencyGraphTransformationContext.get(TransformationContextKeys.CONFLICT_IDS);
        if (map == null) {
            object = new ConflictMarker();
            ((ConflictMarker)object).transformGraph(dependencyNode, dependencyGraphTransformationContext);
            map = (Map)dependencyGraphTransformationContext.get(TransformationContextKeys.CONFLICT_IDS);
        }
        object = new LinkedHashMap(256);
        ConflictId conflictId = null;
        Object v2 = map.get(dependencyNode);
        if (v2 != null) {
            conflictId = new ConflictId(v2, 0);
            object.put(v2, conflictId);
        }
        IdentityHashMap<DependencyNode, Object> identityHashMap = new IdentityHashMap<DependencyNode, Object>(map.size());
        this.buildConflitIdDAG((Map<Object, ConflictId>)object, dependencyNode, conflictId, 0, identityHashMap, map);
        this.topsortConflictIds(object.values(), dependencyGraphTransformationContext);
        return dependencyNode;
    }

    private void buildConflitIdDAG(Map<Object, ConflictId> map, DependencyNode dependencyNode, ConflictId conflictId, int n2, Map<DependencyNode, Object> map2, Map<?, ?> map3) {
        if (map2.put(dependencyNode, Boolean.TRUE) != null) {
            return;
        }
        ++n2;
        for (DependencyNode dependencyNode2 : dependencyNode.getChildren()) {
            Object obj = map3.get(dependencyNode2);
            ConflictId conflictId2 = map.get(obj);
            if (conflictId2 == null) {
                conflictId2 = new ConflictId(obj, n2);
                map.put(obj, conflictId2);
            } else {
                conflictId2.pullup(n2);
            }
            if (conflictId != null) {
                conflictId.add(conflictId2);
            }
            this.buildConflitIdDAG(map, dependencyNode2, conflictId2, n2, map2, map3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void topsortConflictIds(Collection<ConflictId> collection, DependencyGraphTransformationContext dependencyGraphTransformationContext) {
        boolean bl2;
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        RootQueue rootQueue = new RootQueue(collection.size() / 2);
        for (ConflictId object : collection) {
            if (object.inDegree > 0) continue;
            rootQueue.add(object);
        }
        while (!rootQueue.isEmpty()) {
            ConflictId conflictId = rootQueue.remove();
            arrayList.add(conflictId.key);
            for (ConflictId conflictId2 : conflictId.children) {
                --conflictId2.inDegree;
                if (conflictId2.inDegree != 0) continue;
                rootQueue.add(conflictId2);
            }
        }
        boolean bl3 = bl2 = arrayList.size() < collection.size();
        while (arrayList.size() < collection.size()) {
            void var6_12;
            Object var6_11 = null;
            for (ConflictId conflictId : collection) {
                if (conflictId.inDegree <= 0 || var6_12 != null && conflictId.minDepth >= var6_12.minDepth && (conflictId.minDepth != var6_12.minDepth || conflictId.inDegree >= var6_12.inDegree)) continue;
                ConflictId conflictId3 = conflictId;
            }
            var6_12.inDegree = 0;
            rootQueue.add((ConflictId)var6_12);
            while (!rootQueue.isEmpty()) {
                ConflictId conflictId = rootQueue.remove();
                arrayList.add(conflictId.key);
                for (ConflictId conflictId4 : conflictId.children) {
                    --conflictId4.inDegree;
                    if (conflictId4.inDegree != 0) continue;
                    rootQueue.add(conflictId4);
                }
            }
        }
        dependencyGraphTransformationContext.put(TransformationContextKeys.SORTED_CONFLICT_IDS, arrayList);
        dependencyGraphTransformationContext.put(TransformationContextKeys.CYCLIC_CONFLICT_IDS, bl2);
    }

    static final class RootQueue {
        private int nextOut;
        private int nextIn;
        private ConflictId[] ids;

        RootQueue(int n2) {
            this.ids = new ConflictId[n2 + 16];
        }

        boolean isEmpty() {
            return this.nextOut >= this.nextIn;
        }

        void add(ConflictId conflictId) {
            if (this.nextOut >= this.nextIn && this.nextOut > 0) {
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            if (this.nextIn >= this.ids.length) {
                ConflictId[] conflictIdArray = new ConflictId[this.ids.length + this.ids.length / 2 + 16];
                System.arraycopy(this.ids, this.nextOut, conflictIdArray, 0, this.nextIn - this.nextOut);
                this.ids = conflictIdArray;
                this.nextIn -= this.nextOut;
                this.nextOut = 0;
            }
            for (int i2 = this.nextIn - 1; i2 >= this.nextOut && conflictId.minDepth < this.ids[i2].minDepth; --i2) {
                this.ids[i2 + 1] = this.ids[i2];
            }
            this.ids[i2 + 1] = conflictId;
            ++this.nextIn;
        }

        ConflictId remove() {
            return this.ids[this.nextOut++];
        }
    }

    static final class ConflictId {
        final Object key;
        Collection<ConflictId> children = Collections.emptySet();
        int inDegree;
        int minDepth;

        public ConflictId(Object object, int n2) {
            this.key = object;
            this.minDepth = n2;
        }

        public void add(ConflictId conflictId) {
            if (this.children.isEmpty()) {
                this.children = new HashSet<ConflictId>();
            }
            if (this.children.add(conflictId)) {
                ++conflictId.inDegree;
            }
        }

        public void pullup(int n2) {
            if (n2 < this.minDepth) {
                this.minDepth = n2++;
                for (ConflictId conflictId : this.children) {
                    conflictId.pullup(n2);
                }
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ConflictId)) {
                return false;
            }
            ConflictId conflictId = (ConflictId)object;
            return this.key.equals(conflictId.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key + " @ " + this.minDepth + " <" + this.inDegree;
        }
    }
}

