/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.transformer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.graph.Dependency;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConflictMarker
implements DependencyGraphTransformer {
    private final Object SEEN = Boolean.TRUE;

    @Override
    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext dependencyGraphTransformationContext) throws RepositoryException {
        IdentityHashMap<DependencyNode, Object> identityHashMap = new IdentityHashMap<DependencyNode, Object>(1024);
        HashMap<Object, ConflictGroup> hashMap = new HashMap<Object, ConflictGroup>(1024);
        this.analyze(dependencyNode, identityHashMap, hashMap);
        Map<DependencyNode, Object> map = this.mark(identityHashMap.keySet(), hashMap);
        dependencyGraphTransformationContext.put(TransformationContextKeys.CONFLICT_IDS, map);
        return dependencyNode;
    }

    private void analyze(DependencyNode dependencyNode, Map<DependencyNode, Object> map, Map<Object, ConflictGroup> map2) {
        if (map.put(dependencyNode, this.SEEN) != null) {
            return;
        }
        Set<Object> set = this.getKeys(dependencyNode);
        if (!set.isEmpty()) {
            Object object = null;
            boolean bl2 = false;
            for (Object object2 : set) {
                Set<Object> set2;
                ConflictGroup conflictGroup = map2.get(object2);
                if (object == conflictGroup) continue;
                if (object == null) {
                    set2 = this.merge(conflictGroup.keys, set);
                    if (set2 == conflictGroup.keys) {
                        object = conflictGroup;
                        break;
                    }
                    object = new ConflictGroup(set2);
                    bl2 = true;
                    continue;
                }
                if (conflictGroup == null) {
                    bl2 = true;
                    continue;
                }
                set2 = this.merge(conflictGroup.keys, ((ConflictGroup)object).keys);
                if (set2 == conflictGroup.keys) {
                    object = conflictGroup;
                    bl2 = false;
                    break;
                }
                if (set2 == ((ConflictGroup)object).keys) continue;
                object = new ConflictGroup(set2);
                bl2 = true;
            }
            if (object == null) {
                object = new ConflictGroup(set);
                bl2 = true;
            }
            if (bl2) {
                for (Object object2 : ((ConflictGroup)object).keys) {
                    map2.put(object2, (ConflictGroup)object);
                }
            }
        }
        for (DependencyNode dependencyNode2 : dependencyNode.getChildren()) {
            this.analyze(dependencyNode2, map, map2);
        }
    }

    private Set<Object> merge(Set<Object> set, Set<Object> set2) {
        int n2;
        int n3 = set.size();
        if (n3 < (n2 = set2.size())) {
            if (set2.containsAll(set)) {
                return set2;
            }
        } else if (set.containsAll(set2)) {
            return set;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    private Set<Object> getKeys(DependencyNode dependencyNode) {
        Set<Object> set;
        Dependency dependency = dependencyNode.getDependency();
        if (dependency == null) {
            set = Collections.emptySet();
        } else {
            Object object = ConflictMarker.toKey(dependency.getArtifact());
            if (dependencyNode.getRelocations().isEmpty() && dependencyNode.getAliases().isEmpty()) {
                set = Collections.singleton(object);
            } else {
                set = new HashSet<Object>();
                set.add(object);
                for (Artifact artifact : dependencyNode.getRelocations()) {
                    object = ConflictMarker.toKey(artifact);
                    set.add(object);
                }
                for (Artifact artifact : dependencyNode.getAliases()) {
                    object = ConflictMarker.toKey(artifact);
                    set.add(object);
                }
            }
        }
        return set;
    }

    private Map<DependencyNode, Object> mark(Collection<DependencyNode> collection, Map<Object, ConflictGroup> map) {
        IdentityHashMap<DependencyNode, Object> identityHashMap = new IdentityHashMap<DependencyNode, Object>(collection.size() + 1);
        for (DependencyNode dependencyNode : collection) {
            Dependency dependency = dependencyNode.getDependency();
            if (dependency == null) continue;
            Object object = ConflictMarker.toKey(dependency.getArtifact());
            identityHashMap.put(dependencyNode, map.get((Object)object).keys);
        }
        return identityHashMap;
    }

    private static Object toKey(Artifact artifact) {
        return new Key(artifact);
    }

    static class Key {
        private final Artifact artifact;

        public Key(Artifact artifact) {
            this.artifact = artifact;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            return this.artifact.getArtifactId().equals(key.artifact.getArtifactId()) && this.artifact.getGroupId().equals(key.artifact.getGroupId()) && this.artifact.getExtension().equals(key.artifact.getExtension()) && this.artifact.getClassifier().equals(key.artifact.getClassifier());
        }

        public int hashCode() {
            int n2 = 17;
            n2 = n2 * 31 + this.artifact.getArtifactId().hashCode();
            n2 = n2 * 31 + this.artifact.getGroupId().hashCode();
            n2 = n2 * 31 + this.artifact.getClassifier().hashCode();
            n2 = n2 * 31 + this.artifact.getExtension().hashCode();
            return n2;
        }

        public String toString() {
            return this.artifact.getGroupId() + ':' + this.artifact.getArtifactId() + ':' + this.artifact.getClassifier() + ':' + this.artifact.getExtension();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConflictGroup {
        final Set<Object> keys;

        public ConflictGroup(Set<Object> set) {
            this.keys = set;
        }

        public String toString() {
            return String.valueOf(this.keys);
        }
    }
}

