/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.transformer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.util.graph.transformer.ConflictIdSorter;
import zz.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaEffectiveScopeCalculator
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext dependencyGraphTransformationContext) throws RepositoryException {
        Object object;
        Object object2;
        List list = (List)dependencyGraphTransformationContext.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (list == null) {
            object2 = new ConflictIdSorter();
            ((ConflictIdSorter)object2).transformGraph(dependencyNode, dependencyGraphTransformationContext);
            list = (List)dependencyGraphTransformationContext.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        if ((object2 = (Map)dependencyGraphTransformationContext.get(TransformationContextKeys.CONFLICT_IDS)) == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        Boolean bl2 = (Boolean)dependencyGraphTransformationContext.get(TransformationContextKeys.CYCLIC_CONFLICT_IDS);
        HashMap<Object, ConflictGroup> hashMap = new HashMap<Object, ConflictGroup>(256);
        this.buildConflictGroups((Map<Object, ConflictGroup>)hashMap, dependencyNode, null, (Map<?, ?>)object2);
        String string = "";
        if (dependencyNode.getDependency() != null) {
            object = object2.get(dependencyNode);
            ((ConflictGroup)hashMap.get((Object)object)).scope = string = dependencyNode.getDependency().getScope();
        }
        for (DependencyNode object3 : dependencyNode.getChildren()) {
            Object object4 = object2.get(object3);
            ((ConflictGroup)hashMap.get(object4)).scope = this.getInheritedScope(string, object3.getDependency().getScope());
        }
        object = null;
        if (Boolean.TRUE.equals(bl2)) {
            object = new HashSet(list.size() * 2);
        }
        for (Object object4 : list) {
            if (object != null) {
                object.add(object4);
            }
            ConflictGroup conflictGroup = (ConflictGroup)hashMap.get(object4);
            this.resolve(conflictGroup, (Map<?, ?>)object2, (Set<?>)object);
        }
        return dependencyNode;
    }

    private void buildConflictGroups(Map<Object, ConflictGroup> map, DependencyNode dependencyNode, DependencyNode dependencyNode2, Map<?, ?> map2) {
        List<DependencyNode> list;
        boolean bl2;
        Object obj = map2.get(dependencyNode);
        ConflictGroup conflictGroup = map.get(obj);
        if (conflictGroup == null) {
            conflictGroup = new ConflictGroup(obj);
            map.put(obj, conflictGroup);
        }
        boolean bl3 = bl2 = (list = conflictGroup.parents.get(dependencyNode)) != null;
        if (list == null) {
            list = new ArrayList<DependencyNode>(4);
            conflictGroup.parents.put(dependencyNode, list);
        }
        if (dependencyNode2 != null) {
            list.add(dependencyNode2);
        }
        if (!bl2) {
            dependencyNode2 = dependencyNode.getDependency() != null ? dependencyNode : null;
            for (DependencyNode dependencyNode3 : dependencyNode.getChildren()) {
                this.buildConflictGroups(map, dependencyNode3, dependencyNode2, map2);
            }
        }
    }

    private void resolve(ConflictGroup conflictGroup, Map<?, ?> map, Set<?> set) {
        if (conflictGroup.scope == null) {
            Set<String> set2 = this.getInheritedScopes(conflictGroup, map, set);
            conflictGroup.scope = this.chooseEffectiveScope(set2);
        }
        for (DependencyNode dependencyNode : conflictGroup.parents.keySet()) {
            String string;
            if (dependencyNode.getPremanagedScope() != null || conflictGroup.scope.equals(string = dependencyNode.getDependency().getScope()) || "system".equals(string)) continue;
            dependencyNode.setScope(conflictGroup.scope);
        }
    }

    private Set<String> getInheritedScopes(ConflictGroup conflictGroup, Map<?, ?> map, Set<?> set) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<DependencyNode, List<DependencyNode>> entry : conflictGroup.parents.entrySet()) {
            String string = entry.getKey().getDependency().getScope();
            if (entry.getValue().isEmpty()) {
                hashSet.add(string);
                continue;
            }
            for (DependencyNode dependencyNode : entry.getValue()) {
                if (set != null && !set.contains(map.get(dependencyNode))) continue;
                String string2 = dependencyNode.getDependency().getScope();
                String string3 = this.getInheritedScope(string2, string);
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    private String getInheritedScope(String string, String string2) {
        String string3 = "system".equals(string2) || "test".equals(string2) ? string2 : (string == null || string.length() <= 0 || "compile".equals(string) ? string2 : ("test".equals(string) || "runtime".equals(string) ? string : ("system".equals(string) || "provided".equals(string) ? "provided" : "runtime")));
        return string3;
    }

    private String chooseEffectiveScope(Set<String> set) {
        if (set.size() > 1) {
            set.remove("system");
        }
        String string = "";
        if (set.size() == 1) {
            string = set.iterator().next();
        } else if (set.contains("compile")) {
            string = "compile";
        } else if (set.contains("runtime")) {
            string = "runtime";
        } else if (set.contains("provided")) {
            string = "provided";
        } else if (set.contains("test")) {
            string = "test";
        }
        return string;
    }

    static final class ConflictGroup {
        final Object key;
        final Map<DependencyNode, List<DependencyNode>> parents;
        String scope;

        public ConflictGroup(Object object) {
            this.key = object;
            this.parents = new IdentityHashMap<DependencyNode, List<DependencyNode>>();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ConflictGroup)) {
                return false;
            }
            ConflictGroup conflictGroup = (ConflictGroup)object;
            return this.key.equals(conflictGroup.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return String.valueOf(this.key);
        }
    }
}

