/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.graph.transformer;

import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import zz.org.sonatype.aether.RepositoryException;
import zz.org.sonatype.aether.collection.DependencyGraphTransformationContext;
import zz.org.sonatype.aether.collection.DependencyGraphTransformer;
import zz.org.sonatype.aether.collection.UnsolvableVersionConflictException;
import zz.org.sonatype.aether.graph.DependencyFilter;
import zz.org.sonatype.aether.graph.DependencyNode;
import zz.org.sonatype.aether.util.graph.PathRecordingDependencyVisitor;
import zz.org.sonatype.aether.util.graph.transformer.ConflictIdSorter;
import zz.org.sonatype.aether.util.graph.transformer.TransformationContextKeys;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NearestVersionConflictResolver
implements DependencyGraphTransformer {
    @Override
    public DependencyNode transformGraph(DependencyNode dependencyNode, DependencyGraphTransformationContext dependencyGraphTransformationContext) throws RepositoryException {
        Object object;
        List list = (List)dependencyGraphTransformationContext.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        if (list == null) {
            object = new ConflictIdSorter();
            ((ConflictIdSorter)object).transformGraph(dependencyNode, dependencyGraphTransformationContext);
            list = (List)dependencyGraphTransformationContext.get(TransformationContextKeys.SORTED_CONFLICT_IDS);
        }
        if ((object = (Map)dependencyGraphTransformationContext.get(TransformationContextKeys.CONFLICT_IDS)) == null) {
            throw new RepositoryException("conflict groups have not been identified");
        }
        IdentityHashMap<DependencyNode, Integer> identityHashMap = new IdentityHashMap<DependencyNode, Integer>(object.size());
        for (Object e2 : list) {
            ConflictGroup conflictGroup = new ConflictGroup(e2);
            identityHashMap.clear();
            this.selectVersion(dependencyNode, null, 0, (Map<DependencyNode, Integer>)identityHashMap, conflictGroup, (Map<?, ?>)object, dependencyNode);
            this.pruneNonSelectedVersions(conflictGroup, (Map<?, ?>)object);
        }
        return dependencyNode;
    }

    private void selectVersion(DependencyNode dependencyNode, DependencyNode dependencyNode2, int n2, Map<DependencyNode, Integer> map, ConflictGroup conflictGroup, Map<?, ?> map2, DependencyNode dependencyNode3) throws RepositoryException {
        Integer n3 = map.get(dependencyNode);
        if (n3 != null && n3 <= n2) {
            return;
        }
        map.put(dependencyNode, n2);
        Object obj = map2.get(dependencyNode);
        if (conflictGroup.key.equals(obj)) {
            boolean bl2;
            Position position = new Position(dependencyNode2, n2);
            if (dependencyNode2 != null) {
                conflictGroup.positions.add(position);
            }
            VersionConstraint object = dependencyNode.getVersionConstraint();
            boolean bl3 = false;
            boolean bl4 = bl2 = !object.getRanges().isEmpty();
            if (bl2 && conflictGroup.constraints.add(object) && conflictGroup.version != null && !object.containsVersion(conflictGroup.version)) {
                bl3 = true;
            }
            if (this.isAcceptable(conflictGroup, dependencyNode.getVersion())) {
                conflictGroup.candidates.put(dependencyNode, position);
                if (bl3) {
                    this.backtrack(conflictGroup, map2, dependencyNode3);
                } else if (conflictGroup.version == null || this.isNearer(position, dependencyNode.getVersion(), conflictGroup.position, conflictGroup.version)) {
                    conflictGroup.version = dependencyNode.getVersion();
                    conflictGroup.position = position;
                }
            } else {
                if (bl3) {
                    this.backtrack(conflictGroup, map2, dependencyNode3);
                }
                return;
            }
        }
        ++n2;
        for (DependencyNode dependencyNode4 : dependencyNode.getChildren()) {
            this.selectVersion(dependencyNode4, dependencyNode, n2, map, conflictGroup, map2, dependencyNode3);
        }
    }

    private boolean isAcceptable(ConflictGroup conflictGroup, Version version) {
        for (VersionConstraint versionConstraint : conflictGroup.constraints) {
            if (versionConstraint.containsVersion(version)) continue;
            return false;
        }
        return true;
    }

    private void backtrack(ConflictGroup conflictGroup, Map<?, ?> map, DependencyNode dependencyNode) throws UnsolvableVersionConflictException {
        conflictGroup.version = null;
        Iterator<Map.Entry<DependencyNode, Position>> iterator = conflictGroup.candidates.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<DependencyNode, Position> entry = iterator.next();
            Version version = entry.getKey().getVersion();
            Position position = entry.getValue();
            if (!this.isAcceptable(conflictGroup, version)) {
                iterator.remove();
                continue;
            }
            if (conflictGroup.version != null && !this.isNearer(position, version, conflictGroup.position, conflictGroup.version)) continue;
            conflictGroup.version = version;
            conflictGroup.position = position;
        }
        if (conflictGroup.version == null) {
            throw this.newFailure(conflictGroup, map, dependencyNode);
        }
    }

    private UnsolvableVersionConflictException newFailure(final ConflictGroup conflictGroup, final Map<?, ?> map, DependencyNode dependencyNode) {
        DependencyFilter dependencyFilter = new DependencyFilter(){

            @Override
            public boolean accept(DependencyNode dependencyNode, List<DependencyNode> list) {
                return conflictGroup.key.equals(map.get(dependencyNode));
            }
        };
        PathRecordingDependencyVisitor pathRecordingDependencyVisitor = new PathRecordingDependencyVisitor(dependencyFilter);
        dependencyNode.accept(pathRecordingDependencyVisitor);
        return new UnsolvableVersionConflictException(pathRecordingDependencyVisitor.getPaths(), conflictGroup.key);
    }

    private boolean isNearer(Position position, Version version, Position position2, Version version2) {
        if (position.depth < position2.depth) {
            return true;
        }
        return position.depth == position2.depth && position.parent == position2.parent && version.compareTo(version2) > 0;
    }

    private void pruneNonSelectedVersions(ConflictGroup conflictGroup, Map<?, ?> map) {
        for (Position position : conflictGroup.positions) {
            Iterator<DependencyNode> iterator = position.parent.getChildren().iterator();
            while (iterator.hasNext()) {
                DependencyNode dependencyNode = iterator.next();
                Object obj = map.get(dependencyNode);
                if (!conflictGroup.key.equals(obj)) continue;
                if (!conflictGroup.pruned && conflictGroup.position.depth == position.depth && conflictGroup.version.equals(dependencyNode.getVersion())) {
                    conflictGroup.pruned = true;
                    continue;
                }
                iterator.remove();
            }
        }
    }

    static final class Position {
        final DependencyNode parent;
        final int depth;
        final int hash;

        public Position(DependencyNode dependencyNode, int n2) {
            this.parent = dependencyNode;
            this.depth = n2;
            this.hash = 31 * System.identityHashCode(dependencyNode) + n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Position)) {
                return false;
            }
            Position position = (Position)object;
            return this.parent == position.parent && this.depth == position.depth;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.depth + " > " + this.parent;
        }
    }

    static final class ConflictGroup {
        final Object key;
        final Collection<VersionConstraint> constraints = new HashSet<VersionConstraint>();
        final Map<DependencyNode, Position> candidates = new IdentityHashMap<DependencyNode, Position>(32);
        Version version;
        Position position;
        final Collection<Position> positions = new LinkedHashSet<Position>();
        boolean pruned;

        public ConflictGroup(Object object) {
            this.key = object;
            this.position = new Position(null, Integer.MAX_VALUE);
        }

        public String toString() {
            return this.key + " > " + this.version;
        }
    }
}

