/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.layout;

import java.net.URI;
import java.net.URISyntaxException;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.metadata.Metadata;
import zz.org.sonatype.aether.util.layout.RepositoryLayout;

public class MavenDefaultLayout
implements RepositoryLayout {
    private URI toUri(String string) {
        try {
            return new URI(null, null, string, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }

    public URI getPath(Artifact artifact) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(artifact.getGroupId().replace('.', '/')).append('/');
        stringBuilder.append(artifact.getArtifactId()).append('/');
        stringBuilder.append(artifact.getBaseVersion()).append('/');
        stringBuilder.append(artifact.getArtifactId()).append('-').append(artifact.getVersion());
        if (artifact.getClassifier().length() > 0) {
            stringBuilder.append('-').append(artifact.getClassifier());
        }
        if (artifact.getExtension().length() > 0) {
            stringBuilder.append('.').append(artifact.getExtension());
        }
        return this.toUri(stringBuilder.toString());
    }

    public URI getPath(Metadata metadata) {
        StringBuilder stringBuilder = new StringBuilder(128);
        if (metadata.getGroupId().length() > 0) {
            stringBuilder.append(metadata.getGroupId().replace('.', '/')).append('/');
            if (metadata.getArtifactId().length() > 0) {
                stringBuilder.append(metadata.getArtifactId()).append('/');
                if (metadata.getVersion().length() > 0) {
                    stringBuilder.append(metadata.getVersion()).append('/');
                }
            }
        }
        stringBuilder.append(metadata.getType());
        return this.toUri(stringBuilder.toString());
    }
}

