/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import zz.org.sonatype.aether.AbstractRepositoryListener;
import zz.org.sonatype.aether.RepositoryEvent;
import zz.org.sonatype.aether.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedRepositoryListener
extends AbstractRepositoryListener {
    private final List<RepositoryListener> listeners = new CopyOnWriteArrayList<RepositoryListener>();

    public static RepositoryListener newInstance(RepositoryListener repositoryListener, RepositoryListener repositoryListener2) {
        if (repositoryListener == null) {
            return repositoryListener2;
        }
        if (repositoryListener2 == null) {
            return repositoryListener;
        }
        return new ChainedRepositoryListener(repositoryListener, repositoryListener2);
    }

    public ChainedRepositoryListener(RepositoryListener ... repositoryListenerArray) {
        if (repositoryListenerArray != null) {
            this.add(Arrays.asList(repositoryListenerArray));
        }
    }

    public ChainedRepositoryListener(Collection<RepositoryListener> collection) {
        this.add(collection);
    }

    public void add(Collection<RepositoryListener> collection) {
        if (collection != null) {
            for (RepositoryListener repositoryListener : collection) {
                this.add(repositoryListener);
            }
        }
    }

    public void add(RepositoryListener repositoryListener) {
        if (repositoryListener != null) {
            this.listeners.add(repositoryListener);
        }
    }

    public void remove(RepositoryListener repositoryListener) {
        if (repositoryListener != null) {
            this.listeners.remove(repositoryListener);
        }
    }

    protected void handleError(RepositoryEvent repositoryEvent, RepositoryListener repositoryListener, RuntimeException runtimeException) {
    }

    @Override
    public void artifactDeployed(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDeployed(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactDeploying(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDeploying(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDescriptorInvalid(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDescriptorMissing(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDownloaded(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactDownloading(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactInstalled(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactInstalled(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactInstalling(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactInstalling(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactResolved(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactResolved(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void artifactResolving(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.artifactResolving(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataDeployed(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataDeployed(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataDeploying(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataDeploying(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataDownloaded(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataDownloaded(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataDownloading(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataDownloading(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataInstalled(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataInstalled(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataInstalling(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataInstalling(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataInvalid(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataResolved(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataResolved(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }

    @Override
    public void metadataResolving(RepositoryEvent repositoryEvent) {
        for (RepositoryListener repositoryListener : this.listeners) {
            try {
                repositoryListener.metadataResolving(repositoryEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(repositoryEvent, repositoryListener, runtimeException);
            }
        }
    }
}

