/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.listener;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import zz.org.sonatype.aether.transfer.AbstractTransferListener;
import zz.org.sonatype.aether.transfer.TransferCancelledException;
import zz.org.sonatype.aether.transfer.TransferEvent;
import zz.org.sonatype.aether.transfer.TransferListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedTransferListener
extends AbstractTransferListener {
    private final List<TransferListener> listeners = new CopyOnWriteArrayList<TransferListener>();

    public static TransferListener newInstance(TransferListener transferListener, TransferListener transferListener2) {
        if (transferListener == null) {
            return transferListener2;
        }
        if (transferListener2 == null) {
            return transferListener;
        }
        return new ChainedTransferListener(transferListener, transferListener2);
    }

    public ChainedTransferListener(TransferListener ... transferListenerArray) {
        if (transferListenerArray != null) {
            this.add(Arrays.asList(transferListenerArray));
        }
    }

    public ChainedTransferListener(Collection<TransferListener> collection) {
        this.add(collection);
    }

    public void add(Collection<TransferListener> collection) {
        if (collection != null) {
            for (TransferListener transferListener : collection) {
                this.add(transferListener);
            }
        }
    }

    public void add(TransferListener transferListener) {
        if (transferListener != null) {
            this.listeners.add(transferListener);
        }
    }

    public void remove(TransferListener transferListener) {
        if (transferListener != null) {
            this.listeners.remove(transferListener);
        }
    }

    protected void handleError(TransferEvent transferEvent, TransferListener transferListener, RuntimeException runtimeException) {
    }

    @Override
    public void transferInitiated(TransferEvent transferEvent) throws TransferCancelledException {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferInitiated(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }

    @Override
    public void transferStarted(TransferEvent transferEvent) throws TransferCancelledException {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferStarted(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }

    @Override
    public void transferProgressed(TransferEvent transferEvent) throws TransferCancelledException {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferProgressed(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }

    @Override
    public void transferCorrupted(TransferEvent transferEvent) throws TransferCancelledException {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferCorrupted(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }

    @Override
    public void transferSucceeded(TransferEvent transferEvent) {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferSucceeded(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }

    @Override
    public void transferFailed(TransferEvent transferEvent) {
        for (TransferListener transferListener : this.listeners) {
            try {
                transferListener.transferFailed(transferEvent);
            }
            catch (RuntimeException runtimeException) {
                this.handleError(transferEvent, transferListener, runtimeException);
            }
        }
    }
}

