/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.listener;

import java.io.File;
import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.RepositoryEvent;
import zz.org.sonatype.aether.RepositorySystemSession;
import zz.org.sonatype.aether.RequestTrace;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.metadata.Metadata;
import zz.org.sonatype.aether.repository.ArtifactRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRepositoryEvent
implements RepositoryEvent {
    private RepositoryEvent.EventType type;
    private RepositorySystemSession session;
    private Artifact artifact;
    private Metadata metadata;
    private ArtifactRepository repository;
    private File file;
    private List<Exception> exceptions = Collections.emptyList();
    private RequestTrace trace;

    @Deprecated
    public DefaultRepositoryEvent(RepositoryEvent.EventType eventType, RepositorySystemSession repositorySystemSession) {
        this(eventType, repositorySystemSession, null);
    }

    public DefaultRepositoryEvent(RepositoryEvent.EventType eventType, RepositorySystemSession repositorySystemSession, RequestTrace requestTrace) {
        this.setType(eventType);
        this.setSession(repositorySystemSession);
        this.setTrace(requestTrace);
    }

    @Override
    public RepositoryEvent.EventType getType() {
        return this.type;
    }

    private DefaultRepositoryEvent setType(RepositoryEvent.EventType eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("event type not specified");
        }
        this.type = eventType;
        return this;
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    private DefaultRepositoryEvent setSession(RepositorySystemSession repositorySystemSession) {
        if (repositorySystemSession == null) {
            throw new IllegalArgumentException("session not specified");
        }
        this.session = repositorySystemSession;
        return this;
    }

    @Override
    public Artifact getArtifact() {
        return this.artifact;
    }

    public DefaultRepositoryEvent setArtifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    public DefaultRepositoryEvent setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public ArtifactRepository getRepository() {
        return this.repository;
    }

    public DefaultRepositoryEvent setRepository(ArtifactRepository artifactRepository) {
        this.repository = artifactRepository;
        return this;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public DefaultRepositoryEvent setFile(File file) {
        this.file = file;
        return this;
    }

    @Override
    public Exception getException() {
        return this.exceptions.isEmpty() ? null : this.exceptions.get(0);
    }

    public DefaultRepositoryEvent setException(Exception exception) {
        this.exceptions = exception != null ? Collections.singletonList(exception) : Collections.emptyList();
        return this;
    }

    @Override
    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public DefaultRepositoryEvent setExceptions(List<Exception> list) {
        this.exceptions = list != null ? list : Collections.emptyList();
        return this;
    }

    @Override
    public RequestTrace getTrace() {
        return this.trace;
    }

    public DefaultRepositoryEvent setTrace(RequestTrace requestTrace) {
        this.trace = requestTrace;
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append((Object)this.getType());
        if (this.getArtifact() != null) {
            stringBuilder.append(" ").append(this.getArtifact());
        }
        if (this.getMetadata() != null) {
            stringBuilder.append(" ").append(this.getMetadata());
        }
        if (this.getFile() != null) {
            stringBuilder.append(" (").append(this.getFile()).append(")");
        }
        if (this.getRepository() != null) {
            stringBuilder.append(" @ ").append(this.getRepository());
        }
        return stringBuilder.toString();
    }
}

