/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.listener;

import java.nio.ByteBuffer;
import zz.org.sonatype.aether.transfer.TransferEvent;
import zz.org.sonatype.aether.transfer.TransferResource;

public class DefaultTransferEvent
implements TransferEvent {
    private TransferEvent.EventType type = TransferEvent.EventType.INITIATED;
    private TransferEvent.RequestType requestType = TransferEvent.RequestType.GET;
    private TransferResource resource;
    private ByteBuffer dataBuffer;
    private long transferredBytes;
    private Exception exception;

    public TransferEvent.EventType getType() {
        return this.type;
    }

    public DefaultTransferEvent setType(TransferEvent.EventType eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException("event type not specified");
        }
        this.type = eventType;
        return this;
    }

    public TransferEvent.RequestType getRequestType() {
        return this.requestType;
    }

    public DefaultTransferEvent setRequestType(TransferEvent.RequestType requestType) {
        if (requestType == null) {
            throw new IllegalArgumentException("request type not specified");
        }
        this.requestType = requestType;
        return this;
    }

    public TransferResource getResource() {
        return this.resource;
    }

    public DefaultTransferEvent setResource(TransferResource transferResource) {
        if (transferResource == null) {
            throw new IllegalArgumentException("transfer resource not specified");
        }
        this.resource = transferResource;
        return this;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public DefaultTransferEvent setTransferredBytes(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("number of transferred bytes cannot be negative");
        }
        this.transferredBytes = l2;
        return this;
    }

    public int getDataLength() {
        return this.dataBuffer != null ? this.dataBuffer.remaining() : 0;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer != null ? this.dataBuffer.asReadOnlyBuffer() : null;
    }

    public DefaultTransferEvent setDataBuffer(byte[] byArray, int n2, int n3) {
        return this.setDataBuffer(ByteBuffer.wrap(byArray, n2, n3));
    }

    public DefaultTransferEvent setDataBuffer(ByteBuffer byteBuffer) {
        this.dataBuffer = byteBuffer;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public DefaultTransferEvent setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public String toString() {
        return (Object)((Object)this.getRequestType()) + " " + (Object)((Object)this.getType()) + " " + this.getResource();
    }
}

