/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.repository;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import zz.org.sonatype.aether.artifact.Artifact;
import zz.org.sonatype.aether.repository.WorkspaceReader;
import zz.org.sonatype.aether.repository.WorkspaceRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedWorkspaceReader
implements WorkspaceReader {
    private List<WorkspaceReader> readers = new ArrayList<WorkspaceReader>();
    private WorkspaceRepository repository;

    public ChainedWorkspaceReader(WorkspaceReader ... workspaceReaderArray) {
        if (workspaceReaderArray != null) {
            Collections.addAll(this.readers, workspaceReaderArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (WorkspaceReader workspaceReader : workspaceReaderArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('+');
            }
            stringBuilder.append(workspaceReader.getRepository().getContentType());
        }
        this.repository = new WorkspaceRepository(stringBuilder.toString(), new Key(this.readers));
    }

    public static WorkspaceReader newInstance(WorkspaceReader workspaceReader, WorkspaceReader workspaceReader2) {
        if (workspaceReader == null) {
            return workspaceReader2;
        }
        if (workspaceReader2 == null) {
            return workspaceReader;
        }
        return new ChainedWorkspaceReader(workspaceReader, workspaceReader2);
    }

    @Override
    public File findArtifact(Artifact artifact) {
        WorkspaceReader workspaceReader;
        File file = null;
        Iterator<WorkspaceReader> iterator = this.readers.iterator();
        while (iterator.hasNext() && (file = (workspaceReader = iterator.next()).findArtifact(artifact)) == null) {
        }
        return file;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (WorkspaceReader workspaceReader : this.readers) {
            linkedHashSet.addAll(workspaceReader.findVersions(artifact));
        }
        return Collections.unmodifiableList(new ArrayList(linkedHashSet));
    }

    @Override
    public WorkspaceRepository getRepository() {
        Key key = new Key(this.readers);
        if (!key.equals(this.repository.getKey())) {
            this.repository = new WorkspaceRepository(this.repository.getContentType(), key);
        }
        return this.repository;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Key {
        private final List<Object> keys = new ArrayList<Object>();

        public Key(List<WorkspaceReader> list) {
            for (WorkspaceReader workspaceReader : list) {
                this.keys.add(workspaceReader.getRepository().getKey());
            }
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            return ((Object)this.keys).equals(((Key)object).keys);
        }

        public int hashCode() {
            return ((Object)this.keys).hashCode();
        }
    }
}

