/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import zz.org.sonatype.aether.repository.MirrorSelector;
import zz.org.sonatype.aether.repository.RemoteRepository;

public class DefaultMirrorSelector
implements MirrorSelector {
    private static final String WILDCARD = "*";
    private static final String EXTERNAL_WILDCARD = "external:*";
    private final List<MirrorDef> mirrors = new ArrayList<MirrorDef>();

    public DefaultMirrorSelector add(String string, String string2, String string3, boolean bl2, String string4, String string5) {
        this.mirrors.add(new MirrorDef(string, string2, string3, bl2, string4, string5));
        return this;
    }

    public RemoteRepository getMirror(RemoteRepository remoteRepository) {
        MirrorDef mirrorDef = this.findMirror(remoteRepository);
        if (mirrorDef == null) {
            return null;
        }
        RemoteRepository remoteRepository2 = new RemoteRepository();
        remoteRepository2.setRepositoryManager(mirrorDef.repositoryManager);
        remoteRepository2.setId(mirrorDef.id);
        remoteRepository2.setUrl(mirrorDef.url);
        if (mirrorDef.type != null && mirrorDef.type.length() > 0) {
            remoteRepository2.setContentType(mirrorDef.type);
        } else {
            remoteRepository2.setContentType(remoteRepository.getContentType());
        }
        remoteRepository2.setPolicy(true, remoteRepository.getPolicy(true));
        remoteRepository2.setPolicy(false, remoteRepository.getPolicy(false));
        remoteRepository2.setMirroredRepositories(Collections.singletonList(remoteRepository));
        return remoteRepository2;
    }

    private MirrorDef findMirror(RemoteRepository remoteRepository) {
        String string = remoteRepository.getId();
        if (string != null && !this.mirrors.isEmpty()) {
            for (MirrorDef mirrorDef : this.mirrors) {
                if (!string.equals(mirrorDef.mirrorOfIds) || !DefaultMirrorSelector.matchesType(remoteRepository.getContentType(), mirrorDef.mirrorOfTypes)) continue;
                return mirrorDef;
            }
            for (MirrorDef mirrorDef : this.mirrors) {
                if (!DefaultMirrorSelector.matchPattern(remoteRepository, mirrorDef.mirrorOfIds) || !DefaultMirrorSelector.matchesType(remoteRepository.getContentType(), mirrorDef.mirrorOfTypes)) continue;
                return mirrorDef;
            }
        }
        return null;
    }

    static boolean matchPattern(RemoteRepository remoteRepository, String string) {
        boolean bl2 = false;
        String string2 = remoteRepository.getId();
        if (WILDCARD.equals(string) || string.equals(string2)) {
            bl2 = true;
        } else {
            String[] stringArray;
            for (String string3 : stringArray = string.split(",")) {
                if (string3.length() > 1 && string3.startsWith("!")) {
                    if (!string3.substring(1).equals(string2)) continue;
                    bl2 = false;
                    break;
                }
                if (string3.equals(string2)) {
                    bl2 = true;
                    break;
                }
                if (EXTERNAL_WILDCARD.equals(string3) && DefaultMirrorSelector.isExternalRepo(remoteRepository)) {
                    bl2 = true;
                    continue;
                }
                if (!WILDCARD.equals(string3)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    static boolean isExternalRepo(RemoteRepository remoteRepository) {
        boolean bl2 = "localhost".equals(remoteRepository.getHost()) || "127.0.0.1".equals(remoteRepository.getHost()) || "file".equalsIgnoreCase(remoteRepository.getProtocol());
        return !bl2;
    }

    static boolean matchesType(String string, String string2) {
        boolean bl2 = false;
        if (string2 == null || string2.length() <= 0 || WILDCARD.equals(string2)) {
            bl2 = true;
        } else if (string2.equals(string)) {
            bl2 = true;
        } else {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(",")) {
                if (string3.length() > 1 && string3.startsWith("!")) {
                    if (!string3.substring(1).equals(string)) continue;
                    bl2 = false;
                    break;
                }
                if (string3.equals(string)) {
                    bl2 = true;
                    break;
                }
                if (!WILDCARD.equals(string3)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    static class MirrorDef {
        final String id;
        final String url;
        final String type;
        final boolean repositoryManager;
        final String mirrorOfIds;
        final String mirrorOfTypes;

        public MirrorDef(String string, String string2, String string3, boolean bl2, String string4, String string5) {
            this.id = string;
            this.url = string2;
            this.type = string3;
            this.repositoryManager = bl2;
            this.mirrorOfIds = string4;
            this.mirrorOfTypes = string5;
        }
    }
}

