/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.version;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import zz.org.sonatype.aether.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersion
implements Version {
    private final String version;
    private final Item[] items;
    private final int hash;

    public GenericVersion(String string) {
        this.version = string;
        this.items = GenericVersion.parse(string);
        this.hash = Arrays.hashCode(this.items);
    }

    private static Item[] parse(String string) {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        Tokenizer tokenizer = new Tokenizer(string);
        while (tokenizer.next()) {
            Item item = new Item(tokenizer);
            arrayList.add(item);
        }
        GenericVersion.trimPadding(arrayList);
        return arrayList.toArray(new Item[arrayList.size()]);
    }

    private static void trimPadding(List<Item> list) {
        int n2;
        Boolean bl2 = null;
        for (int i2 = n2 = list.size() - 1; i2 > 0; --i2) {
            Item item = list.get(i2);
            if (!Boolean.valueOf(item.isNumber()).equals(bl2)) {
                n2 = i2;
                bl2 = item.isNumber();
            }
            if (n2 != i2 || i2 != list.size() - 1 && list.get(i2 - 1).isNumber() != item.isNumber() || item.compareTo(null) != 0) continue;
            list.remove(i2);
            --n2;
        }
    }

    @Override
    public int compareTo(Version version) {
        Item[] itemArray = this.items;
        Item[] itemArray2 = ((GenericVersion)version).items;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < itemArray.length || n2 < itemArray2.length) {
            if (n2 >= itemArray.length) {
                return -GenericVersion.comparePadding(itemArray2, n2, null);
            }
            if (n2 >= itemArray2.length) {
                return GenericVersion.comparePadding(itemArray, n2, null);
            }
            Item item = itemArray[n2];
            Item item2 = itemArray2[n2];
            if (item.isNumber() != item2.isNumber()) {
                if (bl2 == item.isNumber()) {
                    return GenericVersion.comparePadding(itemArray, n2, bl2);
                }
                return -GenericVersion.comparePadding(itemArray2, n2, bl2);
            }
            int n3 = item.compareTo(item2);
            if (n3 != 0) {
                return n3;
            }
            bl2 = item.isNumber();
            ++n2;
        }
        return 0;
    }

    private static int comparePadding(Item[] itemArray, int n2, Boolean bl2) {
        int n3 = 0;
        for (int i2 = n2; i2 < itemArray.length; ++i2) {
            Item item = itemArray[i2];
            if (bl2 != null && bl2.booleanValue() != item.isNumber() || (n3 = item.compareTo(null)) != 0) break;
        }
        return n3;
    }

    public boolean equals(Object object) {
        return object instanceof GenericVersion && this.compareTo((GenericVersion)object) == 0;
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public String toString() {
        return this.version;
    }

    static final class Item {
        private static final int KIND_BIGINT = 3;
        private static final int KIND_INT = 2;
        private static final int KIND_STRING = 1;
        private static final int KIND_QUALIFIER = 0;
        private static final Map<String, Integer> QUALIFIERS = new TreeMap<String, Integer>(String.CASE_INSENSITIVE_ORDER);
        private final int kind;
        private final Object value;

        public Item(Tokenizer tokenizer) {
            String string = tokenizer.getToken();
            if (tokenizer.isNumber()) {
                try {
                    if (string.length() < 10) {
                        this.kind = 2;
                        this.value = Integer.parseInt(string);
                    }
                    this.kind = 3;
                    this.value = new BigInteger(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalStateException(numberFormatException);
                }
            } else {
                Integer n2;
                if (tokenizer.isTerminatedByNumber() && string.length() == 1) {
                    switch (string.charAt(0)) {
                        case 'A': 
                        case 'a': {
                            string = "alpha";
                            break;
                        }
                        case 'B': 
                        case 'b': {
                            string = "beta";
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            string = "milestone";
                        }
                    }
                }
                if ((n2 = QUALIFIERS.get(string)) != null) {
                    this.kind = 0;
                    this.value = n2;
                } else {
                    this.kind = 1;
                    this.value = string.toLowerCase(Locale.ENGLISH);
                }
            }
        }

        public boolean isNumber() {
            return this.kind >= 2;
        }

        public int compareTo(Item item) {
            int n2;
            block11: {
                block10: {
                    if (item != null) break block10;
                    switch (this.kind) {
                        case 1: 
                        case 3: {
                            n2 = 1;
                            break block11;
                        }
                        case 0: 
                        case 2: {
                            n2 = (Integer)this.value;
                            break block11;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
                n2 = this.kind - item.kind;
                if (n2 == 0) {
                    switch (this.kind) {
                        case 3: {
                            n2 = ((BigInteger)this.value).compareTo((BigInteger)item.value);
                            break;
                        }
                        case 0: 
                        case 2: {
                            n2 = ((Integer)this.value).compareTo((Integer)item.value);
                            break;
                        }
                        case 1: {
                            n2 = ((String)this.value).compareToIgnoreCase((String)item.value);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown version item kind " + this.kind);
                        }
                    }
                }
            }
            return n2;
        }

        public boolean equals(Object object) {
            return object instanceof Item && this.compareTo((Item)object) == 0;
        }

        public int hashCode() {
            return this.value.hashCode() + this.kind * 31;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        static {
            QUALIFIERS.put("alpha", -5);
            QUALIFIERS.put("beta", -4);
            QUALIFIERS.put("milestone", -3);
            QUALIFIERS.put("cr", -2);
            QUALIFIERS.put("rc", -2);
            QUALIFIERS.put("snapshot", -1);
            QUALIFIERS.put("ga", 0);
            QUALIFIERS.put("final", 0);
            QUALIFIERS.put("", 0);
            QUALIFIERS.put("sp", 1);
        }
    }

    static final class Tokenizer {
        private final String version;
        private int index;
        private String token;
        private boolean number;
        private boolean terminatedByNumber;

        public Tokenizer(String string) {
            this.version = string.length() > 0 ? string : "0";
        }

        public String getToken() {
            return this.token;
        }

        public boolean isNumber() {
            return this.number;
        }

        public boolean isTerminatedByNumber() {
            return this.terminatedByNumber;
        }

        public boolean next() {
            int n2 = this.version.length();
            if (this.index >= n2) {
                return false;
            }
            int n3 = -2;
            int n4 = this.index;
            int n5 = n2;
            this.terminatedByNumber = false;
            while (this.index < n2) {
                char c2 = this.version.charAt(this.index);
                if (c2 == '.' || c2 == '-') {
                    n5 = this.index++;
                    break;
                }
                int n6 = Character.digit(c2, 10);
                if (n6 >= 0) {
                    if (n3 == -1) {
                        n5 = this.index;
                        this.terminatedByNumber = true;
                        break;
                    }
                    if (n3 == 0) {
                        ++n4;
                    }
                    n3 = n3 > 0 || n6 > 0 ? 1 : 0;
                } else {
                    if (n3 >= 0) {
                        n5 = this.index;
                        break;
                    }
                    n3 = -1;
                }
                ++this.index;
            }
            if (n5 - n4 > 0) {
                this.token = this.version.substring(n4, n5);
                this.number = n3 >= 0;
            } else {
                this.token = "0";
                this.number = true;
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.token);
        }
    }
}

