/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.version;

import java.util.Collection;
import java.util.HashSet;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionConstraint;
import zz.org.sonatype.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersionConstraint
implements VersionConstraint {
    private Collection<VersionRange> ranges = new HashSet<VersionRange>();
    private Version version;

    GenericVersionConstraint() {
    }

    public GenericVersionConstraint addRange(VersionRange versionRange) {
        if (versionRange != null) {
            this.ranges.add(versionRange);
        }
        return this;
    }

    @Override
    public Collection<VersionRange> getRanges() {
        return this.ranges;
    }

    public GenericVersionConstraint setVersion(Version version) {
        this.version = version;
        return this;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public boolean containsVersion(Version version) {
        if (this.ranges.isEmpty()) {
            return version.equals(this.version);
        }
        for (VersionRange versionRange : this.ranges) {
            if (!versionRange.containsVersion(version)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        for (VersionRange versionRange : this.getRanges()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(versionRange);
        }
        if (stringBuilder.length() <= 0) {
            stringBuilder.append(this.getVersion());
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GenericVersionConstraint genericVersionConstraint = (GenericVersionConstraint)object;
        return ((Object)this.ranges).equals(genericVersionConstraint.getRanges()) && GenericVersionConstraint.eq(this.version, genericVersionConstraint.getVersion());
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + GenericVersionConstraint.hash(this.getRanges());
        n2 = n2 * 31 + GenericVersionConstraint.hash(this.getVersion());
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }
}

