/*
 * Decompiled with CFR 0.152.
 */
package zz.org.sonatype.aether.util.version;

import zz.org.sonatype.aether.util.version.GenericVersion;
import zz.org.sonatype.aether.version.InvalidVersionSpecificationException;
import zz.org.sonatype.aether.version.Version;
import zz.org.sonatype.aether.version.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GenericVersionRange
implements VersionRange {
    private final Version lowerBound;
    private final boolean lowerBoundInclusive;
    private final Version upperBound;
    private final boolean upperBoundInclusive;

    public GenericVersionRange(String string) throws InvalidVersionSpecificationException {
        String string2 = string;
        if (string.startsWith("[")) {
            this.lowerBoundInclusive = true;
        } else if (string.startsWith("(")) {
            this.lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(string, "Invalid version range " + string + ", a range must start with either [ or (");
        }
        if (string.endsWith("]")) {
            this.upperBoundInclusive = true;
        } else if (string.endsWith(")")) {
            this.upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(string, "Invalid version range " + string + ", a range must end with either [ or (");
        }
        string2 = string2.substring(1, string2.length() - 1);
        int n2 = string2.indexOf(",");
        if (n2 < 0) {
            if (!this.lowerBoundInclusive || !this.upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(string, "Invalid version range " + string + ", single version must be surrounded by []");
            }
            this.lowerBound = this.upperBound = new GenericVersion(string2.trim());
        } else {
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            if (string4.contains(",")) {
                throw new InvalidVersionSpecificationException(string, "Invalid version range " + string + ", bounds may not contain additional ','");
            }
            this.lowerBound = string3.length() > 0 ? new GenericVersion(string3) : null;
            Version version = this.upperBound = string4.length() > 0 ? new GenericVersion(string4) : null;
            if (this.upperBound != null && this.lowerBound != null && this.upperBound.compareTo(this.lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(string, "Invalid version range " + string + ", lower bound must not be greater than upper bound");
            }
        }
    }

    public GenericVersionRange(Version version, boolean bl2, Version version2, boolean bl3) {
        this.lowerBound = version;
        this.lowerBoundInclusive = bl2;
        this.upperBound = version2;
        this.upperBoundInclusive = bl3;
    }

    public Version getLowerBound() {
        return this.lowerBound;
    }

    public boolean isLowerBoundInclusive() {
        return this.lowerBoundInclusive;
    }

    public Version getUpperBound() {
        return this.upperBound;
    }

    public boolean isUpperBoundInclusive() {
        return this.upperBoundInclusive;
    }

    @Override
    public boolean containsVersion(Version version) {
        int n2;
        if (this.lowerBound != null) {
            n2 = this.lowerBound.compareTo(version);
            if (n2 == 0 && !this.lowerBoundInclusive) {
                return false;
            }
            if (n2 > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            n2 = this.upperBound.compareTo(version);
            if (n2 == 0 && !this.upperBoundInclusive) {
                return false;
            }
            if (n2 < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        GenericVersionRange genericVersionRange = (GenericVersionRange)object;
        return this.upperBoundInclusive == genericVersionRange.upperBoundInclusive && this.lowerBoundInclusive == genericVersionRange.lowerBoundInclusive && GenericVersionRange.eq(this.upperBound, genericVersionRange.upperBound) && GenericVersionRange.eq(this.lowerBound, genericVersionRange.lowerBound);
    }

    private static <T> boolean eq(T t2, T t3) {
        return t2 != null ? t2.equals(t3) : t3 == null;
    }

    public int hashCode() {
        int n2 = 17;
        n2 = n2 * 31 + GenericVersionRange.hash(this.upperBound);
        n2 = n2 * 31 + (this.upperBoundInclusive ? 1 : 0);
        n2 = n2 * 31 + GenericVersionRange.hash(this.lowerBound);
        n2 = n2 * 31 + (this.lowerBoundInclusive ? 1 : 0);
        return n2;
    }

    private static int hash(Object object) {
        return object != null ? object.hashCode() : 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.lowerBoundInclusive ? (char)'[' : '(');
        if (this.lowerBound != null) {
            stringBuilder.append(this.lowerBound);
        }
        stringBuilder.append(',');
        if (this.upperBound != null) {
            stringBuilder.append(this.upperBound);
        }
        stringBuilder.append(this.upperBoundInclusive ? (char)']' : ')');
        return stringBuilder.toString();
    }
}

