/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.IOException;
import java.io.InputStream;
import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.delta.DeltaDecoder;

public class DeltaInputStream
extends InputStream {
    public static final int DISTANCE_MIN = 1;
    public static final int DISTANCE_MAX = 256;
    private InputStream in;
    private final DeltaDecoder delta;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public DeltaInputStream(InputStream inputStream, int n2) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = inputStream;
        this.delta = new DeltaDecoder(n2);
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n3 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        try {
            n4 = this.in.read(byArray, n2, n3);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
        if (n4 == -1) {
            return -1;
        }
        this.delta.decode(byArray, n2, n4);
        return n4;
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

