/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import zz.org.tukaani.xz.CorruptedInputException;
import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.lz.LZDecoder;
import zz.org.tukaani.xz.lzma.LZMADecoder;
import zz.org.tukaani.xz.rangecoder.RangeDecoderFromBuffer;

public class LZMA2InputStream
extends InputStream {
    public static final int DICT_SIZE_MIN = 4096;
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    private static final int COMPRESSED_SIZE_MAX = 65536;
    private DataInputStream in;
    private final LZDecoder lz;
    private final RangeDecoderFromBuffer rc = new RangeDecoderFromBuffer(65536);
    private LZMADecoder lzma;
    private int uncompressedSize = 0;
    private boolean isLZMAChunk;
    private boolean needDictReset = true;
    private boolean needProps = true;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public static int getMemoryUsage(int n2) {
        return 104 + LZMA2InputStream.getDictSize(n2) / 1024;
    }

    private static int getDictSize(int n2) {
        if (n2 < 4096 || n2 > 0x7FFFFFF0) {
            throw new IllegalArgumentException("Unsupported dictionary size " + n2);
        }
        return n2 + 15 & 0xFFFFFFF0;
    }

    public LZMA2InputStream(InputStream inputStream, int n2) {
        this(inputStream, n2, null);
    }

    public LZMA2InputStream(InputStream inputStream, int n2, byte[] byArray) {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.in = new DataInputStream(inputStream);
        this.lz = new LZDecoder(LZMA2InputStream.getDictSize(n2), byArray);
        if (byArray != null && byArray.length > 0) {
            this.needDictReset = false;
        }
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached) {
            return -1;
        }
        try {
            int n4 = 0;
            while (n3 > 0) {
                if (this.uncompressedSize == 0) {
                    this.decodeChunkHeader();
                    if (this.endReached) {
                        return n4 == 0 ? -1 : n4;
                    }
                }
                int n5 = Math.min(this.uncompressedSize, n3);
                if (!this.isLZMAChunk) {
                    this.lz.copyUncompressed(this.in, n5);
                } else {
                    this.lz.setLimit(n5);
                    this.lzma.decode();
                    if (!this.rc.isInBufferOK()) {
                        throw new CorruptedInputException();
                    }
                }
                int n6 = this.lz.flush(byArray, n2);
                n2 += n6;
                n3 -= n6;
                n4 += n6;
                this.uncompressedSize -= n6;
                if (this.uncompressedSize != 0 || this.rc.isFinished() && !this.lz.hasPending()) continue;
                throw new CorruptedInputException();
            }
            return n4;
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    private void decodeChunkHeader() throws IOException {
        int n2 = this.in.readUnsignedByte();
        if (n2 == 0) {
            this.endReached = true;
            return;
        }
        if (n2 >= 224 || n2 == 1) {
            this.needProps = true;
            this.needDictReset = false;
            this.lz.reset();
        } else if (this.needDictReset) {
            throw new CorruptedInputException();
        }
        if (n2 >= 128) {
            this.isLZMAChunk = true;
            this.uncompressedSize = (n2 & 0x1F) << 16;
            this.uncompressedSize += this.in.readUnsignedShort() + 1;
            int n3 = this.in.readUnsignedShort() + 1;
            if (n2 >= 192) {
                this.needProps = false;
                this.decodeProps();
            } else {
                if (this.needProps) {
                    throw new CorruptedInputException();
                }
                if (n2 >= 160) {
                    this.lzma.reset();
                }
            }
            this.rc.prepareInputBuffer(this.in, n3);
        } else {
            if (n2 > 2) {
                throw new CorruptedInputException();
            }
            this.isLZMAChunk = false;
            this.uncompressedSize = this.in.readUnsignedShort() + 1;
        }
    }

    private void decodeProps() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.in.readUnsignedByte();
        if (n5 > 224) {
            throw new CorruptedInputException();
        }
        if ((n4 = (n5 -= (n3 = n5 / 45) * 9 * 5) - (n2 = n5 / 9) * 9) + n2 > 4) {
            throw new CorruptedInputException();
        }
        this.lzma = new LZMADecoder(this.lz, this.rc, n4, n2, n3);
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.uncompressedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

