/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import zz.org.tukaani.xz.BlockInputStream;
import zz.org.tukaani.xz.CorruptedInputException;
import zz.org.tukaani.xz.IndexIndicatorException;
import zz.org.tukaani.xz.MemoryLimitException;
import zz.org.tukaani.xz.SeekableInputStream;
import zz.org.tukaani.xz.UnsupportedOptionsException;
import zz.org.tukaani.xz.XZ;
import zz.org.tukaani.xz.XZFormatException;
import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.check.Check;
import zz.org.tukaani.xz.common.DecoderUtil;
import zz.org.tukaani.xz.common.StreamFlags;
import zz.org.tukaani.xz.index.BlockInfo;
import zz.org.tukaani.xz.index.IndexDecoder;

public class SeekableXZInputStream
extends SeekableInputStream {
    private SeekableInputStream in;
    private final int memoryLimit;
    private int indexMemoryUsage = 0;
    private final ArrayList streams = new ArrayList();
    private int checkTypes = 0;
    private long uncompressedSize = 0L;
    private long largestBlockSize = 0L;
    private int blockCount = 0;
    private final BlockInfo curBlockInfo;
    private final BlockInfo queriedBlockInfo;
    private Check check;
    private BlockInputStream blockDecoder = null;
    private long curPos = 0L;
    private long seekPos;
    private boolean seekNeeded = false;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];
    static final boolean $assertionsDisabled = !(class$org$tukaani$xz$SeekableXZInputStream == null ? (class$org$tukaani$xz$SeekableXZInputStream = SeekableXZInputStream.class$("zz.org.tukaani.xz.SeekableXZInputStream")) : class$org$tukaani$xz$SeekableXZInputStream).desiredAssertionStatus();
    static Class class$org$tukaani$xz$SeekableXZInputStream;

    public SeekableXZInputStream(SeekableInputStream seekableInputStream) throws IOException {
        this(seekableInputStream, -1);
    }

    public SeekableXZInputStream(SeekableInputStream seekableInputStream, int n2) throws IOException {
        Object object;
        this.in = seekableInputStream;
        DataInputStream dataInputStream = new DataInputStream(seekableInputStream);
        seekableInputStream.seek(0L);
        byte[] byArray = new byte[XZ.HEADER_MAGIC.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, XZ.HEADER_MAGIC)) {
            throw new XZFormatException();
        }
        long l2 = seekableInputStream.length();
        if ((l2 & 3L) != 0L) {
            throw new CorruptedInputException("XZ file size is not a multiple of 4 bytes");
        }
        byte[] byArray2 = new byte[12];
        long l3 = 0L;
        while (l2 > 0L) {
            long l4;
            IndexDecoder indexDecoder;
            if (l2 < 12L) {
                throw new CorruptedInputException();
            }
            seekableInputStream.seek(l2 - 12L);
            dataInputStream.readFully(byArray2);
            if (byArray2[8] == 0 && byArray2[9] == 0 && byArray2[10] == 0 && byArray2[11] == 0) {
                l3 += 4L;
                l2 -= 4L;
                continue;
            }
            object = DecoderUtil.decodeStreamFooter(byArray2);
            if (((StreamFlags)object).backwardSize >= (l2 -= 12L)) {
                throw new CorruptedInputException("Backward Size in XZ Stream Footer is too big");
            }
            this.check = Check.getInstance(((StreamFlags)object).checkType);
            this.checkTypes |= 1 << ((StreamFlags)object).checkType;
            seekableInputStream.seek(l2 - ((StreamFlags)object).backwardSize);
            try {
                indexDecoder = new IndexDecoder(seekableInputStream, (StreamFlags)object, l3, n2);
            }
            catch (MemoryLimitException memoryLimitException) {
                if (!$assertionsDisabled && n2 < 0) {
                    throw new AssertionError();
                }
                throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, n2 + this.indexMemoryUsage);
            }
            this.indexMemoryUsage += indexDecoder.getMemoryUsage();
            if (n2 >= 0 && !$assertionsDisabled && (n2 -= indexDecoder.getMemoryUsage()) < 0) {
                throw new AssertionError();
            }
            if (this.largestBlockSize < indexDecoder.getLargestBlockSize()) {
                this.largestBlockSize = indexDecoder.getLargestBlockSize();
            }
            if (l2 < (l4 = indexDecoder.getStreamSize() - 12L)) {
                throw new CorruptedInputException("XZ Index indicates too big compressed size for the XZ Stream");
            }
            seekableInputStream.seek(l2 -= l4);
            dataInputStream.readFully(byArray2);
            StreamFlags streamFlags = DecoderUtil.decodeStreamHeader(byArray2);
            if (!DecoderUtil.areStreamFlagsEqual(streamFlags, (StreamFlags)object)) {
                throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
            }
            this.uncompressedSize += indexDecoder.getUncompressedSize();
            if (this.uncompressedSize < 0L) {
                throw new UnsupportedOptionsException("XZ file is too big");
            }
            this.blockCount += indexDecoder.getRecordCount();
            if (this.blockCount < 0) {
                throw new UnsupportedOptionsException("XZ file has over 2147483647 Blocks");
            }
            this.streams.add(indexDecoder);
            l3 = 0L;
        }
        if (!$assertionsDisabled && l2 != 0L) {
            throw new AssertionError();
        }
        this.memoryLimit = n2;
        object = (IndexDecoder)this.streams.get(this.streams.size() - 1);
        for (int i2 = this.streams.size() - 2; i2 >= 0; --i2) {
            IndexDecoder indexDecoder = (IndexDecoder)this.streams.get(i2);
            indexDecoder.setOffsets((IndexDecoder)object);
            object = indexDecoder;
        }
        IndexDecoder indexDecoder = (IndexDecoder)this.streams.get(this.streams.size() - 1);
        this.curBlockInfo = new BlockInfo(indexDecoder);
        this.queriedBlockInfo = new BlockInfo(indexDecoder);
    }

    public int getCheckTypes() {
        return this.checkTypes;
    }

    public int getIndexMemoryUsage() {
        return this.indexMemoryUsage;
    }

    public long getLargestBlockSize() {
        return this.largestBlockSize;
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public long getBlockPos(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.uncompressedOffset;
    }

    public long getBlockSize(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.uncompressedSize;
    }

    public long getBlockCompPos(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.compressedOffset;
    }

    public long getBlockCompSize(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.unpaddedSize + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public int getBlockCheckType(int n2) {
        this.locateBlockByNumber(this.queriedBlockInfo, n2);
        return this.queriedBlockInfo.getCheckType();
    }

    public int getBlockNumber(long l2) {
        this.locateBlockByPos(this.queriedBlockInfo, l2);
        return this.queriedBlockInfo.blockNumber;
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block13: {
            if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            n4 = 0;
            try {
                if (this.seekNeeded) {
                    this.seek();
                }
                if (this.endReached) {
                    return -1;
                }
                while (n3 > 0) {
                    int n5;
                    if (this.blockDecoder == null) {
                        this.seek();
                        if (this.endReached) break;
                    }
                    if ((n5 = this.blockDecoder.read(byArray, n2, n3)) > 0) {
                        this.curPos += (long)n5;
                        n4 += n5;
                        n2 += n5;
                        n3 -= n5;
                        continue;
                    }
                    if (n5 != -1) continue;
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                CorruptedInputException corruptedInputException;
                if (iOException instanceof EOFException) {
                    corruptedInputException = new CorruptedInputException();
                }
                this.exception = corruptedInputException;
                if (n4 != 0) break block13;
                throw corruptedInputException;
            }
        }
        return n4;
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.endReached || this.seekNeeded || this.blockDecoder == null) {
            return 0;
        }
        return this.blockDecoder.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }

    public long length() {
        return this.uncompressedSize;
    }

    public long position() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        return this.seekNeeded ? this.seekPos : this.curPos;
    }

    public void seek(long l2) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (l2 < 0L) {
            throw new XZIOException("Negative seek position: " + l2);
        }
        this.seekPos = l2;
        this.seekNeeded = true;
    }

    public void seekToBlock(int n2) throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (n2 < 0 || n2 >= this.blockCount) {
            throw new XZIOException("Invalid XZ Block number: " + n2);
        }
        this.seekPos = this.getBlockPos(n2);
        this.seekNeeded = true;
    }

    private void seek() throws IOException {
        if (!this.seekNeeded) {
            if (this.curBlockInfo.hasNext()) {
                this.curBlockInfo.setNext();
                this.initBlockDecoder();
                return;
            }
            this.seekPos = this.curPos;
        }
        this.seekNeeded = false;
        if (this.seekPos >= this.uncompressedSize) {
            this.curPos = this.seekPos;
            this.blockDecoder = null;
            this.endReached = true;
            return;
        }
        this.endReached = false;
        this.locateBlockByPos(this.curBlockInfo, this.seekPos);
        if (this.curPos <= this.curBlockInfo.uncompressedOffset || this.curPos > this.seekPos) {
            this.in.seek(this.curBlockInfo.compressedOffset);
            this.check = Check.getInstance(this.curBlockInfo.getCheckType());
            this.initBlockDecoder();
            this.curPos = this.curBlockInfo.uncompressedOffset;
        }
        if (this.seekPos > this.curPos) {
            long l2 = this.seekPos - this.curPos;
            if (this.blockDecoder.skip(l2) != l2) {
                throw new CorruptedInputException();
            }
            this.curPos = this.seekPos;
        }
    }

    private void locateBlockByPos(BlockInfo blockInfo, long l2) {
        IndexDecoder indexDecoder;
        if (l2 < 0L || l2 >= this.uncompressedSize) {
            throw new IndexOutOfBoundsException("Invalid uncompressed position: " + l2);
        }
        int n2 = 0;
        while (!(indexDecoder = (IndexDecoder)this.streams.get(n2)).hasUncompressedOffset(l2)) {
            ++n2;
        }
        indexDecoder.locateBlock(blockInfo, l2);
        if (!$assertionsDisabled && (blockInfo.compressedOffset & 3L) != 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && blockInfo.uncompressedSize <= 0L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && l2 < blockInfo.uncompressedOffset) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && l2 >= blockInfo.uncompressedOffset + blockInfo.uncompressedSize) {
            throw new AssertionError();
        }
    }

    private void locateBlockByNumber(BlockInfo blockInfo, int n2) {
        if (n2 < 0 || n2 >= this.blockCount) {
            throw new IndexOutOfBoundsException("Invalid XZ Block number: " + n2);
        }
        if (blockInfo.blockNumber == n2) {
            return;
        }
        int n3 = 0;
        while (true) {
            IndexDecoder indexDecoder;
            if ((indexDecoder = (IndexDecoder)this.streams.get(n3)).hasRecord(n2)) {
                indexDecoder.setBlockInfo(blockInfo, n2);
                return;
            }
            ++n3;
        }
    }

    private void initBlockDecoder() throws IOException {
        try {
            this.blockDecoder = null;
            this.blockDecoder = new BlockInputStream(this.in, this.check, this.memoryLimit, this.curBlockInfo.unpaddedSize, this.curBlockInfo.uncompressedSize);
        }
        catch (MemoryLimitException memoryLimitException) {
            if (!$assertionsDisabled && this.memoryLimit < 0) {
                throw new AssertionError();
            }
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded() + this.indexMemoryUsage, this.memoryLimit + this.indexMemoryUsage);
        }
        catch (IndexIndicatorException indexIndicatorException) {
            throw new CorruptedInputException();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

