/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import zz.org.tukaani.xz.CorruptedInputException;
import zz.org.tukaani.xz.SingleXZInputStream;
import zz.org.tukaani.xz.XZFormatException;
import zz.org.tukaani.xz.XZIOException;

public class XZInputStream
extends InputStream {
    private final int memoryLimit;
    private InputStream in;
    private SingleXZInputStream xzIn;
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    public XZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public XZInputStream(InputStream inputStream, int n2) throws IOException {
        this.in = inputStream;
        this.memoryLimit = n2;
        this.xzIn = new SingleXZInputStream(inputStream, n2);
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        block11: {
            if (n2 < 0 || n3 < 0 || n2 + n3 < 0 || n2 + n3 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n4 = 0;
            try {
                while (n3 > 0) {
                    int n5;
                    if (this.xzIn == null) {
                        this.prepareNextStream();
                        if (this.endReached) {
                            return n4 == 0 ? -1 : n4;
                        }
                    }
                    if ((n5 = this.xzIn.read(byArray, n2, n3)) > 0) {
                        n4 += n5;
                        n2 += n5;
                        n3 -= n5;
                        continue;
                    }
                    if (n5 != -1) continue;
                    this.xzIn = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n4 != 0) break block11;
                throw iOException;
            }
        }
        return n4;
    }

    private void prepareNextStream() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(this.in);
        byte[] byArray = new byte[12];
        do {
            int n2;
            if ((n2 = dataInputStream.read(byArray, 0, 1)) == -1) {
                this.endReached = true;
                return;
            }
            dataInputStream.readFully(byArray, 1, 3);
        } while (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0);
        dataInputStream.readFully(byArray, 4, 8);
        try {
            this.xzIn = new SingleXZInputStream(this.in, this.memoryLimit, byArray);
        }
        catch (XZFormatException xZFormatException) {
            throw new CorruptedInputException("Garbage after a valid XZ Stream");
        }
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.xzIn == null ? 0 : this.xzIn.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.in != null) {
            try {
                this.in.close();
            }
            finally {
                this.in = null;
            }
        }
    }
}

