/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.check;

import zz.org.tukaani.xz.check.Check;

public class CRC64
extends Check {
    private static final long poly = -3932672073523589310L;
    private static final long[] crcTable = new long[256];
    private long crc = -1L;

    public CRC64() {
        this.size = 8;
        this.name = "CRC64";
    }

    public void update(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4) {
            this.crc = crcTable[(byArray[n2++] ^ (int)this.crc) & 0xFF] ^ this.crc >>> 8;
        }
    }

    public byte[] finish() {
        long l2 = this.crc ^ 0xFFFFFFFFFFFFFFFFL;
        this.crc = -1L;
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(l2 >> i2 * 8);
        }
        return byArray;
    }

    static {
        for (int i2 = 0; i2 < crcTable.length; ++i2) {
            long l2 = i2;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((l2 & 1L) == 1L) {
                    l2 = l2 >>> 1 ^ 0xC96C5795D7870F42L;
                    continue;
                }
                l2 >>>= 1;
            }
            CRC64.crcTable[i2] = l2;
        }
    }
}

