/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.index;

import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.common.Util;

abstract class IndexBase {
    private final XZIOException invalidIndexException;
    long blocksSum = 0L;
    long uncompressedSum = 0L;
    long indexListSize = 0L;
    long recordCount = 0L;

    IndexBase(XZIOException xZIOException) {
        this.invalidIndexException = xZIOException;
    }

    private long getUnpaddedIndexSize() {
        return (long)(1 + Util.getVLISize(this.recordCount)) + this.indexListSize + 4L;
    }

    public long getIndexSize() {
        return this.getUnpaddedIndexSize() + 3L & 0xFFFFFFFFFFFFFFFCL;
    }

    public long getStreamSize() {
        return 12L + this.blocksSum + this.getIndexSize() + 12L;
    }

    int getIndexPaddingSize() {
        return (int)(4L - this.getUnpaddedIndexSize() & 3L);
    }

    void add(long l2, long l3) throws XZIOException {
        this.blocksSum += l2 + 3L & 0xFFFFFFFFFFFFFFFCL;
        this.uncompressedSum += l3;
        this.indexListSize += (long)(Util.getVLISize(l2) + Util.getVLISize(l3));
        ++this.recordCount;
        if (this.blocksSum < 0L || this.uncompressedSum < 0L || this.getIndexSize() > 0x400000000L || this.getStreamSize() < 0L) {
            throw this.invalidIndexException;
        }
    }
}

