/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.index;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CheckedInputStream;
import zz.org.tukaani.xz.CorruptedInputException;
import zz.org.tukaani.xz.XZIOException;
import zz.org.tukaani.xz.check.CRC32;
import zz.org.tukaani.xz.check.Check;
import zz.org.tukaani.xz.check.SHA256;
import zz.org.tukaani.xz.common.DecoderUtil;
import zz.org.tukaani.xz.index.IndexBase;

public class IndexHash
extends IndexBase {
    private Check hash;

    public IndexHash() {
        super(new CorruptedInputException());
        try {
            this.hash = new SHA256();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.hash = new CRC32();
        }
    }

    public void add(long l2, long l3) throws XZIOException {
        super.add(l2, l3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(l2);
        byteBuffer.putLong(l3);
        this.hash.update(byteBuffer.array());
    }

    public void validate(InputStream inputStream) throws IOException {
        java.util.zip.CRC32 cRC32 = new java.util.zip.CRC32();
        cRC32.update(0);
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, cRC32);
        long l2 = DecoderUtil.decodeVLI(checkedInputStream);
        if (l2 != this.recordCount) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        IndexHash indexHash = new IndexHash();
        for (long i2 = 0L; i2 < this.recordCount; ++i2) {
            long l3 = DecoderUtil.decodeVLI(checkedInputStream);
            long l4 = DecoderUtil.decodeVLI(checkedInputStream);
            try {
                indexHash.add(l3, l4);
            }
            catch (XZIOException xZIOException) {
                throw new CorruptedInputException("XZ Index is corrupt");
            }
            if (indexHash.blocksSum <= this.blocksSum && indexHash.uncompressedSum <= this.uncompressedSum && indexHash.indexListSize <= this.indexListSize) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        if (indexHash.blocksSum != this.blocksSum || indexHash.uncompressedSum != this.uncompressedSum || indexHash.indexListSize != this.indexListSize || !Arrays.equals(indexHash.hash.finish(), this.hash.finish())) {
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        DataInputStream dataInputStream = new DataInputStream(checkedInputStream);
        for (int i3 = this.getIndexPaddingSize(); i3 > 0; --i3) {
            if (dataInputStream.readUnsignedByte() == 0) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
        long l5 = cRC32.getValue();
        for (int i4 = 0; i4 < 4; ++i4) {
            if ((l5 >>> i4 * 8 & 0xFFL) == (long)dataInputStream.readUnsignedByte()) continue;
            throw new CorruptedInputException("XZ Index is corrupt");
        }
    }
}

