/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.lz;

import zz.org.tukaani.xz.lz.CRC32Hash;
import zz.org.tukaani.xz.lz.LZEncoder;

final class Hash234
extends CRC32Hash {
    private static final int HASH_2_SIZE = 1024;
    private static final int HASH_2_MASK = 1023;
    private static final int HASH_3_SIZE = 65536;
    private static final int HASH_3_MASK = 65535;
    private final int hash4Mask;
    private final int[] hash2Table = new int[1024];
    private final int[] hash3Table = new int[65536];
    private final int[] hash4Table;
    private int hash2Value = 0;
    private int hash3Value = 0;
    private int hash4Value = 0;

    static int getHash4Size(int n2) {
        int n3 = n2 - 1;
        n3 |= n3 >>> 1;
        n3 |= n3 >>> 2;
        n3 |= n3 >>> 4;
        n3 |= n3 >>> 8;
        n3 >>>= 1;
        if ((n3 |= 0xFFFF) > 0x1000000) {
            n3 >>>= 1;
        }
        return n3 + 1;
    }

    static int getMemoryUsage(int n2) {
        return (66560 + Hash234.getHash4Size(n2)) / 256 + 4;
    }

    Hash234(int n2) {
        this.hash4Table = new int[Hash234.getHash4Size(n2)];
        this.hash4Mask = this.hash4Table.length - 1;
    }

    void calcHashes(byte[] byArray, int n2) {
        int n3 = crcTable[byArray[n2] & 0xFF] ^ byArray[n2 + 1] & 0xFF;
        this.hash2Value = n3 & 0x3FF;
        this.hash3Value = (n3 ^= (byArray[n2 + 2] & 0xFF) << 8) & 0xFFFF;
        this.hash4Value = (n3 ^= crcTable[byArray[n2 + 3] & 0xFF] << 5) & this.hash4Mask;
    }

    int getHash2Pos() {
        return this.hash2Table[this.hash2Value];
    }

    int getHash3Pos() {
        return this.hash3Table[this.hash3Value];
    }

    int getHash4Pos() {
        return this.hash4Table[this.hash4Value];
    }

    void updateTables(int n2) {
        this.hash2Table[this.hash2Value] = n2;
        this.hash3Table[this.hash3Value] = n2;
        this.hash4Table[this.hash4Value] = n2;
    }

    void normalize(int n2) {
        LZEncoder.normalize(this.hash2Table, n2);
        LZEncoder.normalize(this.hash3Table, n2);
        LZEncoder.normalize(this.hash4Table, n2);
    }
}

