/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.lz;

import java.io.DataInputStream;
import java.io.IOException;
import zz.org.tukaani.xz.CorruptedInputException;

public final class LZDecoder {
    private final byte[] buf;
    private int start = 0;
    private int pos = 0;
    private int full = 0;
    private int limit = 0;
    private int pendingLen = 0;
    private int pendingDist = 0;

    public LZDecoder(int n2, byte[] byArray) {
        this.buf = new byte[n2];
        if (byArray != null) {
            this.full = this.pos = Math.min(byArray.length, n2);
            this.start = this.pos;
            System.arraycopy(byArray, byArray.length - this.pos, this.buf, 0, this.pos);
        }
    }

    public void reset() {
        this.start = 0;
        this.pos = 0;
        this.full = 0;
        this.limit = 0;
        this.buf[this.buf.length - 1] = 0;
    }

    public void setLimit(int n2) {
        this.limit = this.buf.length - this.pos <= n2 ? this.buf.length : this.pos + n2;
    }

    public boolean hasSpace() {
        return this.pos < this.limit;
    }

    public boolean hasPending() {
        return this.pendingLen > 0;
    }

    public int getPos() {
        return this.pos;
    }

    public int getByte(int n2) {
        int n3 = this.pos - n2 - 1;
        if (n2 >= this.pos) {
            n3 += this.buf.length;
        }
        return this.buf[n3] & 0xFF;
    }

    public void putByte(byte by2) {
        this.buf[this.pos++] = by2;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeat(int n2, int n3) throws IOException {
        if (n2 < 0 || n2 >= this.full) {
            throw new CorruptedInputException();
        }
        int n4 = Math.min(this.limit - this.pos, n3);
        this.pendingLen = n3 - n4;
        this.pendingDist = n2;
        int n5 = this.pos - n2 - 1;
        if (n2 >= this.pos) {
            n5 += this.buf.length;
        }
        do {
            this.buf[this.pos++] = this.buf[n5++];
            if (n5 != this.buf.length) continue;
            n5 = 0;
        } while (--n4 > 0);
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public void repeatPending() throws IOException {
        if (this.pendingLen > 0) {
            this.repeat(this.pendingDist, this.pendingLen);
        }
    }

    public void copyUncompressed(DataInputStream dataInputStream, int n2) throws IOException {
        int n3 = Math.min(this.buf.length - this.pos, n2);
        dataInputStream.readFully(this.buf, this.pos, n3);
        this.pos += n3;
        if (this.full < this.pos) {
            this.full = this.pos;
        }
    }

    public int flush(byte[] byArray, int n2) {
        int n3 = this.pos - this.start;
        if (this.pos == this.buf.length) {
            this.pos = 0;
        }
        System.arraycopy(this.buf, this.start, byArray, n2, n3);
        this.start = this.pos;
        return n3;
    }
}

