/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.lzma;

import zz.org.tukaani.xz.lzma.State;
import zz.org.tukaani.xz.rangecoder.RangeCoder;

abstract class LZMACoder {
    static final int POS_STATES_MAX = 16;
    static final int MATCH_LEN_MIN = 2;
    static final int MATCH_LEN_MAX = 273;
    static final int DIST_STATES = 4;
    static final int DIST_SLOTS = 64;
    static final int DIST_MODEL_START = 4;
    static final int DIST_MODEL_END = 14;
    static final int FULL_DISTANCES = 128;
    static final int ALIGN_BITS = 4;
    static final int ALIGN_SIZE = 16;
    static final int ALIGN_MASK = 15;
    static final int REPS = 4;
    final int posMask;
    final int[] reps = new int[4];
    final State state = new State();
    final short[][] isMatch = new short[12][16];
    final short[] isRep = new short[12];
    final short[] isRep0 = new short[12];
    final short[] isRep1 = new short[12];
    final short[] isRep2 = new short[12];
    final short[][] isRep0Long = new short[12][16];
    final short[][] distSlots = new short[4][64];
    final short[][] distSpecial = new short[][]{new short[2], new short[2], new short[4], new short[4], new short[8], new short[8], new short[16], new short[16], new short[32], new short[32]};
    final short[] distAlign = new short[16];

    static final int getDistState(int n2) {
        return n2 < 6 ? n2 - 2 : 3;
    }

    LZMACoder(int n2) {
        this.posMask = (1 << n2) - 1;
    }

    void reset() {
        int n2;
        this.reps[0] = 0;
        this.reps[1] = 0;
        this.reps[2] = 0;
        this.reps[3] = 0;
        this.state.reset();
        for (n2 = 0; n2 < this.isMatch.length; ++n2) {
            RangeCoder.initProbs(this.isMatch[n2]);
        }
        RangeCoder.initProbs(this.isRep);
        RangeCoder.initProbs(this.isRep0);
        RangeCoder.initProbs(this.isRep1);
        RangeCoder.initProbs(this.isRep2);
        for (n2 = 0; n2 < this.isRep0Long.length; ++n2) {
            RangeCoder.initProbs(this.isRep0Long[n2]);
        }
        for (n2 = 0; n2 < this.distSlots.length; ++n2) {
            RangeCoder.initProbs(this.distSlots[n2]);
        }
        for (n2 = 0; n2 < this.distSpecial.length; ++n2) {
            RangeCoder.initProbs(this.distSpecial[n2]);
        }
        RangeCoder.initProbs(this.distAlign);
    }

    abstract class LengthCoder {
        static final int LOW_SYMBOLS = 8;
        static final int MID_SYMBOLS = 8;
        static final int HIGH_SYMBOLS = 256;
        final short[] choice;
        final short[][] low;
        final short[][] mid;
        final short[] high;
        private final LZMACoder this$0;

        LengthCoder(LZMACoder lZMACoder) {
            this.this$0 = lZMACoder;
            this.choice = new short[2];
            this.low = new short[16][8];
            this.mid = new short[16][8];
            this.high = new short[256];
        }

        void reset() {
            int n2;
            RangeCoder.initProbs(this.choice);
            for (n2 = 0; n2 < this.low.length; ++n2) {
                RangeCoder.initProbs(this.low[n2]);
            }
            for (n2 = 0; n2 < this.low.length; ++n2) {
                RangeCoder.initProbs(this.mid[n2]);
            }
            RangeCoder.initProbs(this.high);
        }
    }

    abstract class LiteralCoder {
        private final int lc;
        private final int literalPosMask;
        private final LZMACoder this$0;

        LiteralCoder(LZMACoder lZMACoder, int n2, int n3) {
            this.this$0 = lZMACoder;
            this.lc = n2;
            this.literalPosMask = (1 << n3) - 1;
        }

        final int getSubcoderIndex(int n2, int n3) {
            int n4 = n2 >> 8 - this.lc;
            int n5 = (n3 & this.literalPosMask) << this.lc;
            return n4 + n5;
        }

        abstract class LiteralSubcoder {
            final short[] probs;
            private final LiteralCoder this$1;

            LiteralSubcoder(LiteralCoder literalCoder) {
                this.this$1 = literalCoder;
                this.probs = new short[768];
            }

            void reset() {
                RangeCoder.initProbs(this.probs);
            }
        }
    }
}

