/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.lzma;

import zz.org.tukaani.xz.lz.LZEncoder;
import zz.org.tukaani.xz.lz.Matches;
import zz.org.tukaani.xz.lzma.LZMACoder;
import zz.org.tukaani.xz.lzma.LZMAEncoderFast;
import zz.org.tukaani.xz.lzma.LZMAEncoderNormal;
import zz.org.tukaani.xz.lzma.State;
import zz.org.tukaani.xz.rangecoder.RangeEncoder;

public abstract class LZMAEncoder
extends LZMACoder {
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    private static final int LZMA2_UNCOMPRESSED_LIMIT = 0x1FFEEF;
    private static final int LZMA2_COMPRESSED_LIMIT = 65510;
    private static final int DIST_PRICE_UPDATE_INTERVAL = 128;
    private static final int ALIGN_PRICE_UPDATE_INTERVAL = 16;
    private final RangeEncoder rc;
    final LZEncoder lz;
    final LiteralEncoder literalEncoder;
    final LengthEncoder matchLenEncoder;
    final LengthEncoder repLenEncoder;
    final int niceLen;
    private int distPriceCount = 0;
    private int alignPriceCount = 0;
    private final int distSlotPricesSize;
    private final int[][] distSlotPrices;
    private final int[][] fullDistPrices = new int[4][128];
    private final int[] alignPrices = new int[16];
    int back = 0;
    int readAhead = -1;
    private int uncompressedSize = 0;
    static final boolean $assertionsDisabled = !(class$org$tukaani$xz$lzma$LZMAEncoder == null ? (class$org$tukaani$xz$lzma$LZMAEncoder = LZMAEncoder.class$("zz.org.tukaani.xz.lzma.LZMAEncoder")) : class$org$tukaani$xz$lzma$LZMAEncoder).desiredAssertionStatus();
    static Class class$org$tukaani$xz$lzma$LZMAEncoder;

    public static int getMemoryUsage(int n2, int n3, int n4, int n5) {
        int n6 = 80;
        switch (n2) {
            case 1: {
                n6 += LZMAEncoderFast.getMemoryUsage(n3, n4, n5);
                break;
            }
            case 2: {
                n6 += LZMAEncoderNormal.getMemoryUsage(n3, n4, n5);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return n6;
    }

    public static LZMAEncoder getInstance(RangeEncoder rangeEncoder, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        switch (n5) {
            case 1: {
                return new LZMAEncoderFast(rangeEncoder, n2, n3, n4, n6, n7, n8, n9, n10);
            }
            case 2: {
                return new LZMAEncoderNormal(rangeEncoder, n2, n3, n4, n6, n7, n8, n9, n10);
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getDistSlot(int n2) {
        if (n2 <= 4) {
            return n2;
        }
        int n3 = n2;
        int n4 = 31;
        if ((n3 & 0xFFFF0000) == 0) {
            n3 <<= 16;
            n4 = 15;
        }
        if ((n3 & 0xFF000000) == 0) {
            n3 <<= 8;
            n4 -= 8;
        }
        if ((n3 & 0xF0000000) == 0) {
            n3 <<= 4;
            n4 -= 4;
        }
        if ((n3 & 0xC0000000) == 0) {
            n3 <<= 2;
            n4 -= 2;
        }
        if ((n3 & Integer.MIN_VALUE) == 0) {
            --n4;
        }
        return (n4 << 1) + (n2 >>> n4 - 1 & 1);
    }

    abstract int getNextSymbol();

    LZMAEncoder(RangeEncoder rangeEncoder, LZEncoder lZEncoder, int n2, int n3, int n4, int n5, int n6) {
        super(n4);
        this.rc = rangeEncoder;
        this.lz = lZEncoder;
        this.niceLen = n6;
        this.literalEncoder = new LiteralEncoder(this, n2, n3);
        this.matchLenEncoder = new LengthEncoder(this, n4, n6);
        this.repLenEncoder = new LengthEncoder(this, n4, n6);
        this.distSlotPricesSize = LZMAEncoder.getDistSlot(n5 - 1) + 1;
        this.distSlotPrices = new int[4][this.distSlotPricesSize];
        this.reset();
    }

    public LZEncoder getLZEncoder() {
        return this.lz;
    }

    public void reset() {
        super.reset();
        this.literalEncoder.reset();
        this.matchLenEncoder.reset();
        this.repLenEncoder.reset();
        this.distPriceCount = 0;
        this.alignPriceCount = 0;
        this.uncompressedSize += this.readAhead + 1;
        this.readAhead = -1;
    }

    public int getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void resetUncompressedSize() {
        this.uncompressedSize = 0;
    }

    public boolean encodeForLZMA2() {
        if (!this.lz.isStarted() && !this.encodeInit()) {
            return false;
        }
        while (this.uncompressedSize <= 0x1FFEEF && this.rc.getPendingSize() <= 65510) {
            if (this.encodeSymbol()) continue;
            return false;
        }
        return true;
    }

    private boolean encodeInit() {
        if (!$assertionsDisabled && this.readAhead != -1) {
            throw new AssertionError();
        }
        if (!this.lz.hasEnoughData(0)) {
            return false;
        }
        this.skip(1);
        this.rc.encodeBit(this.isMatch[this.state.get()], 0, 0);
        this.literalEncoder.encodeInit();
        --this.readAhead;
        if (!$assertionsDisabled && this.readAhead != -1) {
            throw new AssertionError();
        }
        ++this.uncompressedSize;
        if (!$assertionsDisabled && this.uncompressedSize != 1) {
            throw new AssertionError();
        }
        return true;
    }

    private boolean encodeSymbol() {
        if (!this.lz.hasEnoughData(this.readAhead + 1)) {
            return false;
        }
        int n2 = this.getNextSymbol();
        if (!$assertionsDisabled && this.readAhead < 0) {
            throw new AssertionError();
        }
        int n3 = this.lz.getPos() - this.readAhead & this.posMask;
        if (this.back == -1) {
            if (!$assertionsDisabled && n2 != 1) {
                throw new AssertionError();
            }
            this.rc.encodeBit(this.isMatch[this.state.get()], n3, 0);
            this.literalEncoder.encode();
        } else {
            this.rc.encodeBit(this.isMatch[this.state.get()], n3, 1);
            if (this.back < 4) {
                if (!$assertionsDisabled && this.lz.getMatchLen(-this.readAhead, this.reps[this.back], n2) != n2) {
                    throw new AssertionError();
                }
                this.rc.encodeBit(this.isRep, this.state.get(), 1);
                this.encodeRepMatch(this.back, n2, n3);
            } else {
                if (!$assertionsDisabled && this.lz.getMatchLen(-this.readAhead, this.back - 4, n2) != n2) {
                    throw new AssertionError();
                }
                this.rc.encodeBit(this.isRep, this.state.get(), 0);
                this.encodeMatch(this.back - 4, n2, n3);
            }
        }
        this.readAhead -= n2;
        this.uncompressedSize += n2;
        return true;
    }

    private void encodeMatch(int n2, int n3, int n4) {
        this.state.updateMatch();
        this.matchLenEncoder.encode(n3, n4);
        int n5 = LZMAEncoder.getDistSlot(n2);
        this.rc.encodeBitTree(this.distSlots[LZMAEncoder.getDistState(n3)], n5);
        if (n5 >= 4) {
            int n6 = (n5 >>> 1) - 1;
            int n7 = (2 | n5 & 1) << n6;
            int n8 = n2 - n7;
            if (n5 < 14) {
                this.rc.encodeReverseBitTree(this.distSpecial[n5 - 4], n8);
            } else {
                this.rc.encodeDirectBits(n8 >>> 4, n6 - 4);
                this.rc.encodeReverseBitTree(this.distAlign, n8 & 0xF);
                --this.alignPriceCount;
            }
        }
        this.reps[3] = this.reps[2];
        this.reps[2] = this.reps[1];
        this.reps[1] = this.reps[0];
        this.reps[0] = n2;
        --this.distPriceCount;
    }

    private void encodeRepMatch(int n2, int n3, int n4) {
        if (n2 == 0) {
            this.rc.encodeBit(this.isRep0, this.state.get(), 0);
            this.rc.encodeBit(this.isRep0Long[this.state.get()], n4, n3 == 1 ? 0 : 1);
        } else {
            int n5 = this.reps[n2];
            this.rc.encodeBit(this.isRep0, this.state.get(), 1);
            if (n2 == 1) {
                this.rc.encodeBit(this.isRep1, this.state.get(), 0);
            } else {
                this.rc.encodeBit(this.isRep1, this.state.get(), 1);
                this.rc.encodeBit(this.isRep2, this.state.get(), n2 - 2);
                if (n2 == 3) {
                    this.reps[3] = this.reps[2];
                }
                this.reps[2] = this.reps[1];
            }
            this.reps[1] = this.reps[0];
            this.reps[0] = n5;
        }
        if (n3 == 1) {
            this.state.updateShortRep();
        } else {
            this.repLenEncoder.encode(n3, n4);
            this.state.updateLongRep();
        }
    }

    Matches getMatches() {
        ++this.readAhead;
        Matches matches = this.lz.getMatches();
        if (!$assertionsDisabled && !this.lz.verifyMatches(matches)) {
            throw new AssertionError();
        }
        return matches;
    }

    void skip(int n2) {
        this.readAhead += n2;
        this.lz.skip(n2);
    }

    int getAnyMatchPrice(State state, int n2) {
        return RangeEncoder.getBitPrice(this.isMatch[state.get()][n2], 1);
    }

    int getNormalMatchPrice(int n2, State state) {
        return n2 + RangeEncoder.getBitPrice(this.isRep[state.get()], 0);
    }

    int getAnyRepPrice(int n2, State state) {
        return n2 + RangeEncoder.getBitPrice(this.isRep[state.get()], 1);
    }

    int getShortRepPrice(int n2, State state, int n3) {
        return n2 + RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][n3], 0);
    }

    int getLongRepPrice(int n2, int n3, State state, int n4) {
        int n5 = n2;
        if (n3 == 0) {
            n5 += RangeEncoder.getBitPrice(this.isRep0[state.get()], 0) + RangeEncoder.getBitPrice(this.isRep0Long[state.get()][n4], 1);
        } else {
            n5 += RangeEncoder.getBitPrice(this.isRep0[state.get()], 1);
            n5 = n3 == 1 ? (n5 += RangeEncoder.getBitPrice(this.isRep1[state.get()], 0)) : (n5 += RangeEncoder.getBitPrice(this.isRep1[state.get()], 1) + RangeEncoder.getBitPrice(this.isRep2[state.get()], n3 - 2));
        }
        return n5;
    }

    int getLongRepAndLenPrice(int n2, int n3, State state, int n4) {
        int n5 = this.getAnyMatchPrice(state, n4);
        int n6 = this.getAnyRepPrice(n5, state);
        int n7 = this.getLongRepPrice(n6, n2, state, n4);
        return n7 + this.repLenEncoder.getPrice(n3, n4);
    }

    int getMatchAndLenPrice(int n2, int n3, int n4, int n5) {
        int n6 = n2 + this.matchLenEncoder.getPrice(n4, n5);
        int n7 = LZMAEncoder.getDistState(n4);
        if (n3 < 128) {
            n6 += this.fullDistPrices[n7][n3];
        } else {
            int n8 = LZMAEncoder.getDistSlot(n3);
            n6 += this.distSlotPrices[n7][n8] + this.alignPrices[n3 & 0xF];
        }
        return n6;
    }

    private void updateDistPrices() {
        int n2;
        int n3;
        int n4;
        this.distPriceCount = 128;
        for (n4 = 0; n4 < 4; ++n4) {
            for (n3 = 0; n3 < this.distSlotPricesSize; ++n3) {
                this.distSlotPrices[n4][n3] = RangeEncoder.getBitTreePrice(this.distSlots[n4], n3);
            }
            n3 = 14;
            while (n3 < this.distSlotPricesSize) {
                n2 = (n3 >>> 1) - 1 - 4;
                int[] nArray = this.distSlotPrices[n4];
                int n5 = n3++;
                nArray[n5] = nArray[n5] + RangeEncoder.getDirectBitsPrice(n2);
            }
            for (n3 = 0; n3 < 4; ++n3) {
                this.fullDistPrices[n4][n3] = this.distSlotPrices[n4][n3];
            }
        }
        n4 = 4;
        for (n3 = 4; n3 < 14; ++n3) {
            n2 = (n3 >>> 1) - 1;
            int n6 = (2 | n3 & 1) << n2;
            int n7 = this.distSpecial[n3 - 4].length;
            for (int i2 = 0; i2 < n7; ++i2) {
                int n8 = n4 - n6;
                int n9 = RangeEncoder.getReverseBitTreePrice(this.distSpecial[n3 - 4], n8);
                for (int i3 = 0; i3 < 4; ++i3) {
                    this.fullDistPrices[i3][n4] = this.distSlotPrices[i3][n3] + n9;
                }
                ++n4;
            }
        }
        if (!$assertionsDisabled && n4 != 128) {
            throw new AssertionError();
        }
    }

    private void updateAlignPrices() {
        this.alignPriceCount = 16;
        for (int i2 = 0; i2 < 16; ++i2) {
            this.alignPrices[i2] = RangeEncoder.getReverseBitTreePrice(this.distAlign, i2);
        }
    }

    void updatePrices() {
        if (this.distPriceCount <= 0) {
            this.updateDistPrices();
        }
        if (this.alignPriceCount <= 0) {
            this.updateAlignPrices();
        }
        this.matchLenEncoder.updatePrices();
        this.repLenEncoder.updatePrices();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static RangeEncoder access$200(LZMAEncoder lZMAEncoder) {
        return lZMAEncoder.rc;
    }

    static class 1 {
    }

    class LengthEncoder
    extends LZMACoder.LengthCoder {
        private static final int PRICE_UPDATE_INTERVAL = 32;
        private final int[] counters;
        private final int[][] prices;
        private final LZMAEncoder this$0;

        LengthEncoder(LZMAEncoder lZMAEncoder, int n2, int n3) {
            this.this$0 = lZMAEncoder;
            super(lZMAEncoder);
            int n4 = 1 << n2;
            this.counters = new int[n4];
            int n5 = Math.max(n3 - 2 + 1, 16);
            this.prices = new int[n4][n5];
        }

        void reset() {
            super.reset();
            for (int i2 = 0; i2 < this.counters.length; ++i2) {
                this.counters[i2] = 0;
            }
        }

        void encode(int n2, int n3) {
            if ((n2 -= 2) < 8) {
                LZMAEncoder.access$200(this.this$0).encodeBit(this.choice, 0, 0);
                LZMAEncoder.access$200(this.this$0).encodeBitTree(this.low[n3], n2);
            } else {
                LZMAEncoder.access$200(this.this$0).encodeBit(this.choice, 0, 1);
                if ((n2 -= 8) < 8) {
                    LZMAEncoder.access$200(this.this$0).encodeBit(this.choice, 1, 0);
                    LZMAEncoder.access$200(this.this$0).encodeBitTree(this.mid[n3], n2);
                } else {
                    LZMAEncoder.access$200(this.this$0).encodeBit(this.choice, 1, 1);
                    LZMAEncoder.access$200(this.this$0).encodeBitTree(this.high, n2 - 8);
                }
            }
            int n4 = n3;
            this.counters[n4] = this.counters[n4] - 1;
        }

        int getPrice(int n2, int n3) {
            return this.prices[n3][n2 - 2];
        }

        void updatePrices() {
            for (int i2 = 0; i2 < this.counters.length; ++i2) {
                if (this.counters[i2] > 0) continue;
                this.counters[i2] = 32;
                this.updatePrices(i2);
            }
        }

        private void updatePrices(int n2) {
            int n3;
            int n4 = RangeEncoder.getBitPrice(this.choice[0], 0);
            for (n3 = 0; n3 < 8; ++n3) {
                this.prices[n2][n3] = n4 + RangeEncoder.getBitTreePrice(this.low[n2], n3);
            }
            n4 = RangeEncoder.getBitPrice(this.choice[0], 1);
            int n5 = RangeEncoder.getBitPrice(this.choice[1], 0);
            while (n3 < 16) {
                this.prices[n2][n3] = n4 + n5 + RangeEncoder.getBitTreePrice(this.mid[n2], n3 - 8);
                ++n3;
            }
            n5 = RangeEncoder.getBitPrice(this.choice[1], 1);
            while (n3 < this.prices[n2].length) {
                this.prices[n2][n3] = n4 + n5 + RangeEncoder.getBitTreePrice(this.high, n3 - 8 - 8);
                ++n3;
            }
        }
    }

    class LiteralEncoder
    extends LZMACoder.LiteralCoder {
        LiteralSubencoder[] subencoders;
        static final boolean $assertionsDisabled = !(class$org$tukaani$xz$lzma$LZMAEncoder == null ? (class$org$tukaani$xz$lzma$LZMAEncoder = LZMAEncoder.class$("zz.org.tukaani.xz.lzma.LZMAEncoder")) : class$org$tukaani$xz$lzma$LZMAEncoder).desiredAssertionStatus();
        private final LZMAEncoder this$0;

        LiteralEncoder(LZMAEncoder lZMAEncoder, int n2, int n3) {
            this.this$0 = lZMAEncoder;
            super(lZMAEncoder, n2, n3);
            this.subencoders = new LiteralSubencoder[1 << n2 + n3];
            for (int i2 = 0; i2 < this.subencoders.length; ++i2) {
                this.subencoders[i2] = new LiteralSubencoder(this, null);
            }
        }

        void reset() {
            for (int i2 = 0; i2 < this.subencoders.length; ++i2) {
                this.subencoders[i2].reset();
            }
        }

        void encodeInit() {
            if (!$assertionsDisabled && this.this$0.readAhead < 0) {
                throw new AssertionError();
            }
            this.subencoders[0].encode();
        }

        void encode() {
            if (!$assertionsDisabled && this.this$0.readAhead < 0) {
                throw new AssertionError();
            }
            int n2 = this.getSubcoderIndex(this.this$0.lz.getByte(1 + this.this$0.readAhead), this.this$0.lz.getPos() - this.this$0.readAhead);
            this.subencoders[n2].encode();
        }

        int getPrice(int n2, int n3, int n4, int n5, State state) {
            int n6 = RangeEncoder.getBitPrice(this.this$0.isMatch[state.get()][n5 & this.this$0.posMask], 0);
            int n7 = this.getSubcoderIndex(n4, n5);
            return n6 += state.isLiteral() ? this.subencoders[n7].getNormalPrice(n2) : this.subencoders[n7].getMatchedPrice(n2, n3);
        }

        static LZMAEncoder access$100(LiteralEncoder literalEncoder) {
            return literalEncoder.this$0;
        }

        private class LiteralSubencoder
        extends LZMACoder.LiteralCoder.LiteralSubcoder {
            private final LiteralEncoder this$1;

            private LiteralSubencoder(LiteralEncoder literalEncoder) {
                this.this$1 = literalEncoder;
                super(literalEncoder);
            }

            void encode() {
                int n2 = LiteralEncoder.access$100((LiteralEncoder)this.this$1).lz.getByte(LiteralEncoder.access$100((LiteralEncoder)this.this$1).readAhead) | 0x100;
                if (LiteralEncoder.access$100((LiteralEncoder)this.this$1).state.isLiteral()) {
                    do {
                        int n3 = n2 >>> 8;
                        int n4 = n2 >>> 7 & 1;
                        LZMAEncoder.access$200(LiteralEncoder.access$100(this.this$1)).encodeBit(this.probs, n3, n4);
                    } while ((n2 <<= 1) < 65536);
                } else {
                    int n5 = LiteralEncoder.access$100((LiteralEncoder)this.this$1).lz.getByte(LiteralEncoder.access$100((LiteralEncoder)this.this$1).reps[0] + 1 + LiteralEncoder.access$100((LiteralEncoder)this.this$1).readAhead);
                    int n6 = 256;
                    do {
                        int n7 = (n5 <<= 1) & n6;
                        int n8 = n6 + n7 + (n2 >>> 8);
                        int n9 = n2 >>> 7 & 1;
                        LZMAEncoder.access$200(LiteralEncoder.access$100(this.this$1)).encodeBit(this.probs, n8, n9);
                        n6 &= ~(n5 ^ (n2 <<= 1));
                    } while (n2 < 65536);
                }
                LiteralEncoder.access$100((LiteralEncoder)this.this$1).state.updateLiteral();
            }

            int getNormalPrice(int n2) {
                int n3 = 0;
                n2 |= 0x100;
                do {
                    int n4 = n2 >>> 8;
                    int n5 = n2 >>> 7 & 1;
                    n3 += RangeEncoder.getBitPrice(this.probs[n4], n5);
                } while ((n2 <<= 1) < 65536);
                return n3;
            }

            int getMatchedPrice(int n2, int n3) {
                int n4 = 0;
                int n5 = 256;
                n2 |= 0x100;
                do {
                    int n6 = (n3 <<= 1) & n5;
                    int n7 = n5 + n6 + (n2 >>> 8);
                    int n8 = n2 >>> 7 & 1;
                    n4 += RangeEncoder.getBitPrice(this.probs[n7], n8);
                    n5 &= ~(n3 ^ (n2 <<= 1));
                } while (n2 < 65536);
                return n4;
            }

            LiteralSubencoder(LiteralEncoder literalEncoder, 1 var2_2) {
                this(literalEncoder);
            }
        }
    }
}

