/*
 * Decompiled with CFR 0.152.
 */
package zz.org.tukaani.xz.rangecoder;

import java.io.IOException;
import java.io.OutputStream;
import zz.org.tukaani.xz.rangecoder.RangeCoder;

public final class RangeEncoder
extends RangeCoder {
    private static final int MOVE_REDUCING_BITS = 4;
    private static final int BIT_PRICE_SHIFT_BITS = 4;
    private static final int[] prices;
    private long low;
    private int range;
    private int cacheSize;
    private byte cache;
    private final byte[] buf;
    private int bufPos;
    static final boolean $assertionsDisabled;
    static Class class$org$tukaani$xz$rangecoder$RangeEncoder;

    public RangeEncoder(int n2) {
        this.buf = new byte[n2];
        this.reset();
    }

    public void reset() {
        this.low = 0L;
        this.range = -1;
        this.cache = 0;
        this.cacheSize = 1;
        this.bufPos = 0;
    }

    public int getPendingSize() {
        return this.bufPos + this.cacheSize + 5 - 1;
    }

    public int finish() {
        for (int i2 = 0; i2 < 5; ++i2) {
            this.shiftLow();
        }
        return this.bufPos;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.bufPos);
    }

    private void shiftLow() {
        int n2 = (int)(this.low >>> 32);
        if (n2 != 0 || this.low < 0xFF000000L) {
            int n3 = this.cache;
            do {
                this.buf[this.bufPos++] = (byte)(n3 + n2);
                n3 = 255;
            } while (--this.cacheSize != 0);
            this.cache = (byte)(this.low >>> 24);
        }
        ++this.cacheSize;
        this.low = (this.low & 0xFFFFFFL) << 8;
    }

    public void encodeBit(short[] sArray, int n2, int n3) {
        short s2 = sArray[n2];
        int n4 = (this.range >>> 11) * s2;
        if (n3 == 0) {
            this.range = n4;
            sArray[n2] = (short)(s2 + (2048 - s2 >>> 5));
        } else {
            this.low += (long)n4 & 0xFFFFFFFFL;
            this.range -= n4;
            sArray[n2] = (short)(s2 - (s2 >>> 5));
        }
        if ((this.range & 0xFF000000) == 0) {
            this.range <<= 8;
            this.shiftLow();
        }
    }

    public static int getBitPrice(int n2, int n3) {
        if (!$assertionsDisabled && n3 != 0 && n3 != 1) {
            throw new AssertionError();
        }
        return prices[(n2 ^ -n3 & 0x7FF) >>> 4];
    }

    public void encodeBitTree(short[] sArray, int n2) {
        int n3 = 1;
        int n4 = sArray.length;
        do {
            int n5 = n2 & (n4 >>>= 1);
            this.encodeBit(sArray, n3, n5);
            n3 <<= 1;
            if (n5 == 0) continue;
            n3 |= 1;
        } while (n4 != 1);
    }

    public static int getBitTreePrice(short[] sArray, int n2) {
        int n3 = 0;
        n2 |= sArray.length;
        do {
            int n4 = n2 & 1;
            n3 += RangeEncoder.getBitPrice(sArray[n2 >>>= 1], n4);
        } while (n2 != 1);
        return n3;
    }

    public void encodeReverseBitTree(short[] sArray, int n2) {
        int n3 = 1;
        n2 |= sArray.length;
        do {
            int n4 = n2 & 1;
            this.encodeBit(sArray, n3, n4);
            n3 = n3 << 1 | n4;
        } while ((n2 >>>= 1) != 1);
    }

    public static int getReverseBitTreePrice(short[] sArray, int n2) {
        int n3 = 0;
        int n4 = 1;
        n2 |= sArray.length;
        do {
            int n5 = n2 & 1;
            n3 += RangeEncoder.getBitPrice(sArray[n4], n5);
            n4 = n4 << 1 | n5;
        } while ((n2 >>>= 1) != 1);
        return n3;
    }

    public void encodeDirectBits(int n2, int n3) {
        do {
            this.range >>>= 1;
            this.low += (long)(this.range & 0 - (n2 >>> --n3 & 1));
            if ((this.range & 0xFF000000) != 0) continue;
            this.range <<= 8;
            this.shiftLow();
        } while (n3 != 0);
    }

    public static int getDirectBitsPrice(int n2) {
        return n2 << 4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$tukaani$xz$rangecoder$RangeEncoder == null ? (class$org$tukaani$xz$rangecoder$RangeEncoder = RangeEncoder.class$("zz.org.tukaani.xz.rangecoder.RangeEncoder")) : class$org$tukaani$xz$rangecoder$RangeEncoder).desiredAssertionStatus();
        prices = new int[128];
        for (int i2 = 8; i2 < 2048; i2 += 16) {
            int n2 = i2;
            int n3 = 0;
            for (int i3 = 0; i3 < 4; ++i3) {
                n2 *= n2;
                n3 <<= 1;
                while ((n2 & 0xFFFF0000) != 0) {
                    n2 >>>= 1;
                    ++n3;
                }
            }
            RangeEncoder.prices[i2 >> 4] = 161 - n3;
        }
    }
}

