/*
 * Decompiled with CFR 0.152.
 */
package zz.org.xmlpull.mxp1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import zz.org.xmlpull.v1.XmlPullParser;
import zz.org.xmlpull.v1.XmlPullParserException;

public class MXParser
implements XmlPullParser {
    protected static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    protected static final String FEATURE_XML_ROUNDTRIP = "http://xmlpull.org/v1/doc/features.html#xml-roundtrip";
    protected static final String FEATURE_NAMES_INTERNED = "http://xmlpull.org/v1/doc/features.html#names-interned";
    protected static final String PROPERTY_XMLDECL_VERSION = "http://xmlpull.org/v1/doc/properties.html#xmldecl-version";
    protected static final String PROPERTY_XMLDECL_STANDALONE = "http://xmlpull.org/v1/doc/properties.html#xmldecl-standalone";
    protected static final String PROPERTY_XMLDECL_CONTENT = "http://xmlpull.org/v1/doc/properties.html#xmldecl-content";
    protected static final String PROPERTY_LOCATION = "http://xmlpull.org/v1/doc/properties.html#location";
    protected boolean allStringsInterned;
    private static final boolean TRACE_SIZING = false;
    protected boolean processNamespaces;
    protected boolean roundtripSupported;
    protected String location;
    protected int lineNumber;
    protected int columnNumber;
    protected boolean seenRoot;
    protected boolean reachedEnd;
    protected int eventType;
    protected boolean emptyElementTag;
    protected int depth;
    protected char[][] elRawName;
    protected int[] elRawNameEnd;
    protected int[] elRawNameLine;
    protected String[] elName;
    protected String[] elPrefix;
    protected String[] elUri;
    protected int[] elNamespaceCount;
    protected int attributeCount;
    protected String[] attributeName;
    protected int[] attributeNameHash;
    protected String[] attributePrefix;
    protected String[] attributeUri;
    protected String[] attributeValue;
    protected int namespaceEnd;
    protected String[] namespacePrefix;
    protected int[] namespacePrefixHash;
    protected String[] namespaceUri;
    protected int entityEnd;
    protected String[] entityName;
    protected char[][] entityNameBuf;
    protected String[] entityReplacement;
    protected char[][] entityReplacementBuf;
    protected int[] entityNameHash;
    protected static final int READ_CHUNK_SIZE = 8192;
    protected Reader reader;
    protected String inputEncoding;
    protected InputStream inputStream;
    protected int bufLoadFactor = 95;
    protected char[] buf = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 256];
    protected int bufSoftLimit = this.bufLoadFactor * this.buf.length / 100;
    protected boolean preventBufferCompaction;
    protected int bufAbsoluteStart;
    protected int bufStart;
    protected int bufEnd;
    protected int pos;
    protected int posStart;
    protected int posEnd;
    protected char[] pc = new char[Runtime.getRuntime().freeMemory() > 1000000L ? 8192 : 64];
    protected int pcStart;
    protected int pcEnd;
    protected boolean usePC;
    protected boolean seenStartTag;
    protected boolean seenEndTag;
    protected boolean pastEndTag;
    protected boolean seenAmpersand;
    protected boolean seenMarkup;
    protected boolean seenDocdecl;
    protected boolean tokenize;
    protected String text;
    protected String entityRefName;
    protected String xmlDeclVersion;
    protected Boolean xmlDeclStandalone;
    protected String xmlDeclContent;
    protected char[] charRefOneCharBuf = new char[1];
    protected static final char[] VERSION;
    protected static final char[] NCODING;
    protected static final char[] TANDALONE;
    protected static final char[] YES;
    protected static final char[] NO;
    protected static final int LOOKUP_MAX = 1024;
    protected static final char LOOKUP_MAX_CHAR = '\u0400';
    protected static boolean[] lookupNameStartChar;
    protected static boolean[] lookupNameChar;

    protected void resetStringCache() {
    }

    protected String newString(char[] cArray, int n2, int n3) {
        return new String(cArray, n2, n3);
    }

    protected String newStringIntern(char[] cArray, int n2, int n3) {
        return new String(cArray, n2, n3).intern();
    }

    protected void ensureElementsCapacity() {
        int n2;
        int n3 = n2 = this.elName != null ? this.elName.length : 0;
        if (this.depth + 1 >= n2) {
            int n4 = (this.depth >= 7 ? 2 * this.depth : 8) + 2;
            boolean bl2 = n2 > 0;
            String[] stringArray = null;
            stringArray = new String[n4];
            if (bl2) {
                System.arraycopy(this.elName, 0, stringArray, 0, n2);
            }
            this.elName = stringArray;
            stringArray = new String[n4];
            if (bl2) {
                System.arraycopy(this.elPrefix, 0, stringArray, 0, n2);
            }
            this.elPrefix = stringArray;
            stringArray = new String[n4];
            if (bl2) {
                System.arraycopy(this.elUri, 0, stringArray, 0, n2);
            }
            this.elUri = stringArray;
            int[] nArray = new int[n4];
            if (bl2) {
                System.arraycopy(this.elNamespaceCount, 0, nArray, 0, n2);
            } else {
                nArray[0] = 0;
            }
            this.elNamespaceCount = nArray;
            nArray = new int[n4];
            if (bl2) {
                System.arraycopy(this.elRawNameEnd, 0, nArray, 0, n2);
            }
            this.elRawNameEnd = nArray;
            nArray = new int[n4];
            if (bl2) {
                System.arraycopy(this.elRawNameLine, 0, nArray, 0, n2);
            }
            this.elRawNameLine = nArray;
            char[][] cArrayArray = new char[n4][];
            if (bl2) {
                System.arraycopy(this.elRawName, 0, cArrayArray, 0, n2);
            }
            this.elRawName = cArrayArray;
        }
    }

    protected void ensureAttributesCapacity(int n2) {
        int n3;
        int n4 = n3 = this.attributeName != null ? this.attributeName.length : 0;
        if (n2 >= n3) {
            int n5 = n2 > 7 ? 2 * n2 : 8;
            boolean bl2 = n3 > 0;
            String[] stringArray = null;
            stringArray = new String[n5];
            if (bl2) {
                System.arraycopy(this.attributeName, 0, stringArray, 0, n3);
            }
            this.attributeName = stringArray;
            stringArray = new String[n5];
            if (bl2) {
                System.arraycopy(this.attributePrefix, 0, stringArray, 0, n3);
            }
            this.attributePrefix = stringArray;
            stringArray = new String[n5];
            if (bl2) {
                System.arraycopy(this.attributeUri, 0, stringArray, 0, n3);
            }
            this.attributeUri = stringArray;
            stringArray = new String[n5];
            if (bl2) {
                System.arraycopy(this.attributeValue, 0, stringArray, 0, n3);
            }
            this.attributeValue = stringArray;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n5];
                if (bl2) {
                    System.arraycopy(this.attributeNameHash, 0, nArray, 0, n3);
                }
                this.attributeNameHash = nArray;
            }
            stringArray = null;
        }
    }

    protected void ensureNamespacesCapacity(int n2) {
        int n3;
        int n4 = n3 = this.namespacePrefix != null ? this.namespacePrefix.length : 0;
        if (n2 >= n3) {
            int n5 = n2 > 7 ? 2 * n2 : 8;
            String[] stringArray = new String[n5];
            String[] stringArray2 = new String[n5];
            if (this.namespacePrefix != null) {
                System.arraycopy(this.namespacePrefix, 0, stringArray, 0, this.namespaceEnd);
                System.arraycopy(this.namespaceUri, 0, stringArray2, 0, this.namespaceEnd);
            }
            this.namespacePrefix = stringArray;
            this.namespaceUri = stringArray2;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n5];
                if (this.namespacePrefixHash != null) {
                    System.arraycopy(this.namespacePrefixHash, 0, nArray, 0, this.namespaceEnd);
                }
                this.namespacePrefixHash = nArray;
            }
        }
    }

    protected static final int fastHash(char[] cArray, int n2, int n3) {
        if (n3 == 0) {
            return 0;
        }
        int n4 = cArray[n2];
        n4 = (n4 << 7) + cArray[n2 + n3 - 1];
        if (n3 > 16) {
            n4 = (n4 << 7) + cArray[n2 + n3 / 4];
        }
        if (n3 > 8) {
            n4 = (n4 << 7) + cArray[n2 + n3 / 2];
        }
        return n4;
    }

    protected void ensureEntityCapacity() {
        int n2;
        int n3 = n2 = this.entityReplacementBuf != null ? this.entityReplacementBuf.length : 0;
        if (this.entityEnd >= n2) {
            int n4 = this.entityEnd > 7 ? 2 * this.entityEnd : 8;
            String[] stringArray = new String[n4];
            char[][] cArrayArray = new char[n4][];
            String[] stringArray2 = new String[n4];
            char[][] cArrayArray2 = new char[n4][];
            if (this.entityName != null) {
                System.arraycopy(this.entityName, 0, stringArray, 0, this.entityEnd);
                System.arraycopy(this.entityNameBuf, 0, cArrayArray, 0, this.entityEnd);
                System.arraycopy(this.entityReplacement, 0, stringArray2, 0, this.entityEnd);
                System.arraycopy(this.entityReplacementBuf, 0, cArrayArray2, 0, this.entityEnd);
            }
            this.entityName = stringArray;
            this.entityNameBuf = cArrayArray;
            this.entityReplacement = stringArray2;
            this.entityReplacementBuf = cArrayArray2;
            if (!this.allStringsInterned) {
                int[] nArray = new int[n4];
                if (this.entityNameHash != null) {
                    System.arraycopy(this.entityNameHash, 0, nArray, 0, this.entityEnd);
                }
                this.entityNameHash = nArray;
            }
        }
    }

    protected void reset() {
        this.location = null;
        this.lineNumber = 1;
        this.columnNumber = 0;
        this.seenRoot = false;
        this.reachedEnd = false;
        this.eventType = 0;
        this.emptyElementTag = false;
        this.depth = 0;
        this.attributeCount = 0;
        this.namespaceEnd = 0;
        this.entityEnd = 0;
        this.reader = null;
        this.inputEncoding = null;
        this.preventBufferCompaction = false;
        this.bufAbsoluteStart = 0;
        this.bufStart = 0;
        this.bufEnd = 0;
        this.posEnd = 0;
        this.posStart = 0;
        this.pos = 0;
        this.pcStart = 0;
        this.pcEnd = 0;
        this.usePC = false;
        this.seenStartTag = false;
        this.seenEndTag = false;
        this.pastEndTag = false;
        this.seenAmpersand = false;
        this.seenMarkup = false;
        this.seenDocdecl = false;
        this.xmlDeclVersion = null;
        this.xmlDeclStandalone = null;
        this.xmlDeclContent = null;
        this.resetStringCache();
    }

    public void setFeature(String string, boolean bl2) throws XmlPullParserException {
        if (string == null) {
            throw new IllegalArgumentException("feature name should not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            if (this.eventType != 0) {
                throw new XmlPullParserException("namespace processing feature can only be changed before parsing", this, null);
            }
            this.processNamespaces = bl2;
        } else if (FEATURE_NAMES_INTERNED.equals(string)) {
            if (bl2) {
                throw new XmlPullParserException("interning names in this implementation is not supported");
            }
        } else if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(string)) {
            if (bl2) {
                throw new XmlPullParserException("processing DOCDECL is not supported");
            }
        } else if (FEATURE_XML_ROUNDTRIP.equals(string)) {
            this.roundtripSupported = bl2;
        } else {
            throw new XmlPullParserException("unsupported feature " + string);
        }
    }

    public boolean getFeature(String string) {
        if (string == null) {
            throw new IllegalArgumentException("feature name should not be null");
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string)) {
            return this.processNamespaces;
        }
        if (FEATURE_NAMES_INTERNED.equals(string)) {
            return false;
        }
        if ("http://xmlpull.org/v1/doc/features.html#process-docdecl".equals(string)) {
            return false;
        }
        if (FEATURE_XML_ROUNDTRIP.equals(string)) {
            return this.roundtripSupported;
        }
        return false;
    }

    public void setProperty(String string, Object object) throws XmlPullParserException {
        if (!PROPERTY_LOCATION.equals(string)) {
            throw new XmlPullParserException("unsupported property: '" + string + "'");
        }
        this.location = (String)object;
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException("property name should not be null");
        }
        if (PROPERTY_XMLDECL_VERSION.equals(string)) {
            return this.xmlDeclVersion;
        }
        if (PROPERTY_XMLDECL_STANDALONE.equals(string)) {
            return this.xmlDeclStandalone;
        }
        if (PROPERTY_XMLDECL_CONTENT.equals(string)) {
            return this.xmlDeclContent;
        }
        if (PROPERTY_LOCATION.equals(string)) {
            return this.location;
        }
        return null;
    }

    public void setInput(Reader reader) throws XmlPullParserException {
        this.reset();
        this.reader = reader;
    }

    public void setInput(InputStream inputStream, String string) throws XmlPullParserException {
        InputStreamReader inputStreamReader;
        if (inputStream == null) {
            throw new IllegalArgumentException("input stream can not be null");
        }
        this.inputStream = inputStream;
        try {
            inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XmlPullParserException("could not create reader for encoding " + string + " : " + unsupportedEncodingException, this, unsupportedEncodingException);
        }
        this.setInput(inputStreamReader);
        this.inputEncoding = string;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public void defineEntityReplacementText(String string, String string2) throws XmlPullParserException {
        this.ensureEntityCapacity();
        this.entityName[this.entityEnd] = this.newString(string.toCharArray(), 0, string.length());
        this.entityNameBuf[this.entityEnd] = string.toCharArray();
        this.entityReplacement[this.entityEnd] = string2;
        this.entityReplacementBuf[this.entityEnd] = string2.toCharArray();
        if (!this.allStringsInterned) {
            this.entityNameHash[this.entityEnd] = MXParser.fastHash(this.entityNameBuf[this.entityEnd], 0, this.entityNameBuf[this.entityEnd].length);
        }
        ++this.entityEnd;
    }

    public int getNamespaceCount(int n2) throws XmlPullParserException {
        if (!this.processNamespaces || n2 == 0) {
            return 0;
        }
        if (n2 < 0 || n2 > this.depth) {
            throw new IllegalArgumentException("allowed namespace depth 0.." + this.depth + " not " + n2);
        }
        return this.elNamespaceCount[n2];
    }

    public String getNamespacePrefix(int n2) throws XmlPullParserException {
        if (n2 < this.namespaceEnd) {
            return this.namespacePrefix[n2];
        }
        throw new XmlPullParserException("position " + n2 + " exceeded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespaceUri(int n2) throws XmlPullParserException {
        if (n2 < this.namespaceEnd) {
            return this.namespaceUri[n2];
        }
        throw new XmlPullParserException("position " + n2 + " exceeded number of available namespaces " + this.namespaceEnd);
    }

    public String getNamespace(String string) {
        if (string != null) {
            for (int i2 = this.namespaceEnd - 1; i2 >= 0; --i2) {
                if (!string.equals(this.namespacePrefix[i2])) continue;
                return this.namespaceUri[i2];
            }
            if ("xml".equals(string)) {
                return XML_URI;
            }
            if ("xmlns".equals(string)) {
                return XMLNS_URI;
            }
        } else {
            for (int i3 = this.namespaceEnd - 1; i3 >= 0; --i3) {
                if (this.namespacePrefix[i3] != null) continue;
                return this.namespaceUri[i3];
            }
        }
        return null;
    }

    public int getDepth() {
        return this.depth;
    }

    private static int findFragment(int n2, char[] cArray, int n3, int n4) {
        char c2;
        if (n3 < n2) {
            n3 = n2;
            if (n3 > n4) {
                n3 = n4;
            }
            return n3;
        }
        if (n4 - n3 > 65) {
            n3 = n4 - 10;
        }
        int n5 = n3 + 1;
        while (--n5 > n2 && n4 - n5 <= 65 && ((c2 = cArray[n5]) != '<' || n3 - n5 <= 10)) {
        }
        return n5;
    }

    public String getPositionDescription() {
        String string = null;
        if (this.posStart <= this.pos) {
            int n2 = MXParser.findFragment(0, this.buf, this.posStart, this.pos);
            if (n2 < this.pos) {
                string = new String(this.buf, n2, this.pos - n2);
            }
            if (this.bufAbsoluteStart > 0 || n2 > 0) {
                string = "..." + string;
            }
        }
        return " " + XmlPullParser.TYPES[this.eventType] + (string != null ? " seen " + this.printable(string) + "..." : "") + " " + (this.location != null ? this.location : "") + "@" + this.getLineNumber() + ":" + this.getColumnNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public boolean isWhitespace() throws XmlPullParserException {
        if (this.eventType == 4 || this.eventType == 5) {
            if (this.usePC) {
                for (int i2 = this.pcStart; i2 < this.pcEnd; ++i2) {
                    if (this.isS(this.pc[i2])) continue;
                    return false;
                }
                return true;
            }
            for (int i3 = this.posStart; i3 < this.posEnd; ++i3) {
                if (this.isS(this.buf[i3])) continue;
                return false;
            }
            return true;
        }
        if (this.eventType == 7) {
            return true;
        }
        throw new XmlPullParserException("no content available to check for white spaces");
    }

    public String getText() {
        if (this.eventType == 0 || this.eventType == 1) {
            return null;
        }
        if (this.eventType == 6) {
            return this.text;
        }
        if (this.text == null) {
            this.text = !this.usePC || this.eventType == 2 || this.eventType == 3 ? new String(this.buf, this.posStart, this.posEnd - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
        }
        return this.text;
    }

    public char[] getTextCharacters(int[] nArray) {
        if (this.eventType == 4) {
            if (this.usePC) {
                nArray[0] = this.pcStart;
                nArray[1] = this.pcEnd - this.pcStart;
                return this.pc;
            }
            nArray[0] = this.posStart;
            nArray[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 2 || this.eventType == 3 || this.eventType == 5 || this.eventType == 9 || this.eventType == 6 || this.eventType == 8 || this.eventType == 7 || this.eventType == 10) {
            nArray[0] = this.posStart;
            nArray[1] = this.posEnd - this.posStart;
            return this.buf;
        }
        if (this.eventType == 0 || this.eventType == 1) {
            nArray[1] = -1;
            nArray[0] = -1;
            return null;
        }
        throw new IllegalArgumentException("unknown text eventType: " + this.eventType);
    }

    public String getNamespace() {
        if (this.eventType == 2) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        if (this.eventType == 3) {
            return this.processNamespaces ? this.elUri[this.depth] : "";
        }
        return null;
    }

    public String getName() {
        if (this.eventType == 2) {
            return this.elName[this.depth];
        }
        if (this.eventType == 3) {
            return this.elName[this.depth];
        }
        if (this.eventType == 6) {
            if (this.entityRefName == null) {
                this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            }
            return this.entityRefName;
        }
        return null;
    }

    public String getPrefix() {
        if (this.eventType == 2) {
            return this.elPrefix[this.depth];
        }
        if (this.eventType == 3) {
            return this.elPrefix[this.depth];
        }
        return null;
    }

    public boolean isEmptyElementTag() throws XmlPullParserException {
        if (this.eventType != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to check for empty element", this, null);
        }
        return this.emptyElementTag;
    }

    public int getAttributeCount() {
        if (this.eventType != 2) {
            return -1;
        }
        return this.attributeCount;
    }

    public String getAttributeNamespace(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return "";
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return this.attributeUri[n2];
    }

    public String getAttributeName(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return this.attributeName[n2];
    }

    public String getAttributePrefix(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (!this.processNamespaces) {
            return null;
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return this.attributePrefix[n2];
    }

    public String getAttributeType(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return "CDATA";
    }

    public boolean isAttributeDefault(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return false;
    }

    public String getAttributeValue(int n2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes");
        }
        if (n2 < 0 || n2 >= this.attributeCount) {
            throw new IndexOutOfBoundsException("attribute position must be 0.." + (this.attributeCount - 1) + " and not " + n2);
        }
        return this.attributeValue[n2];
    }

    public String getAttributeValue(String string, String string2) {
        if (this.eventType != 2) {
            throw new IndexOutOfBoundsException("only START_TAG can have attributes" + this.getPositionDescription());
        }
        if (string2 == null) {
            throw new IllegalArgumentException("attribute name can not be null");
        }
        if (this.processNamespaces) {
            if (string == null) {
                string = "";
            }
            for (int i2 = 0; i2 < this.attributeCount; ++i2) {
                if (string != this.attributeUri[i2] && !string.equals(this.attributeUri[i2]) || !string2.equals(this.attributeName[i2])) continue;
                return this.attributeValue[i2];
            }
        } else {
            if (string != null && string.length() == 0) {
                string = null;
            }
            if (string != null) {
                throw new IllegalArgumentException("when namespaces processing is disabled attribute namespace must be null");
            }
            for (int i3 = 0; i3 < this.attributeCount; ++i3) {
                if (!string2.equals(this.attributeName[i3])) continue;
                return this.attributeValue[i3];
            }
        }
        return null;
    }

    public int getEventType() throws XmlPullParserException {
        return this.eventType;
    }

    public void require(int n2, String string, String string2) throws XmlPullParserException, IOException {
        if (!this.processNamespaces && string != null) {
            throw new XmlPullParserException("processing namespaces must be enabled on parser (or factory) to have possible namespaces declared on elements" + " (position:" + this.getPositionDescription() + ")");
        }
        if (n2 != this.getEventType() || string != null && !string.equals(this.getNamespace()) || string2 != null && !string2.equals(this.getName())) {
            throw new XmlPullParserException("expected event " + XmlPullParser.TYPES[n2] + (string2 != null ? " with name '" + string2 + "'" : "") + (string != null && string2 != null ? " and" : "") + (string != null ? " with namespace '" + string + "'" : "") + " but got" + (n2 != this.getEventType() ? " " + XmlPullParser.TYPES[this.getEventType()] : "") + (string2 != null && this.getName() != null && !string2.equals(this.getName()) ? " name '" + this.getName() + "'" : "") + (string != null && string2 != null && this.getName() != null && !string2.equals(this.getName()) && this.getNamespace() != null && !string.equals(this.getNamespace()) ? " and" : "") + (string != null && this.getNamespace() != null && !string.equals(this.getNamespace()) ? " namespace '" + this.getNamespace() + "'" : "") + " (position:" + this.getPositionDescription() + ")");
        }
    }

    public void skipSubTree() throws XmlPullParserException, IOException {
        this.require(2, null, null);
        int n2 = 1;
        while (n2 > 0) {
            int n3 = this.next();
            if (n3 == 3) {
                --n2;
                continue;
            }
            if (n3 != 2) continue;
            ++n2;
        }
    }

    public String nextText() throws XmlPullParserException, IOException {
        if (this.getEventType() != 2) {
            throw new XmlPullParserException("parser must be on START_TAG to read next text", this, null);
        }
        int n2 = this.next();
        if (n2 == 4) {
            String string = this.getText();
            n2 = this.next();
            if (n2 != 3) {
                throw new XmlPullParserException("TEXT must be immediately followed by END_TAG and not " + XmlPullParser.TYPES[this.getEventType()], this, null);
            }
            return string;
        }
        if (n2 == 3) {
            return "";
        }
        throw new XmlPullParserException("parser must be on START_TAG or TEXT to read text", this, null);
    }

    public int nextTag() throws XmlPullParserException, IOException {
        this.next();
        if (this.eventType == 4 && this.isWhitespace()) {
            this.next();
        }
        if (this.eventType != 2 && this.eventType != 3) {
            throw new XmlPullParserException("expected START_TAG or END_TAG not " + XmlPullParser.TYPES[this.getEventType()], this, null);
        }
        return this.eventType;
    }

    public int next() throws XmlPullParserException, IOException {
        this.tokenize = false;
        return this.nextImpl();
    }

    public int nextToken() throws XmlPullParserException, IOException {
        this.tokenize = true;
        return this.nextImpl();
    }

    /*
     * Unable to fully structure code
     */
    protected int nextImpl() throws XmlPullParserException, IOException {
        block53: {
            this.text = null;
            this.pcStart = 0;
            this.pcEnd = 0;
            this.usePC = false;
            this.bufStart = this.posEnd;
            if (this.pastEndTag) {
                this.pastEndTag = false;
                --this.depth;
                this.namespaceEnd = this.elNamespaceCount[this.depth];
            }
            if (this.emptyElementTag) {
                this.emptyElementTag = false;
                this.pastEndTag = true;
                this.eventType = 3;
                return 3;
            }
            if (this.depth <= 0) break block53;
            if (this.seenStartTag) {
                this.seenStartTag = false;
                this.eventType = this.parseStartTag();
                return this.eventType;
            }
            if (this.seenEndTag) {
                this.seenEndTag = false;
                this.eventType = this.parseEndTag();
                return this.eventType;
            }
            if (this.seenMarkup) {
                this.seenMarkup = false;
                var1_1 = '<';
            } else if (this.seenAmpersand) {
                this.seenAmpersand = false;
                var1_1 = '&';
            } else {
                var1_1 = this.more();
            }
            this.posStart = this.pos - 1;
            var2_2 = false;
            var3_3 = false;
            while (true) {
                block56: {
                    block54: {
                        block57: {
                            block55: {
                                if (var1_1 != 60) ** GOTO lbl98
                                if (var2_2 && this.tokenize) {
                                    this.seenMarkup = true;
                                    this.eventType = 4;
                                    return 4;
                                }
                                var1_1 = this.more();
                                if (var1_1 == '/') {
                                    if (!this.tokenize && var2_2) {
                                        this.seenEndTag = true;
                                        this.eventType = 4;
                                        return 4;
                                    }
                                    this.eventType = this.parseEndTag();
                                    return this.eventType;
                                }
                                if (var1_1 != 33) break block54;
                                var1_1 = this.more();
                                if (var1_1 != 45) break block55;
                                this.parseComment();
                                if (this.tokenize) {
                                    this.eventType = 9;
                                    return 9;
                                }
                                if (!this.usePC && var2_2) {
                                    var3_3 = true;
                                } else {
                                    this.posStart = this.pos;
                                }
                                break block56;
                            }
                            if (var1_1 != 91) break block57;
                            this.parseCDSect(var2_2);
                            if (this.tokenize) {
                                this.eventType = 5;
                                return 5;
                            }
                            var5_5 = this.posEnd;
                            var4_4 = this.posStart;
                            var6_6 = var5_5 - var4_4;
                            if (var6_6 <= 0) break block56;
                            var2_2 = true;
                            if (this.usePC) break block56;
                            var3_3 = true;
                            break block56;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + this.printable(var1_1), this, null);
                    }
                    if (var1_1 == '?') {
                        this.parsePI();
                        if (this.tokenize) {
                            this.eventType = 8;
                            return 8;
                        }
                        if (!this.usePC && var2_2) {
                            var3_3 = true;
                        } else {
                            this.posStart = this.pos;
                        }
                    } else {
                        if (this.isNameStartChar(var1_1)) {
                            if (!this.tokenize && var2_2) {
                                this.seenStartTag = true;
                                this.eventType = 4;
                                return 4;
                            }
                            this.eventType = this.parseStartTag();
                            return this.eventType;
                        }
                        throw new XmlPullParserException("unexpected character in markup " + this.printable(var1_1), this, null);
lbl98:
                        // 1 sources

                        if (var1_1 == '&') {
                            if (this.tokenize && var2_2) {
                                this.seenAmpersand = true;
                                this.eventType = 4;
                                return 4;
                            }
                            var4_4 = this.posStart + this.bufAbsoluteStart;
                            var5_5 = this.posEnd + this.bufAbsoluteStart;
                            var6_7 = this.parseEntityRef();
                            if (this.tokenize) {
                                this.eventType = 6;
                                return 6;
                            }
                            if (var6_7 == null) {
                                if (this.entityRefName == null) {
                                    this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                                }
                                throw new XmlPullParserException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this, null);
                            }
                            this.posStart = var4_4 - this.bufAbsoluteStart;
                            this.posEnd = var5_5 - this.bufAbsoluteStart;
                            if (!this.usePC) {
                                if (var2_2) {
                                    this.joinPC();
                                    var3_3 = false;
                                } else {
                                    this.usePC = true;
                                    this.pcEnd = 0;
                                    this.pcStart = 0;
                                }
                            }
                            for (var7_8 = 0; var7_8 < var6_7.length; ++var7_8) {
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = var6_7[var7_8];
                            }
                            var2_2 = true;
                        } else {
                            if (var3_3) {
                                this.joinPC();
                                var3_3 = false;
                            }
                            var2_2 = true;
                            var4_4 = 0;
                            var5_5 = this.tokenize == false || this.roundtripSupported == false ? 1 : 0;
                            var6_6 = 0;
                            var7_8 = 0;
                            do {
                                if (var1_1 == ']') {
                                    if (var6_6 != 0) {
                                        var7_8 = 1;
                                    } else {
                                        var6_6 = 1;
                                    }
                                } else {
                                    if (var7_8 != 0 && var1_1 == '>') {
                                        throw new XmlPullParserException("characters ]]> are not allowed in content", this, null);
                                    }
                                    if (var6_6 != 0) {
                                        var6_6 = 0;
                                        var7_8 = 0;
                                    }
                                }
                                if (var5_5 == 0) continue;
                                if (var1_1 == '\r') {
                                    var4_4 = 1;
                                    this.posEnd = this.pos - 1;
                                    if (!this.usePC) {
                                        if (this.posEnd > this.posStart) {
                                            this.joinPC();
                                        } else {
                                            this.usePC = true;
                                            this.pcEnd = 0;
                                            this.pcStart = 0;
                                        }
                                    }
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                    continue;
                                }
                                if (var1_1 == '\n') {
                                    if (var4_4 == 0 && this.usePC) {
                                        if (this.pcEnd >= this.pc.length) {
                                            this.ensurePC(this.pcEnd);
                                        }
                                        this.pc[this.pcEnd++] = 10;
                                    }
                                    var4_4 = 0;
                                    continue;
                                }
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = var1_1;
                                }
                                var4_4 = 0;
                            } while ((var1_1 = this.more()) != '<' && var1_1 != 38);
                            this.posEnd = this.pos - 1;
                            continue;
                        }
                    }
                }
                var1_1 = this.more();
            }
        }
        if (this.seenRoot) {
            return this.parseEpilog();
        }
        return this.parseProlog();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int parseProlog() throws XmlPullParserException, IOException {
        char c2 = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
        if (this.eventType == 0) {
            if (c2 == '\ufffe') {
                throw new XmlPullParserException("first character in input was UNICODE noncharacter (0xFFFE)- input requires int swapping", this, null);
            }
            if (c2 == '\ufeff') {
                c2 = this.more();
            }
        }
        this.seenMarkup = false;
        boolean bl2 = false;
        this.posStart = this.pos - 1;
        boolean bl3 = this.tokenize && !this.roundtripSupported;
        boolean bl4 = false;
        while (true) {
            block32: {
                block33: {
                    block34: {
                        if (c2 != '<') break block33;
                        if (bl2 && this.tokenize) {
                            this.posEnd = this.pos - 1;
                            this.seenMarkup = true;
                            this.eventType = 7;
                            return 7;
                        }
                        c2 = this.more();
                        if (c2 != '?') break block34;
                        if (this.parsePI()) {
                            if (this.tokenize) {
                                this.eventType = 8;
                                return 8;
                            }
                            break block32;
                        } else {
                            this.posStart = this.pos;
                            bl2 = false;
                        }
                        break block32;
                    }
                    if (c2 == '!') {
                        c2 = this.more();
                        if (c2 == 'D') {
                            if (this.seenDocdecl) {
                                throw new XmlPullParserException("only one docdecl allowed in XML document", this, null);
                            }
                            this.seenDocdecl = true;
                            this.parseDocdecl();
                            if (this.tokenize) {
                                this.eventType = 10;
                                return 10;
                            }
                            break block32;
                        } else {
                            if (c2 != '-') {
                                throw new XmlPullParserException("unexpected markup <!" + this.printable(c2), this, null);
                            }
                            this.parseComment();
                            if (this.tokenize) {
                                this.eventType = 9;
                                return 9;
                            }
                        }
                        break block32;
                    } else {
                        if (c2 == '/') {
                            throw new XmlPullParserException("expected start tag name and not " + this.printable(c2), this, null);
                        }
                        if (this.isNameStartChar(c2)) {
                            this.seenRoot = true;
                            return this.parseStartTag();
                        }
                        throw new XmlPullParserException("expected start tag name and not " + this.printable(c2), this, null);
                    }
                }
                if (!this.isS(c2)) {
                    throw new XmlPullParserException("only whitespace content allowed before start tag and not " + this.printable(c2), this, null);
                }
                bl2 = true;
                if (bl3) {
                    if (c2 == '\r') {
                        bl4 = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (c2 == '\n') {
                        if (!bl4 && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        bl4 = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = c2;
                        }
                        bl4 = false;
                    }
                }
            }
            c2 = this.more();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int parseEpilog() throws XmlPullParserException, IOException {
        boolean bl2;
        block32: {
            if (this.eventType == 1) {
                throw new XmlPullParserException("already reached end of XML input", this, null);
            }
            if (this.reachedEnd) {
                this.eventType = 1;
                return 1;
            }
            bl2 = false;
            boolean bl3 = this.tokenize && !this.roundtripSupported;
            boolean bl4 = false;
            try {
                char c2 = this.seenMarkup ? this.buf[this.pos - 1] : this.more();
                this.seenMarkup = false;
                this.posStart = this.pos - 1;
                if (this.reachedEnd) break block32;
                do {
                    block33: {
                        block34: {
                            block35: {
                                if (c2 != '<') break block34;
                                if (bl2 && this.tokenize) {
                                    this.posEnd = this.pos - 1;
                                    this.seenMarkup = true;
                                    this.eventType = 7;
                                    return 7;
                                }
                                c2 = this.more();
                                if (this.reachedEnd) break block32;
                                if (c2 != '?') break block35;
                                this.parsePI();
                                if (this.tokenize) {
                                    this.eventType = 8;
                                    return 8;
                                }
                                break block33;
                            }
                            if (c2 == '!') {
                                c2 = this.more();
                                if (this.reachedEnd) break block32;
                                if (c2 == 'D') {
                                    this.parseDocdecl();
                                    if (this.tokenize) {
                                        this.eventType = 10;
                                        return 10;
                                    }
                                    break block33;
                                } else {
                                    if (c2 != '-') {
                                        throw new XmlPullParserException("unexpected markup <!" + this.printable(c2), this, null);
                                    }
                                    this.parseComment();
                                    if (this.tokenize) {
                                        this.eventType = 9;
                                        return 9;
                                    }
                                }
                                break block33;
                            } else {
                                if (c2 == '/') {
                                    throw new XmlPullParserException("end tag not allowed in epilog but got " + this.printable(c2), this, null);
                                }
                                if (this.isNameStartChar(c2)) {
                                    throw new XmlPullParserException("start tag not allowed in epilog but got " + this.printable(c2), this, null);
                                }
                                throw new XmlPullParserException("in epilog expected ignorable content and not " + this.printable(c2), this, null);
                            }
                        }
                        if (!this.isS(c2)) {
                            throw new XmlPullParserException("in epilog non whitespace content is not allowed but got " + this.printable(c2), this, null);
                        }
                        bl2 = true;
                        if (bl3) {
                            if (c2 == '\r') {
                                bl4 = true;
                                if (!this.usePC) {
                                    this.posEnd = this.pos - 1;
                                    if (this.posEnd > this.posStart) {
                                        this.joinPC();
                                    } else {
                                        this.usePC = true;
                                        this.pcEnd = 0;
                                        this.pcStart = 0;
                                    }
                                }
                                if (this.pcEnd >= this.pc.length) {
                                    this.ensurePC(this.pcEnd);
                                }
                                this.pc[this.pcEnd++] = 10;
                            } else if (c2 == '\n') {
                                if (!bl4 && this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = 10;
                                }
                                bl4 = false;
                            } else {
                                if (this.usePC) {
                                    if (this.pcEnd >= this.pc.length) {
                                        this.ensurePC(this.pcEnd);
                                    }
                                    this.pc[this.pcEnd++] = c2;
                                }
                                bl4 = false;
                            }
                        }
                    }
                    c2 = this.more();
                } while (!this.reachedEnd);
            }
            catch (EOFException eOFException) {
                this.reachedEnd = true;
            }
        }
        if (!this.reachedEnd) {
            throw new XmlPullParserException("internal error in parseEpilog");
        }
        if (this.tokenize && bl2) {
            this.posEnd = this.pos;
            this.eventType = 7;
            return 7;
        }
        this.eventType = 1;
        return 1;
    }

    public int parseEndTag() throws XmlPullParserException, IOException {
        char c2 = this.more();
        if (!this.isNameStartChar(c2)) {
            throw new XmlPullParserException("expected name start and not " + this.printable(c2), this, null);
        }
        this.posStart = this.pos - 3;
        int n2 = this.pos - 1 + this.bufAbsoluteStart;
        while (this.isNameChar(c2 = this.more())) {
        }
        int n3 = n2 - this.bufAbsoluteStart;
        int n4 = this.pos - 1 - n3;
        char[] cArray = this.elRawName[this.depth];
        if (this.elRawNameEnd[this.depth] != n4) {
            String string = new String(cArray, 0, this.elRawNameEnd[this.depth]);
            String string2 = new String(this.buf, n3, n4);
            throw new XmlPullParserException("end tag name </" + string2 + "> must match start tag name <" + string + ">" + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            if (this.buf[n3++] == cArray[i2]) continue;
            String string = new String(cArray, 0, n4);
            String string3 = new String(this.buf, n3 - i2 - 1, n4);
            throw new XmlPullParserException("end tag name </" + string3 + "> must be the same as start tag <" + string + ">" + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        while (this.isS(c2)) {
            c2 = this.more();
        }
        if (c2 != '>') {
            throw new XmlPullParserException("expected > to finish end tag not " + this.printable(c2) + " from line " + this.elRawNameLine[this.depth], this, null);
        }
        this.posEnd = this.pos;
        this.pastEndTag = true;
        this.eventType = 3;
        return 3;
    }

    public int parseStartTag() throws XmlPullParserException, IOException {
        String string;
        block27: {
            ++this.depth;
            this.posStart = this.pos - 2;
            this.emptyElementTag = false;
            this.attributeCount = 0;
            int n2 = this.pos - 1 + this.bufAbsoluteStart;
            int n3 = -1;
            char c2 = this.buf[this.pos - 1];
            if (c2 == ':' && this.processNamespaces) {
                throw new XmlPullParserException("when namespaces processing enabled colon can not be at element name start", this, null);
            }
            while (this.isNameChar(c2 = this.more())) {
                if (c2 != ':' || !this.processNamespaces) continue;
                if (n3 != -1) {
                    throw new XmlPullParserException("only one colon is allowed in name of element when namespaces are enabled", this, null);
                }
                n3 = this.pos - 1 + this.bufAbsoluteStart;
            }
            this.ensureElementsCapacity();
            int n4 = this.pos - 1 - (n2 - this.bufAbsoluteStart);
            if (this.elRawName[this.depth] == null || this.elRawName[this.depth].length < n4) {
                this.elRawName[this.depth] = new char[2 * n4];
            }
            System.arraycopy(this.buf, n2 - this.bufAbsoluteStart, this.elRawName[this.depth], 0, n4);
            this.elRawNameEnd[this.depth] = n4;
            this.elRawNameLine[this.depth] = this.lineNumber;
            String string2 = null;
            string = null;
            if (this.processNamespaces) {
                if (n3 != -1) {
                    string = this.elPrefix[this.depth] = this.newString(this.buf, n2 - this.bufAbsoluteStart, n3 - n2);
                    string2 = this.elName[this.depth] = this.newString(this.buf, n3 + 1 - this.bufAbsoluteStart, this.pos - 2 - (n3 - this.bufAbsoluteStart));
                } else {
                    this.elPrefix[this.depth] = null;
                    string = null;
                    string2 = this.elName[this.depth] = this.newString(this.buf, n2 - this.bufAbsoluteStart, n4);
                }
            } else {
                string2 = this.elName[this.depth] = this.newString(this.buf, n2 - this.bufAbsoluteStart, n4);
            }
            while (true) {
                if (this.isS(c2)) {
                    c2 = this.more();
                    continue;
                }
                if (c2 == '>') break block27;
                if (c2 == '/') {
                    if (this.emptyElementTag) {
                        throw new XmlPullParserException("repeated / in tag declaration", this, null);
                    }
                    this.emptyElementTag = true;
                    c2 = this.more();
                    if (c2 != '>') {
                        throw new XmlPullParserException("expected > to end empty tag not " + this.printable(c2), this, null);
                    }
                    break block27;
                }
                if (!this.isNameStartChar(c2)) break;
                c2 = this.parseAttribute();
                c2 = this.more();
            }
            throw new XmlPullParserException("start tag unexpected character " + this.printable(c2), this, null);
        }
        if (this.processNamespaces) {
            String string3;
            int n5;
            String string4 = this.getNamespace(string);
            if (string4 == null) {
                if (string == null) {
                    string4 = "";
                } else {
                    throw new XmlPullParserException("could not determine namespace bound to element prefix " + string, this, null);
                }
            }
            this.elUri[this.depth] = string4;
            for (n5 = 0; n5 < this.attributeCount; ++n5) {
                String string5 = this.attributePrefix[n5];
                if (string5 != null) {
                    string3 = this.getNamespace(string5);
                    if (string3 == null) {
                        throw new XmlPullParserException("could not determine namespace bound to attribute prefix " + string5, this, null);
                    }
                    this.attributeUri[n5] = string3;
                    continue;
                }
                this.attributeUri[n5] = "";
            }
            for (n5 = 1; n5 < this.attributeCount; ++n5) {
                for (int i2 = 0; i2 < n5; ++i2) {
                    if (this.attributeUri[i2] != this.attributeUri[n5] || (!this.allStringsInterned || !this.attributeName[i2].equals(this.attributeName[n5])) && (this.allStringsInterned || this.attributeNameHash[i2] != this.attributeNameHash[n5] || !this.attributeName[i2].equals(this.attributeName[n5]))) continue;
                    string3 = this.attributeName[i2];
                    if (this.attributeUri[i2] != null) {
                        string3 = this.attributeUri[i2] + ":" + string3;
                    }
                    String string6 = this.attributeName[n5];
                    if (this.attributeUri[n5] != null) {
                        string6 = this.attributeUri[n5] + ":" + string6;
                    }
                    throw new XmlPullParserException("duplicated attributes " + string3 + " and " + string6, this, null);
                }
            }
        } else {
            for (int i3 = 1; i3 < this.attributeCount; ++i3) {
                for (int i4 = 0; i4 < i3; ++i4) {
                    if ((!this.allStringsInterned || !this.attributeName[i4].equals(this.attributeName[i3])) && (this.allStringsInterned || this.attributeNameHash[i4] != this.attributeNameHash[i3] || !this.attributeName[i4].equals(this.attributeName[i3]))) continue;
                    String string7 = this.attributeName[i4];
                    String string8 = this.attributeName[i3];
                    throw new XmlPullParserException("duplicated attributes " + string7 + " and " + string8, this, null);
                }
            }
        }
        this.elNamespaceCount[this.depth] = this.namespaceEnd;
        this.posEnd = this.pos;
        this.eventType = 2;
        return 2;
    }

    protected char parseAttribute() throws XmlPullParserException, IOException {
        int n2;
        Object object;
        int n3;
        char c2;
        int n4 = this.posStart + this.bufAbsoluteStart;
        int n5 = this.pos - 1 + this.bufAbsoluteStart;
        int n6 = -1;
        char c3 = this.buf[this.pos - 1];
        if (c3 == ':' && this.processNamespaces) {
            throw new XmlPullParserException("when namespaces processing enabled colon can not be at attribute name start", this, null);
        }
        boolean bl2 = this.processNamespaces && c3 == 'x';
        int n7 = 0;
        c3 = this.more();
        while (this.isNameChar(c3)) {
            if (this.processNamespaces) {
                if (bl2 && n7 < 5) {
                    if (++n7 == 1) {
                        if (c3 != 'm') {
                            bl2 = false;
                        }
                    } else if (n7 == 2) {
                        if (c3 != 'l') {
                            bl2 = false;
                        }
                    } else if (n7 == 3) {
                        if (c3 != 'n') {
                            bl2 = false;
                        }
                    } else if (n7 == 4) {
                        if (c3 != 's') {
                            bl2 = false;
                        }
                    } else if (n7 == 5 && c3 != ':') {
                        throw new XmlPullParserException("after xmlns in attribute name must be colonwhen namespaces are enabled", this, null);
                    }
                }
                if (c3 == ':') {
                    if (n6 != -1) {
                        throw new XmlPullParserException("only one colon is allowed in attribute name when namespaces are enabled", this, null);
                    }
                    n6 = this.pos - 1 + this.bufAbsoluteStart;
                }
            }
            c3 = this.more();
        }
        this.ensureAttributesCapacity(this.attributeCount);
        String string = null;
        String string2 = null;
        if (this.processNamespaces) {
            if (n7 < 4) {
                bl2 = false;
            }
            if (bl2) {
                if (n6 != -1) {
                    c2 = this.pos - 2 - (n6 - this.bufAbsoluteStart);
                    if (c2 == '\u0000') {
                        throw new XmlPullParserException("namespace prefix is required after xmlns:  when namespaces are enabled", this, null);
                    }
                    string = this.newString(this.buf, n6 - this.bufAbsoluteStart + 1, c2);
                }
            } else {
                if (n6 != -1) {
                    c2 = n6 - n5;
                    string2 = this.attributePrefix[this.attributeCount] = this.newString(this.buf, n5 - this.bufAbsoluteStart, c2);
                    n3 = this.pos - 2 - (n6 - this.bufAbsoluteStart);
                    string = this.attributeName[this.attributeCount] = this.newString(this.buf, n6 - this.bufAbsoluteStart + 1, n3);
                } else {
                    this.attributePrefix[this.attributeCount] = null;
                    string2 = null;
                    string = this.attributeName[this.attributeCount] = this.newString(this.buf, n5 - this.bufAbsoluteStart, this.pos - 1 - (n5 - this.bufAbsoluteStart));
                }
                if (!this.allStringsInterned) {
                    this.attributeNameHash[this.attributeCount] = string.hashCode();
                }
            }
        } else {
            string = this.attributeName[this.attributeCount] = this.newString(this.buf, n5 - this.bufAbsoluteStart, this.pos - 1 - (n5 - this.bufAbsoluteStart));
            if (!this.allStringsInterned) {
                this.attributeNameHash[this.attributeCount] = string.hashCode();
            }
        }
        while (this.isS(c3)) {
            c3 = this.more();
        }
        if (c3 != '=') {
            throw new XmlPullParserException("expected = after attribute name", this, null);
        }
        c3 = this.more();
        while (this.isS(c3)) {
            c3 = this.more();
        }
        c2 = c3;
        if (c2 != '\"' && c2 != '\'') {
            throw new XmlPullParserException("attribute value must start with quotation or apostrophe not " + this.printable(c2), this, null);
        }
        n3 = 0;
        this.usePC = false;
        this.pcStart = this.pcEnd;
        this.posStart = this.pos;
        while ((c3 = this.more()) != c2) {
            if (c3 == '<') {
                throw new XmlPullParserException("markup not allowed inside attribute value - illegal < ", this, null);
            }
            if (c3 == '&') {
                this.posEnd = this.pos - 1;
                if (!this.usePC) {
                    boolean bl3;
                    boolean bl4 = bl3 = this.posEnd > this.posStart;
                    if (bl3) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                if ((object = this.parseEntityRef()) == null) {
                    if (this.entityRefName == null) {
                        this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
                    }
                    throw new XmlPullParserException("could not resolve entity named '" + this.printable(this.entityRefName) + "'", this, null);
                }
                for (n2 = 0; n2 < ((char[])object).length; ++n2) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = (char)object[n2];
                }
            } else if (c3 == '\t' || c3 == '\n' || c3 == '\r') {
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcStart = 0;
                        this.pcEnd = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                if (c3 != '\n' || n3 == 0) {
                    this.pc[this.pcEnd++] = 32;
                }
            } else if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = c3;
            }
            n3 = c3 == '\r' ? 1 : 0;
        }
        if (this.processNamespaces && bl2) {
            object = null;
            object = !this.usePC ? (Object)this.newStringIntern(this.buf, this.posStart, this.pos - 1 - this.posStart) : (Object)this.newStringIntern(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            this.ensureNamespacesCapacity(this.namespaceEnd);
            n2 = -1;
            if (n6 != -1) {
                if (((String)object).length() == 0) {
                    throw new XmlPullParserException("non-default namespace can not be declared to be empty string", this, null);
                }
                this.namespacePrefix[this.namespaceEnd] = string;
                if (!this.allStringsInterned) {
                    n2 = this.namespacePrefixHash[this.namespaceEnd] = string.hashCode();
                }
            } else {
                this.namespacePrefix[this.namespaceEnd] = null;
                if (!this.allStringsInterned) {
                    this.namespacePrefixHash[this.namespaceEnd] = -1;
                    n2 = -1;
                }
            }
            this.namespaceUri[this.namespaceEnd] = object;
            int n8 = this.elNamespaceCount[this.depth - 1];
            for (int i2 = this.namespaceEnd - 1; i2 >= n8; --i2) {
                if ((!this.allStringsInterned && string != null || this.namespacePrefix[i2] != string) && (this.allStringsInterned || string == null || this.namespacePrefixHash[i2] != n2 || !string.equals(this.namespacePrefix[i2]))) continue;
                String string3 = string == null ? "default" : "'" + string + "'";
                throw new XmlPullParserException("duplicated namespace declaration for " + string3 + " prefix", this, null);
            }
            ++this.namespaceEnd;
        } else {
            this.attributeValue[this.attributeCount] = !this.usePC ? new String(this.buf, this.posStart, this.pos - 1 - this.posStart) : new String(this.pc, this.pcStart, this.pcEnd - this.pcStart);
            ++this.attributeCount;
        }
        this.posStart = n4 - this.bufAbsoluteStart;
        return c3;
    }

    protected char[] parseEntityRef() throws XmlPullParserException, IOException {
        this.entityRefName = null;
        this.posStart = this.pos;
        char c2 = this.more();
        if (c2 == '#') {
            int n2 = 0;
            c2 = this.more();
            if (c2 == 'x') {
                while (true) {
                    if ((c2 = this.more()) >= '0' && c2 <= '9') {
                        n2 = (char)(n2 * 16 + (c2 - 48));
                        continue;
                    }
                    if (c2 >= 'a' && c2 <= 'f') {
                        n2 = (char)(n2 * 16 + (c2 - 87));
                        continue;
                    }
                    if (c2 < 'A' || c2 > 'F') break;
                    n2 = (char)(n2 * 16 + (c2 - 55));
                }
                if (c2 != ';') {
                    throw new XmlPullParserException("character reference (with hex value) may not contain " + this.printable(c2), this, null);
                }
            } else {
                while (true) {
                    if (c2 < '0' || c2 > '9') {
                        if (c2 == ';') break;
                        throw new XmlPullParserException("character reference (with decimal value) may not contain " + this.printable(c2), this, null);
                    }
                    n2 = (char)(n2 * 10 + (c2 - 48));
                    c2 = this.more();
                }
            }
            this.posEnd = this.pos - 1;
            this.charRefOneCharBuf[0] = n2;
            if (this.tokenize) {
                this.text = this.newString(this.charRefOneCharBuf, 0, 1);
            }
            return this.charRefOneCharBuf;
        }
        if (!this.isNameStartChar(c2)) {
            throw new XmlPullParserException("entity reference names can not start with character '" + this.printable(c2) + "'", this, null);
        }
        while ((c2 = this.more()) != ';') {
            if (this.isNameChar(c2)) continue;
            throw new XmlPullParserException("entity reference name can not contain character " + this.printable(c2) + "'", this, null);
        }
        this.posEnd = this.pos - 1;
        int n3 = this.posEnd - this.posStart;
        if (n3 == 2 && this.buf[this.posStart] == 'l' && this.buf[this.posStart + 1] == 't') {
            if (this.tokenize) {
                this.text = "<";
            }
            this.charRefOneCharBuf[0] = 60;
            return this.charRefOneCharBuf;
        }
        if (n3 == 3 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'm' && this.buf[this.posStart + 2] == 'p') {
            if (this.tokenize) {
                this.text = "&";
            }
            this.charRefOneCharBuf[0] = 38;
            return this.charRefOneCharBuf;
        }
        if (n3 == 2 && this.buf[this.posStart] == 'g' && this.buf[this.posStart + 1] == 't') {
            if (this.tokenize) {
                this.text = ">";
            }
            this.charRefOneCharBuf[0] = 62;
            return this.charRefOneCharBuf;
        }
        if (n3 == 4 && this.buf[this.posStart] == 'a' && this.buf[this.posStart + 1] == 'p' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 's') {
            if (this.tokenize) {
                this.text = "'";
            }
            this.charRefOneCharBuf[0] = 39;
            return this.charRefOneCharBuf;
        }
        if (n3 == 4 && this.buf[this.posStart] == 'q' && this.buf[this.posStart + 1] == 'u' && this.buf[this.posStart + 2] == 'o' && this.buf[this.posStart + 3] == 't') {
            if (this.tokenize) {
                this.text = "\"";
            }
            this.charRefOneCharBuf[0] = 34;
            return this.charRefOneCharBuf;
        }
        char[] cArray = this.lookuEntityReplacement(n3);
        if (cArray != null) {
            return cArray;
        }
        if (this.tokenize) {
            this.text = null;
        }
        return null;
    }

    protected char[] lookuEntityReplacement(int n2) throws XmlPullParserException, IOException {
        if (!this.allStringsInterned) {
            int n3 = MXParser.fastHash(this.buf, this.posStart, this.posEnd - this.posStart);
            block0: for (int i2 = this.entityEnd - 1; i2 >= 0; --i2) {
                if (n3 != this.entityNameHash[i2] || n2 != this.entityNameBuf[i2].length) continue;
                char[] cArray = this.entityNameBuf[i2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (this.buf[this.posStart + i3] != cArray[i3]) continue block0;
                }
                if (this.tokenize) {
                    this.text = this.entityReplacement[i2];
                }
                return this.entityReplacementBuf[i2];
            }
        } else {
            this.entityRefName = this.newString(this.buf, this.posStart, this.posEnd - this.posStart);
            for (int i4 = this.entityEnd - 1; i4 >= 0; --i4) {
                if (this.entityRefName != this.entityName[i4]) continue;
                if (this.tokenize) {
                    this.text = this.entityReplacement[i4];
                }
                return this.entityReplacementBuf[i4];
            }
        }
        return null;
    }

    protected void parseComment() throws XmlPullParserException, IOException {
        char c2 = this.more();
        if (c2 != '-') {
            throw new XmlPullParserException("expected <!-- for comment start", this, null);
        }
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int n2 = this.lineNumber;
        int n3 = this.columnNumber;
        try {
            boolean bl2 = this.tokenize && !this.roundtripSupported;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            while (true) {
                c2 = this.more();
                if (bl5 && c2 != '>') {
                    throw new XmlPullParserException("in comment after two dashes (--) next character must be > not " + this.printable(c2), this, null);
                }
                if (c2 == '-') {
                    if (!bl4) {
                        bl4 = true;
                    } else {
                        bl5 = true;
                        bl4 = false;
                    }
                } else if (c2 == '>') {
                    if (bl5) break;
                    bl5 = false;
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (!bl2) continue;
                if (c2 == '\r') {
                    bl3 = true;
                    if (!this.usePC) {
                        this.posEnd = this.pos - 1;
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (c2 == '\n') {
                    if (!bl3 && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    bl3 = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = c2;
                }
                bl3 = false;
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("comment started on line " + n2 + " and column " + n3 + " was not closed", this, eOFException);
        }
        if (this.tokenize) {
            this.posEnd = this.pos - 3;
            if (this.usePC) {
                this.pcEnd -= 2;
            }
        }
    }

    protected boolean parsePI() throws XmlPullParserException, IOException {
        if (this.tokenize) {
            this.posStart = this.pos;
        }
        int n2 = this.lineNumber;
        int n3 = this.columnNumber;
        int n4 = this.pos + this.bufAbsoluteStart;
        int n5 = -1;
        boolean bl2 = this.tokenize && !this.roundtripSupported;
        boolean bl3 = false;
        try {
            boolean bl4 = false;
            char c2 = this.more();
            if (this.isS(c2)) {
                throw new XmlPullParserException("processing instruction PITarget must be exactly after <? and not white space character", this, null);
            }
            while (true) {
                if (c2 == '?') {
                    bl4 = true;
                } else if (c2 == '>') {
                    if (bl4) break;
                    bl4 = false;
                } else {
                    if (!(n5 != -1 || !this.isS(c2) || (n5 = this.pos - 1 + this.bufAbsoluteStart) - n4 != 3 || this.buf[n4] != 'x' && this.buf[n4] != 'X' || this.buf[n4 + 1] != 'm' && this.buf[n4 + 1] != 'M' || this.buf[n4 + 2] != 'l' && this.buf[n4 + 2] != 'L')) {
                        if (n4 > 3) {
                            throw new XmlPullParserException("processing instruction can not have PITarget with reserveld xml name", this, null);
                        }
                        if (this.buf[n4] != 'x' && this.buf[n4 + 1] != 'm' && this.buf[n4 + 2] != 'l') {
                            throw new XmlPullParserException("XMLDecl must have xml name in lowercase", this, null);
                        }
                        this.parseXmlDecl(c2);
                        if (this.tokenize) {
                            this.posEnd = this.pos - 2;
                        }
                        int n6 = n4 - this.bufAbsoluteStart + 3;
                        int n7 = this.pos - 2 - n6;
                        this.xmlDeclContent = this.newString(this.buf, n6, n7);
                        return false;
                    }
                    bl4 = false;
                }
                if (bl2) {
                    if (c2 == '\r') {
                        bl3 = true;
                        if (!this.usePC) {
                            this.posEnd = this.pos - 1;
                            if (this.posEnd > this.posStart) {
                                this.joinPC();
                            } else {
                                this.usePC = true;
                                this.pcEnd = 0;
                                this.pcStart = 0;
                            }
                        }
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    } else if (c2 == '\n') {
                        if (!bl3 && this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = 10;
                        }
                        bl3 = false;
                    } else {
                        if (this.usePC) {
                            if (this.pcEnd >= this.pc.length) {
                                this.ensurePC(this.pcEnd);
                            }
                            this.pc[this.pcEnd++] = c2;
                        }
                        bl3 = false;
                    }
                }
                c2 = this.more();
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("processing instruction started on line " + n2 + " and column " + n3 + " was not closed", this, eOFException);
        }
        if (n5 == -1) {
            n5 = this.pos - 2 + this.bufAbsoluteStart;
        }
        n4 -= this.bufAbsoluteStart;
        n5 -= this.bufAbsoluteStart;
        if (this.tokenize) {
            this.posEnd = this.pos - 2;
            if (bl2) {
                --this.pcEnd;
            }
        }
        return true;
    }

    protected void parseXmlDecl(char c2) throws XmlPullParserException, IOException {
        this.preventBufferCompaction = true;
        this.bufStart = 0;
        c2 = this.skipS(c2);
        c2 = this.requireInput(c2, VERSION);
        if ((c2 = this.skipS(c2)) != '=') {
            throw new XmlPullParserException("expected equals sign (=) after version and not " + this.printable(c2), this, null);
        }
        c2 = this.more();
        if ((c2 = this.skipS(c2)) != '\'' && c2 != '\"') {
            throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after version and not " + this.printable(c2), this, null);
        }
        char c3 = c2;
        int n2 = this.pos;
        c2 = this.more();
        while (c2 != c3) {
            if (!(c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 >= '0' && c2 <= '9' || c2 == '_' || c2 == '.' || c2 == ':' || c2 == '-')) {
                throw new XmlPullParserException("<?xml version value expected to be in ([a-zA-Z0-9_.:] | '-') not " + this.printable(c2), this, null);
            }
            c2 = this.more();
        }
        int n3 = this.pos - 1;
        this.parseXmlDeclWithVersion(n2, n3);
        this.preventBufferCompaction = false;
    }

    protected void parseXmlDeclWithVersion(int n2, int n3) throws XmlPullParserException, IOException {
        int n4;
        char c2;
        String string = this.inputEncoding;
        if (n3 - n2 != 3 || this.buf[n2] != '1' || this.buf[n2 + 1] != '.' || this.buf[n2 + 2] != '0') {
            throw new XmlPullParserException("only 1.0 is supported as <?xml version not '" + this.printable(new String(this.buf, n2, n3 - n2)) + "'", this, null);
        }
        this.xmlDeclVersion = this.newString(this.buf, n2, n3 - n2);
        char c3 = this.more();
        if ((c3 = this.skipS(c3)) == 'e') {
            c3 = this.more();
            c3 = this.requireInput(c3, NCODING);
            if ((c3 = this.skipS(c3)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after encoding and not " + this.printable(c3), this, null);
            }
            c3 = this.more();
            if ((c3 = this.skipS(c3)) != '\'' && c3 != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(c3), this, null);
            }
            c2 = c3;
            n4 = this.pos;
            c3 = this.more();
            if (!(c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z')) {
                throw new XmlPullParserException("<?xml encoding name expected to start with [A-Za-z] not " + this.printable(c3), this, null);
            }
            c3 = this.more();
            while (c3 != c2) {
                if (!(c3 >= 'a' && c3 <= 'z' || c3 >= 'A' && c3 <= 'Z' || c3 >= '0' && c3 <= '9' || c3 == '.' || c3 == '_' || c3 == '-')) {
                    throw new XmlPullParserException("<?xml encoding value expected to be in ([A-Za-z0-9._] | '-') not " + this.printable(c3), this, null);
                }
                c3 = this.more();
            }
            int n5 = this.pos - 1;
            this.inputEncoding = this.newString(this.buf, n4, n5 - n4);
            c3 = this.more();
        }
        if ((c3 = this.skipS(c3)) == 's') {
            c3 = this.more();
            c3 = this.requireInput(c3, TANDALONE);
            if ((c3 = this.skipS(c3)) != '=') {
                throw new XmlPullParserException("expected equals sign (=) after standalone and not " + this.printable(c3), this, null);
            }
            c3 = this.more();
            if ((c3 = this.skipS(c3)) != '\'' && c3 != '\"') {
                throw new XmlPullParserException("expected apostrophe (') or quotation mark (\") after encoding and not " + this.printable(c3), this, null);
            }
            c2 = c3;
            n4 = this.pos;
            c3 = this.more();
            if (c3 == 'y') {
                c3 = this.requireInput(c3, YES);
                this.xmlDeclStandalone = new Boolean(true);
            } else if (c3 == 'n') {
                c3 = this.requireInput(c3, NO);
                this.xmlDeclStandalone = new Boolean(false);
            } else {
                throw new XmlPullParserException("expected 'yes' or 'no' after standalone and not " + this.printable(c3), this, null);
            }
            if (c3 != c2) {
                throw new XmlPullParserException("expected " + c2 + " after standalone value not " + this.printable(c3), this, null);
            }
            c3 = this.more();
        }
        if ((c3 = this.skipS(c3)) != '?') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + this.printable(c3), this, null);
        }
        c3 = this.more();
        if (c3 != '>') {
            throw new XmlPullParserException("expected ?> as last part of <?xml not " + this.printable(c3), this, null);
        }
    }

    protected void parseDocdecl() throws XmlPullParserException, IOException {
        char c2 = this.more();
        if (c2 != 'O') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c2 = this.more();
        if (c2 != 'C') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c2 = this.more();
        if (c2 != 'T') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c2 = this.more();
        if (c2 != 'Y') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c2 = this.more();
        if (c2 != 'P') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        c2 = this.more();
        if (c2 != 'E') {
            throw new XmlPullParserException("expected <!DOCTYPE", this, null);
        }
        this.posStart = this.pos;
        int n2 = 0;
        boolean bl2 = this.tokenize && !this.roundtripSupported;
        boolean bl3 = false;
        while (true) {
            if ((c2 = this.more()) == '[') {
                ++n2;
            }
            if (c2 == ']') {
                --n2;
            }
            if (c2 == '>' && n2 == 0) break;
            if (!bl2) continue;
            if (c2 == '\r') {
                bl3 = true;
                if (!this.usePC) {
                    this.posEnd = this.pos - 1;
                    if (this.posEnd > this.posStart) {
                        this.joinPC();
                    } else {
                        this.usePC = true;
                        this.pcEnd = 0;
                        this.pcStart = 0;
                    }
                }
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = 10;
                continue;
            }
            if (c2 == '\n') {
                if (!bl3 && this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                }
                bl3 = false;
                continue;
            }
            if (this.usePC) {
                if (this.pcEnd >= this.pc.length) {
                    this.ensurePC(this.pcEnd);
                }
                this.pc[this.pcEnd++] = c2;
            }
            bl3 = false;
        }
        this.posEnd = this.pos - 1;
    }

    protected void parseCDSect(boolean bl2) throws XmlPullParserException, IOException {
        char c2 = this.more();
        if (c2 != 'C') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c2 = this.more();
        if (c2 != 'D') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c2 = this.more();
        if (c2 != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c2 = this.more();
        if (c2 != 'T') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c2 = this.more();
        if (c2 != 'A') {
            throw new XmlPullParserException("expected <[CDATA[ for comment start", this, null);
        }
        c2 = this.more();
        if (c2 != '[') {
            throw new XmlPullParserException("expected <![CDATA[ for comment start", this, null);
        }
        int n2 = this.pos + this.bufAbsoluteStart;
        int n3 = this.lineNumber;
        int n4 = this.columnNumber;
        boolean bl3 = !this.tokenize || !this.roundtripSupported;
        try {
            if (bl3 && bl2 && !this.usePC) {
                if (this.posEnd > this.posStart) {
                    this.joinPC();
                } else {
                    this.usePC = true;
                    this.pcEnd = 0;
                    this.pcStart = 0;
                }
            }
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            while (true) {
                if ((c2 = this.more()) == ']') {
                    if (!bl4) {
                        bl4 = true;
                    } else {
                        bl5 = true;
                    }
                } else if (c2 == '>') {
                    if (bl4 && bl5) break;
                    bl5 = false;
                    bl4 = false;
                } else if (bl4) {
                    bl4 = false;
                }
                if (!bl3) continue;
                if (c2 == '\r') {
                    bl6 = true;
                    this.posStart = n2 - this.bufAbsoluteStart;
                    this.posEnd = this.pos - 1;
                    if (!this.usePC) {
                        if (this.posEnd > this.posStart) {
                            this.joinPC();
                        } else {
                            this.usePC = true;
                            this.pcEnd = 0;
                            this.pcStart = 0;
                        }
                    }
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = 10;
                    continue;
                }
                if (c2 == '\n') {
                    if (!bl6 && this.usePC) {
                        if (this.pcEnd >= this.pc.length) {
                            this.ensurePC(this.pcEnd);
                        }
                        this.pc[this.pcEnd++] = 10;
                    }
                    bl6 = false;
                    continue;
                }
                if (this.usePC) {
                    if (this.pcEnd >= this.pc.length) {
                        this.ensurePC(this.pcEnd);
                    }
                    this.pc[this.pcEnd++] = c2;
                }
                bl6 = false;
            }
        }
        catch (EOFException eOFException) {
            throw new XmlPullParserException("CDATA section started on line " + n3 + " and column " + n4 + " was not closed", this, eOFException);
        }
        if (bl3 && this.usePC) {
            this.pcEnd -= 2;
        }
        this.posStart = n2 - this.bufAbsoluteStart;
        this.posEnd = this.pos - 3;
    }

    protected void fillBuf() throws IOException, XmlPullParserException {
        int n2;
        int n3;
        if (this.reader == null) {
            throw new XmlPullParserException("reader must be set before parsing is started");
        }
        if (this.bufEnd > this.bufSoftLimit) {
            n3 = this.bufStart > this.bufSoftLimit ? 1 : 0;
            n2 = 0;
            if (this.preventBufferCompaction) {
                n3 = 0;
                n2 = 1;
            } else if (n3 == 0) {
                if (this.bufStart < this.buf.length / 2) {
                    n2 = 1;
                } else {
                    n3 = 1;
                }
            }
            if (n3 != 0) {
                System.arraycopy(this.buf, this.bufStart, this.buf, 0, this.bufEnd - this.bufStart);
            } else if (n2 != 0) {
                int n4 = 2 * this.buf.length;
                char[] cArray = new char[n4];
                System.arraycopy(this.buf, this.bufStart, cArray, 0, this.bufEnd - this.bufStart);
                this.buf = cArray;
                if (this.bufLoadFactor > 0) {
                    this.bufSoftLimit = (int)((long)this.bufLoadFactor * (long)this.buf.length / 100L);
                }
            } else {
                throw new XmlPullParserException("internal error in fillBuffer()");
            }
            this.bufEnd -= this.bufStart;
            this.pos -= this.bufStart;
            this.posStart -= this.bufStart;
            this.posEnd -= this.bufStart;
            this.bufAbsoluteStart += this.bufStart;
            this.bufStart = 0;
        }
        if ((n2 = this.reader.read(this.buf, this.bufEnd, n3 = this.buf.length - this.bufEnd > 8192 ? 8192 : this.buf.length - this.bufEnd)) > 0) {
            this.bufEnd += n2;
            return;
        }
        if (n2 == -1) {
            if (this.bufAbsoluteStart == 0 && this.pos == 0) {
                throw new EOFException("input contained no data");
            }
            if (this.seenRoot && this.depth == 0) {
                this.reachedEnd = true;
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (this.depth > 0) {
                String string;
                int n5;
                stringBuffer.append(" - expected end tag");
                if (this.depth > 1) {
                    stringBuffer.append("s");
                }
                stringBuffer.append(" ");
                for (n5 = this.depth; n5 > 0; --n5) {
                    string = new String(this.elRawName[n5], 0, this.elRawNameEnd[n5]);
                    stringBuffer.append("</").append(string).append('>');
                }
                stringBuffer.append(" to close");
                for (n5 = this.depth; n5 > 0; --n5) {
                    if (n5 != this.depth) {
                        stringBuffer.append(" and");
                    }
                    string = new String(this.elRawName[n5], 0, this.elRawNameEnd[n5]);
                    stringBuffer.append(" start tag <" + string + ">");
                    stringBuffer.append(" from line " + this.elRawNameLine[n5]);
                }
                stringBuffer.append(", parser stopped on");
            }
            throw new EOFException("no more data available" + stringBuffer.toString() + this.getPositionDescription());
        }
        throw new IOException("error reading input, returned " + n2);
    }

    protected char more() throws IOException, XmlPullParserException {
        char c2;
        if (this.pos >= this.bufEnd) {
            this.fillBuf();
            if (this.reachedEnd) {
                return '\uffff';
            }
        }
        if ((c2 = this.buf[this.pos++]) == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
        return c2;
    }

    protected void ensurePC(int n2) {
        int n3 = n2 > 8192 ? 2 * n2 : 16384;
        char[] cArray = new char[n3];
        System.arraycopy(this.pc, 0, cArray, 0, this.pcEnd);
        this.pc = cArray;
    }

    protected void joinPC() {
        int n2 = this.posEnd - this.posStart;
        int n3 = this.pcEnd + n2 + 1;
        if (n3 >= this.pc.length) {
            this.ensurePC(n3);
        }
        System.arraycopy(this.buf, this.posStart, this.pc, this.pcEnd, n2);
        this.pcEnd += n2;
        this.usePC = true;
    }

    protected char requireInput(char c2, char[] cArray) throws XmlPullParserException, IOException {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (c2 != cArray[i2]) {
                throw new XmlPullParserException("expected " + this.printable(cArray[i2]) + " in " + new String(cArray) + " and not " + this.printable(c2), this, null);
            }
            c2 = this.more();
        }
        return c2;
    }

    protected char requireNextS() throws XmlPullParserException, IOException {
        char c2 = this.more();
        if (!this.isS(c2)) {
            throw new XmlPullParserException("white space is required and not " + this.printable(c2), this, null);
        }
        return this.skipS(c2);
    }

    protected char skipS(char c2) throws XmlPullParserException, IOException {
        while (this.isS(c2)) {
            c2 = this.more();
        }
        return c2;
    }

    private static final void setName(char c2) {
        MXParser.lookupNameChar[c2] = true;
    }

    private static final void setNameStart(char c2) {
        MXParser.lookupNameStartChar[c2] = true;
        MXParser.setName(c2);
    }

    protected boolean isNameStartChar(char c2) {
        return c2 < '\u0400' && lookupNameStartChar[c2] || c2 >= '\u0400' && c2 <= '\u2027' || c2 >= '\u202a' && c2 <= '\u218f' || c2 >= '\u2800' && c2 <= '\uffef';
    }

    protected boolean isNameChar(char c2) {
        return c2 < '\u0400' && lookupNameChar[c2] || c2 >= '\u0400' && c2 <= '\u2027' || c2 >= '\u202a' && c2 <= '\u218f' || c2 >= '\u2800' && c2 <= '\uffef';
    }

    protected boolean isS(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t';
    }

    protected String printable(char c2) {
        if (c2 == '\n') {
            return "\\n";
        }
        if (c2 == '\r') {
            return "\\r";
        }
        if (c2 == '\t') {
            return "\\t";
        }
        if (c2 == '\'') {
            return "\\'";
        }
        if (c2 > '\u007f' || c2 < ' ') {
            return "\\u" + Integer.toHexString(c2);
        }
        return "" + c2;
    }

    protected String printable(String string) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 10);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.printable(string.charAt(i2)));
        }
        string = stringBuffer.toString();
        return string;
    }

    static {
        char c2;
        VERSION = "version".toCharArray();
        NCODING = "ncoding".toCharArray();
        TANDALONE = "tandalone".toCharArray();
        YES = "yes".toCharArray();
        NO = "no".toCharArray();
        lookupNameStartChar = new boolean[1024];
        lookupNameChar = new boolean[1024];
        MXParser.setNameStart(':');
        for (c2 = 'A'; c2 <= 'Z'; c2 = (char)((char)(c2 + 1))) {
            MXParser.setNameStart(c2);
        }
        MXParser.setNameStart('_');
        for (c2 = 'a'; c2 <= 'z'; c2 = (char)((char)(c2 + 1))) {
            MXParser.setNameStart(c2);
        }
        for (c2 = '\u00c0'; c2 <= '\u02ff'; c2 = (char)((char)(c2 + 1))) {
            MXParser.setNameStart(c2);
        }
        for (c2 = '\u0370'; c2 <= '\u037d'; c2 = (char)((char)(c2 + 1))) {
            MXParser.setNameStart(c2);
        }
        for (c2 = '\u037f'; c2 < '\u0400'; c2 = (char)((char)(c2 + '\u0001'))) {
            MXParser.setNameStart(c2);
        }
        MXParser.setName('-');
        MXParser.setName('.');
        for (c2 = '0'; c2 <= '9'; c2 = (char)((char)(c2 + 1))) {
            MXParser.setName(c2);
        }
        MXParser.setName('\u00b7');
        for (c2 = '\u0300'; c2 <= '\u036f'; c2 = (char)(c2 + '\u0001')) {
            MXParser.setName(c2);
        }
    }
}

