/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditDataRecordedEvent;
import org.sonatype.nexus.audit.AuditRecorder;
import org.sonatype.nexus.audit.InitiatorProvider;
import org.sonatype.nexus.audit.internal.AuditStore;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.node.NodeAccess;

@Named
@Singleton
public class AuditRecorderImpl
extends ComponentSupport
implements AuditRecorder {
    private final EventManager eventManager;
    private final NodeAccess nodeAccess;
    private final AuditStore auditStore;
    private final InitiatorProvider initiatorProvider;
    private volatile boolean enabled = false;

    @Inject
    public AuditRecorderImpl(EventManager eventManager, NodeAccess nodeAccess, AuditStore auditStore, InitiatorProvider initiatorProvider) {
        this.eventManager = eventManager;
        this.nodeAccess = nodeAccess;
        this.auditStore = auditStore;
        this.initiatorProvider = initiatorProvider;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void record(AuditData data) {
        Preconditions.checkNotNull((Object)data);
        if (this.enabled) {
            if (data.getTimestamp() == null) {
                data.setTimestamp(new Date());
            }
            if (data.getNodeId() == null) {
                data.setNodeId(this.nodeAccess.getId());
            }
            if (data.getInitiator() == null) {
                data.setInitiator(this.initiatorProvider.get());
            }
            this.log.debug("Record: {}", (Object)data);
            try {
                this.auditStore.add(data);
                this.eventManager.post((Object)new AuditDataRecordedEvent(data.copy()));
            }
            catch (Exception e) {
                this.log.warn("Failed to record audit data", (Throwable)e);
            }
        }
    }
}

