/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal.orient;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Date;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class AuditDataEntityAdapter
extends IterableEntityAdapter<AuditData> {
    private static final String DB_CLASS = new OClassNameBuilder().type("audit_data").build();
    private static final String P_DOMAIN = "domain";
    private static final String P_TYPE = "type";
    private static final String P_CONTEXT = "context";
    private static final String P_TIMESTAMP = "timestamp";
    private static final String P_NODE_ID = "nodeId";
    private static final String P_INITIATOR = "initiator";
    private static final String P_ATTRIBUTES = "attributes";
    private static final String BROWSE_SKIP_LIMIT_QUERY = String.format("SELECT FROM %s SKIP ? LIMIT ?", DB_CLASS);
    private static final String DELETE_ALL = String.format("TRUNCATE CLASS %s", DB_CLASS);

    public AuditDataEntityAdapter() {
        super(DB_CLASS);
    }

    public void register(ODatabaseDocumentTx db, Runnable initializer) {
        if (db.getStorage().getConfiguration().getMinimumClusters() != 1) {
            db.getStorage().setMinimumClusters(1);
        }
        super.register(db, initializer);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_DOMAIN, OType.STRING).setNotNull(true);
        type.createProperty(P_TYPE, OType.STRING).setNotNull(true);
        type.createProperty(P_CONTEXT, OType.STRING).setNotNull(true);
        type.createProperty(P_TIMESTAMP, OType.LONG).setNotNull(true);
        type.createProperty(P_NODE_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_INITIATOR, OType.STRING).setNotNull(true);
        type.createProperty(P_ATTRIBUTES, OType.EMBEDDEDMAP);
    }

    protected AuditData newEntity() {
        return new AuditData();
    }

    protected void readFields(ODocument document, AuditData entity) throws Exception {
        entity.setDomain((String)document.field(P_DOMAIN, OType.STRING));
        entity.setType((String)document.field(P_TYPE, OType.STRING));
        entity.setContext((String)document.field(P_CONTEXT, OType.STRING));
        entity.setTimestamp((Date)document.field(P_TIMESTAMP, OType.DATETIME));
        entity.setNodeId((String)document.field(P_NODE_ID, OType.STRING));
        entity.setInitiator((String)document.field(P_INITIATOR, OType.STRING));
        Map attributes = (Map)document.field(P_ATTRIBUTES, OType.EMBEDDEDMAP);
        if (attributes != null) {
            entity.setAttributes(this.detachable(attributes));
        }
    }

    protected void writeFields(ODocument document, AuditData entity) throws Exception {
        document.field(P_DOMAIN, (Object)entity.getDomain());
        document.field(P_TYPE, (Object)entity.getType());
        document.field(P_CONTEXT, (Object)entity.getContext());
        document.field(P_TIMESTAMP, (Object)entity.getTimestamp());
        document.field(P_NODE_ID, (Object)entity.getNodeId());
        document.field(P_INITIATOR, (Object)entity.getInitiator());
        document.field(P_ATTRIBUTES, (Object)entity.getAttributes());
    }

    public Iterable<AuditData> browse(ODatabaseDocumentTx db, long offset, long limit) {
        this.log.trace("Browse; offset: {}, limit: {}", (Object)offset, (Object)limit);
        return this.transform(db.query((OQuery)new OSQLSynchQuery(BROWSE_SKIP_LIMIT_QUERY), new Object[]{offset, limit}));
    }

    public void clear(ODatabaseDocumentTx db) {
        db.command((OCommandRequest)new OCommandSQL(DELETE_ALL)).execute(new Object[0]);
    }
}

