/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.internal.AuditStore;
import org.sonatype.nexus.audit.internal.orient.AuditDataEntityAdapter;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
public class OrientAuditStore
extends StateGuardLifecycleSupport
implements AuditStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final AuditDataEntityAdapter entityAdapter;

    @Inject
    public OrientAuditStore(@Named(value="audit") Provider<DatabaseInstance> databaseInstance, AuditDataEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (AuditDataEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void add(AuditData data) throws Exception {
        Preconditions.checkNotNull((Object)data);
        Preconditions.checkState((!EventHelper.isReplicating() ? 1 : 0) != 0, (Object)"Replication in progress");
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            ODocument oDocument = this.entityAdapter.addEntity(db, (Entity)data);
        });
    }

    @Override
    @Guarded(by={"STARTED"})
    public void clear() throws Exception {
        OrientTransactional.inTxRetry(this.databaseInstance).run(this.entityAdapter::clear);
    }

    @Override
    @Guarded(by={"STARTED"})
    public long approximateSize() throws Exception {
        return (Long)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((AuditDataEntityAdapter)this.entityAdapter).count(arg_0));
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<AuditData> browse(long offset, long limit) throws Exception {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf(this.entityAdapter.browse(db, offset, limit)));
    }
}

