/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.audit.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="audit", from="1.0", to="1.1")
public class AuditDatabaseUpgrade_1_1
extends DatabaseUpgradeSupport {
    private final Provider<DatabaseInstance> databaseInstance;

    @Inject
    public AuditDatabaseUpgrade_1_1(@Named(value="audit") Provider<DatabaseInstance> databaseInstance) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
    }

    public void apply() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            int[] clusterIds;
            OSchemaProxy schema = db.getMetadata().getSchema();
            OClass type = schema.getClass("audit_data");
            if (type != null && (clusterIds = type.getClusterIds()).length > 1) {
                int primaryClusterId = clusterIds[0];
                type.setDefaultClusterId(primaryClusterId);
                this.log.info("Moving events to primary cluster {}", (Object)db.getClusterNameById(primaryClusterId));
                int moveCount = 0;
                for (ODocument document : db.browseClass(type.getName())) {
                    ORID rid = document.getIdentity();
                    if (rid.getClusterId() == primaryClusterId) continue;
                    db.save((ORecord)new ODocument(document.toStream()));
                    db.delete(rid);
                    ++moveCount;
                }
                this.log.info("Moved {} events", (Object)moveCount);
                int[] nArray = clusterIds;
                int n = clusterIds.length;
                int n2 = 0;
                while (n2 < n) {
                    int clusterId = nArray[n2];
                    if (clusterId != primaryClusterId) {
                        this.log.info("Dropping secondary cluster {}", (Object)db.getClusterNameById(clusterId));
                        db.dropCluster(clusterId, false);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

