/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.ODistributedCommand;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OExecutionThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OPlaceholder;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OSoftQueryResultList;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageOperationResult;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OFreezableStorageComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.enterprise.channel.binary.ODistributedRedirectException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.OAsynchDistributedOperation;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfigurationChangedException;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.OModifiableDistributedConfiguration;
import com.orientechnologies.orient.server.distributed.OWriteOperationNotPermittedException;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.OLocalClusterWrapperStrategy;
import com.orientechnologies.orient.server.distributed.impl.task.OCreateRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.ODeleteRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordIfNotLatestTask;
import com.orientechnologies.orient.server.distributed.impl.task.OReadRecordTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSQLCommandTask;
import com.orientechnologies.orient.server.distributed.impl.task.OScriptTask;
import com.orientechnologies.orient.server.distributed.impl.task.OUpdateRecordTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractCommandTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.OPossibleDuplicatedRecordException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.security.OSecurityServerUser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ODistributedStorage
implements OStorage,
OFreezableStorageComponent,
OAutoshardedStorage {
    private final String name;
    private final OServer serverInstance;
    private final ODistributedServerManager dManager;
    private OAbstractPaginatedStorage wrapped;
    private BlockingQueue<OAsynchDistributedOperation> asynchronousOperationsQueue;
    private Thread asynchWorker;
    private ODistributedServerManager.DB_STATUS prevStatus;
    private ODistributedDatabase localDistributedDatabase;
    private ODistributedTransactionManager txManager;
    private ODistributedStorageEventListener eventListener;
    private volatile ODistributedConfiguration distributedConfiguration;
    private volatile boolean running = true;
    private volatile File lastValidBackup = null;

    public ODistributedStorage(OServer iServer, String dbName) {
        this.serverInstance = iServer;
        this.dManager = iServer.getDistributedManager();
        this.name = dbName;
    }

    public synchronized void wrap(final OAbstractPaginatedStorage wrapped) {
        if (this.wrapped != null) {
            return;
        }
        this.wrapped = wrapped;
        this.wrapped.underDistributedStorage();
        this.localDistributedDatabase = this.dManager.getMessageService().getDatabase(this.getName());
        this.txManager = new ODistributedTransactionManager(this, this.dManager, this.localDistributedDatabase);
        ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Installing distributed storage on database '%s'", (Object[])new Object[]{wrapped.getName()});
        int queueSize = OGlobalConfiguration.DISTRIBUTED_ASYNCH_QUEUE_SIZE.getValueAsInteger();
        this.asynchronousOperationsQueue = queueSize <= 0 ? new LinkedBlockingQueue<OAsynchDistributedOperation>() : new LinkedBlockingQueue<OAsynchDistributedOperation>(queueSize);
        this.asynchWorker = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (ODistributedStorage.this.running) {
                    try {
                        ODistributedRequestId reqId;
                        OAsynchDistributedOperation operation;
                        block9: {
                            operation = (OAsynchDistributedOperation)ODistributedStorage.this.asynchronousOperationsQueue.take();
                            reqId = null;
                            try {
                                ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(operation.getDatabaseName(), (Collection)operation.getClusterNames(), operation.getNodes(), operation.getTask(), operation.getMessageId(), operation.getCallback() != null ? ODistributedRequest.EXECUTION_MODE.RESPONSE : ODistributedRequest.EXECUTION_MODE.NO_RESPONSE, operation.getLocalResult(), operation.getAfterSendCallback(), null);
                                if (dResponse == null) break block9;
                                reqId = dResponse.getRequestId();
                                if (operation.getCallback() == null) break block9;
                                operation.getCallback().call((Object)new OPair((Comparable)reqId, dResponse.getPayload()));
                            }
                            catch (Throwable throwable) {
                                if (operation.getAfterSendCallback() != null) {
                                    operation.getAfterSendCallback().call(reqId);
                                }
                                throw throwable;
                            }
                        }
                        if (operation.getAfterSendCallback() == null) continue;
                        operation.getAfterSendCallback().call((Object)reqId);
                    }
                    catch (InterruptedException e) {
                        int pendingMessages = ODistributedStorage.this.asynchronousOperationsQueue.size();
                        if (pendingMessages > 0) {
                            ODistributedServerLog.info((Object)this, (String)(ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Received shutdown signal, waiting for asynchronous queue is empty (pending msgs=%d)...", (Object[])new Object[]{pendingMessages});
                        }
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        if (!ODistributedStorage.this.running) continue;
                        if (e instanceof ONeedRetryException) {
                            ODistributedServerLog.debug((Object)this, (String)(ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on executing asynchronous operation", (Throwable)e, (Object[])new Object[0]);
                            continue;
                        }
                        ODistributedServerLog.error((Object)this, (String)(ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on executing asynchronous operation", (Throwable)e, (Object[])new Object[0]);
                    }
                }
                ODistributedServerLog.debug((Object)this, (String)(ODistributedStorage.this.dManager != null ? ODistributedStorage.this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Shutdown asynchronous queue worker for database '%s' completed", (Object[])new Object[]{wrapped.getName()});
            }
        };
        this.asynchWorker.setName("OrientDB Distributed asynch ops node=" + this.getNodeId() + " db=" + this.getName());
        this.asynchWorker.start();
    }

    public boolean isDistributed() {
        return true;
    }

    public boolean isAssigningClusterIds() {
        return true;
    }

    public Object command(final OCommandRequestText iCommand) {
        OCommandExecutor exec;
        ArrayList<String> servers = (ArrayList<String>)iCommand.getContext().getVariable("servers");
        if (servers == null) {
            servers = new ArrayList<String>();
            iCommand.getContext().setVariable("servers", servers);
        }
        final String localNodeName = this.dManager.getLocalNodeName();
        servers.add(localNodeName);
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return this.wrapped.command(iCommand);
        }
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        if (!dbCfg.isReplicationActive(null, localNodeName)) {
            return this.wrapped.command(iCommand);
        }
        OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse((OCommandRequest)iCommand);
        OCommandExecutor oCommandExecutor = exec = executor instanceof OCommandExecutorSQLDelegate ? ((OCommandExecutorSQLDelegate)executor).getDelegate() : executor;
        if (!exec.isIdempotent()) {
            this.resetLastValidBackup();
        }
        if (exec.isIdempotent() && !this.dManager.isNodeAvailable(this.dManager.getLocalNodeName(), this.getName())) {
            ODistributedServerLog.warn((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Node '%s' is %s, the command '%s' against database '%s' will be executed only on local server with the possibility to have partial result", (Object[])new Object[]{this.dManager.getLocalNodeName(), this.dManager.getDatabaseStatus(this.dManager.getLocalNodeName(), this.getName()), iCommand, this.wrapped.getName()});
            return this.wrapped.command(iCommand);
        }
        if (!exec.isIdempotent()) {
            this.checkNodeIsMaster(localNodeName, dbCfg, "Command '" + iCommand + "'");
        }
        try {
            Object result = null;
            OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
            OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT resultMgmt = OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS;
            boolean executeOnLocalNodeFirst = true;
            if (OScenarioThreadLocal.INSTANCE.getRunMode() != OScenarioThreadLocal.RUN_MODE.RUNNING_DISTRIBUTED && exec instanceof OCommandDistributedReplicateRequest) {
                executionMode = ((OCommandDistributedReplicateRequest)exec).getDistributedExecutionMode();
                resultMgmt = ((OCommandDistributedReplicateRequest)exec).getDistributedResultManagement();
                executeOnLocalNodeFirst = ((OCommandDistributedReplicateRequest)exec).isDistributedExecutingOnLocalNodeFirst();
            }
            switch (executionMode) {
                case LOCAL: {
                    return this.wrapped.command(iCommand);
                }
                case REPLICATE: {
                    final Set involvedClusters = exec.getInvolvedClusters();
                    if (resultMgmt == OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE) {
                        Map<String, Object> results;
                        if (!exec.isIdempotent() && dbCfg.isSharded()) {
                            throw new ODistributedException("Cannot distribute the command '" + iCommand.getText() + "' because it is not idempotent and a map-reduce has been requested");
                        }
                        Map nodeClusterMap = dbCfg.getServerClusterMap((Collection)involvedClusters, localNodeName, exec.isIdempotent());
                        if (exec.isIdempotent() && nodeClusterMap.size() == 1 && ((String)nodeClusterMap.keySet().iterator().next()).equals(localNodeName)) {
                            result = this.wrapped.command(iCommand);
                            results = new HashMap<String, Object>(1);
                            results.put(localNodeName, result);
                        } else {
                            results = this.executeOnServers(iCommand, exec, involvedClusters, nodeClusterMap);
                        }
                        OCommandExecutorSQLSelect select = exec instanceof OCommandExecutorSQLSelect ? (OCommandExecutorSQLSelect)exec : null;
                        result = select != null && select.isAnyFunctionAggregates() && !select.hasGroupBy() ? this.mergeResultByAggregation(select, results) : exec.mergeResults(results);
                        if (result instanceof Throwable && results.containsKey(localNodeName)) {
                            this.undoCommandOnLocalServer(iCommand);
                        }
                    } else {
                        final OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, new HashSet<String>());
                        task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
                        final Set nodes = dbCfg.getServers((Collection)involvedClusters);
                        if (iCommand instanceof ODistributedCommand) {
                            nodes.removeAll(((ODistributedCommand)iCommand).nodesToExclude());
                        }
                        if (this.executeOnlyLocally(localNodeName, dbCfg, exec, involvedClusters, nodes)) {
                            return this.wrapped.command(iCommand);
                        }
                        final boolean executedLocally = executeOnLocalNodeFirst && nodes.contains(localNodeName);
                        result = exec.involveSchema() ? this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                            public Object call(OModifiableDistributedConfiguration iArgument) {
                                return ODistributedStorage.this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                            }
                        }) : this.executeCommand(iCommand, localNodeName, involvedClusters, task, nodes, executedLocally);
                    }
                    if (!exec.involveSchema()) break;
                    this.dManager.propagateSchemaChanges((ODatabaseInternal)ODatabaseRecordThreadLocal.instance().get());
                }
            }
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed COMMAND"), (Throwable)((Exception)result));
            }
            return result;
        }
        catch (OConcurrentModificationException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)e.getRid());
            throw e;
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route COMMAND operation to the distributed node", e, new Object[0]);
            return null;
        }
    }

    protected Object executeCommand(final OCommandRequestText iCommand, String localNodeName, Collection<String> involvedClusters, OAbstractCommandTask task, Set<String> nodes, boolean executedLocally) {
        Object result;
        Object localResult;
        if (executedLocally) {
            try {
                localResult = OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.command(iCommand);
                    }
                });
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw OException.wrapException((OException)new ODistributedException("Cannot execute command " + iCommand), (Throwable)e);
            }
            nodes.remove(localNodeName);
        } else {
            localResult = null;
        }
        if (!nodes.isEmpty()) {
            if (ODistributedServerLog.isDebugEnabled()) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodes.toString(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Sending command '%s' database '%s'", (Object[])new Object[]{iCommand, this.wrapped.getName()});
            }
            ODistributedResponse dResponse = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null);
            result = dResponse.getPayload();
            if (executedLocally && result instanceof Throwable) {
                this.undoCommandOnLocalServer(iCommand);
            }
        } else {
            result = localResult;
        }
        return result;
    }

    protected void undoCommandOnLocalServer(final OCommandRequestText iCommand) {
        OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

            public Object call() throws Exception {
                OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)iCommand);
                executor.setContext(iCommand.getContext());
                executor.setProgressListener(iCommand.getProgressListener());
                executor.parse((OCommandRequest)iCommand);
                String undoCommand = ((OCommandDistributedReplicateRequest)executor).getUndoCommand();
                if (undoCommand != null) {
                    ODistributedStorage.this.wrapped.command((OCommandRequestText)new OCommandSQL(undoCommand));
                }
                return null;
            }
        });
    }

    protected Map<String, Object> executeOnServers(OCommandRequestText iCommand, OCommandExecutor exec, Collection<String> involvedClusters, Map<String, Collection<String>> nodeClusterMap) {
        HashMap<String, Object> results = new HashMap<String, Object>(nodeClusterMap.size());
        ArrayList<String> nodes = new ArrayList<String>(1);
        for (Map.Entry<String, Collection<String>> c : nodeClusterMap.entrySet()) {
            String nodeName = c.getKey();
            if (!this.dManager.isNodeAvailable(nodeName, this.getName())) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Node '%s' is involved in the command '%s' against database '%s', but the node is not active. Excluding it", (Object[])new Object[]{nodeName, iCommand, this.wrapped.getName()});
                continue;
            }
            OAbstractCommandTask task = iCommand instanceof OCommandScript ? new OScriptTask(iCommand) : new OSQLCommandTask(iCommand, c.getValue());
            task.setResultStrategy(ORemoteTask.RESULT_STRATEGY.ANY);
            nodes.clear();
            nodes.add(nodeName);
            try {
                ODistributedResponse response = this.dManager.sendRequest(this.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                if (response == null || response.getPayload() instanceof ODistributedOperationException) continue;
                results.put(nodeName, response.getPayload());
            }
            catch (Exception e) {
                ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), (String)nodeName, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.OUT, (String)"Error on execution of command '%s' against server '%s', database '%s'", (Object[])new Object[]{iCommand, nodeName, this.wrapped.getName()});
            }
        }
        if (results.isEmpty()) {
            throw new ODistributedException("No active nodes found to execute command: " + iCommand);
        }
        return results;
    }

    protected Object mergeResultByAggregation(OCommandExecutorSQLSelect select, Map<String, Object> iResults) {
        ArrayList<ODocument> list = null;
        ODocument doc = null;
        boolean hasNonAggregates = false;
        Map proj = select.getProjections();
        for (Map.Entry entry : proj.entrySet()) {
            if (entry.getValue() instanceof OSQLFunctionRuntime) continue;
            hasNonAggregates = true;
            break;
        }
        if (hasNonAggregates) {
            for (Map.Entry<Object, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList<ODocument>();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    for (Map.Entry p : proj.entrySet()) {
                        if (p.getValue() instanceof OSQLFunctionRuntime) continue;
                        doc.field((String)p.getKey(), d.field((String)p.getKey()));
                    }
                }
            }
        }
        List toMerge = OSoftQueryResultList.createResultList(null);
        for (Map.Entry p : proj.entrySet()) {
            if (!(p.getValue() instanceof OSQLFunctionRuntime)) continue;
            OSQLFunctionRuntime f = (OSQLFunctionRuntime)p.getValue();
            toMerge.clear();
            for (Map.Entry<String, Object> entry : iResults.entrySet()) {
                List resultSet = (List)entry.getValue();
                if (resultSet == null) continue;
                if (list == null) {
                    list = new ArrayList();
                    doc = new ODocument();
                    list.add(doc);
                }
                for (Object r : resultSet) {
                    if (!(r instanceof ODocument)) continue;
                    ODocument d = (ODocument)r;
                    toMerge.add(d.rawField((String)p.getKey()));
                }
            }
            if (doc == null) continue;
            doc.field((String)p.getKey(), f.getFunction().mergeDistributedResult(toMerge));
        }
        return list;
    }

    protected boolean executeOnlyLocally(String localNodeName, ODistributedConfiguration dbCfg, OCommandExecutor exec, Collection<String> involvedClusters, Collection<String> nodes) {
        boolean executeLocally = false;
        if (exec.isIdempotent()) {
            int maxReadQuorum;
            int availableNodes = nodes.size();
            if (involvedClusters.isEmpty()) {
                maxReadQuorum = dbCfg.getReadQuorum(null, availableNodes, localNodeName);
            } else {
                maxReadQuorum = 0;
                for (String cl : involvedClusters) {
                    maxReadQuorum = Math.max(maxReadQuorum, dbCfg.getReadQuorum(cl, availableNodes, localNodeName));
                }
            }
            if (nodes.contains(localNodeName) && maxReadQuorum <= 1) {
                executeLocally = true;
            }
        }
        return executeLocally;
    }

    public OStorageOperationResult<OPhysicalPosition> createRecord(final ORecordId iRecordId, final byte[] iContent, final int iRecordVersion, final byte iRecordType, final int iMode, final ORecordCallback<Long> iCallback) {
        this.resetLastValidBackup();
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
        }
        String localNodeName = this.dManager.getLocalNodeName();
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        int clusterId = iRecordId.getClusterId();
        if (clusterId == -1) {
            throw new IllegalArgumentException("Cluster not valid");
        }
        this.checkNodeIsMaster(localNodeName, dbCfg, "Create record " + iRecordId);
        String clusterName = this.getClusterNameByRID(iRecordId);
        this.checkWriteQuorum(dbCfg, clusterName, localNodeName);
        try {
            ODocument documentForClusterSelection = (ODocument)iRecordId.getRecord();
            if (documentForClusterSelection == null) {
                documentForClusterSelection = (ODocument)ORecordInternal.fill((ORecord)new ODocument(), (ORID)iRecordId, (int)iRecordVersion, (byte[])iContent, (boolean)false);
            }
            this.checkForCluster((ORecord)documentForClusterSelection, localNodeName, dbCfg);
            final List servers = dbCfg.getServers(clusterName, null);
            if (servers.isEmpty()) {
                return this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
            }
            final String finalClusterName = clusterName;
            final Set<String> clusterNames = Collections.singleton(finalClusterName);
            servers.remove(localNodeName);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(finalClusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            final boolean syncMode = executionModeSynch;
            return (OStorageOperationResult)this.executeRecordOperationInLock(syncMode, iRecordId, new OCallable<Object, OCallable<Void, ODistributedRequestId>>(){

                public Object call(OCallable<Void, ODistributedRequestId> unlockCallback) {
                    OStorageOperationResult localResult;
                    block9: {
                        localResult = ODistributedStorage.this.wrapped.createRecord(iRecordId, iContent, iRecordVersion, iRecordType, iMode, iCallback);
                        iRecordId.setClusterPosition(((OPhysicalPosition)localResult.getResult()).clusterPosition);
                        OPlaceholder localPlaceholder = new OPlaceholder(iRecordId, ((OPhysicalPosition)localResult.getResult()).recordVersion);
                        if (!servers.isEmpty()) {
                            OCreateRecordTask task = (OCreateRecordTask)ODistributedStorage.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)servers).createTask(0);
                            task.init(iRecordId, iContent, iRecordVersion, iRecordType);
                            task.setLastLSN(ODistributedStorage.this.wrapped.getLSN());
                            if (syncMode) {
                                try {
                                    ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(ODistributedStorage.this.getName(), (Collection)clusterNames, (Collection)servers, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localPlaceholder, unlockCallback, null);
                                    Object payload = dResponse.getPayload();
                                    if (payload != null) {
                                        if (payload instanceof Exception) {
                                            ODistributedStorage.this.executeUndoOnLocalServer(dResponse.getRequestId(), (OAbstractReplicatedTask)task);
                                            if (payload instanceof ONeedRetryException) {
                                                throw (ONeedRetryException)payload;
                                            }
                                            throw OException.wrapException((OException)new ODistributedException("Error on execution distributed create record"), (Throwable)((Exception)payload));
                                        }
                                        OPlaceholder masterPlaceholder = (OPlaceholder)payload;
                                        iRecordId.copyFrom(masterPlaceholder.getIdentity());
                                        return new OStorageOperationResult((Object)new OPhysicalPosition(masterPlaceholder.getIdentity().getClusterPosition(), masterPlaceholder.getVersion()));
                                    }
                                    break block9;
                                }
                                catch (RuntimeException e) {
                                    ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                    throw e;
                                }
                                catch (Exception e) {
                                    ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                    throw ODatabaseException.wrapException((OException)new ODistributedException("Cannot execute distributed create record"), (Throwable)e);
                                }
                            }
                            ODistributedStorage.this.asynchronousExecution(new OAsynchDistributedOperation(ODistributedStorage.this.getName(), Collections.singleton(finalClusterName), (Collection)servers, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), (Object)localPlaceholder, unlockCallback, null));
                        } else {
                            unlockCallback.call(null);
                        }
                    }
                    return localResult;
                }
            });
        }
        catch (ODistributedRecordLockedException e) {
            throw e;
        }
        catch (ONeedRetryException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            ORecordId lockEntireCluster = iRecordId.copy();
            lockEntireCluster.setClusterPosition(-1L);
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(lockEntireCluster);
            throw e;
        }
        catch (InterruptedException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Current node has been interrupted"), (Throwable)e);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            ORecordId lockEntireCluster = iRecordId.copy();
            lockEntireCluster.setClusterPosition(-1L);
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(lockEntireCluster);
            this.handleDistributedException("Cannot route create record operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecord(final ORecordId iRecordId, final String iFetchPlan, final boolean iIgnoreCache, final boolean prefetchRecords, final ORecordCallback<ORawBuffer> iCallback) {
        ORawBuffer memCopy;
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed() && (memCopy = this.localDistributedDatabase.getRecordIfLocked((ORID)iRecordId)) != null) {
            return new OStorageOperationResult((Object)memCopy);
        }
        try {
            Object dResult;
            String clusterName = this.getClusterNameByRID(iRecordId);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecord(iRecordId, iFetchPlan, iIgnoreCache, prefetchRecords, iCallback);
                    }
                });
            }
            OReadRecordTask task = ((OReadRecordTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(1)).init(iRecordId);
            ODistributedResponse response = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
            Object object = dResult = response != null ? response.getPayload() : null;
            if (dResult instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)dResult);
            }
            if (dResult instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed read record"), (Throwable)((Exception)dResult));
            }
            return new OStorageOperationResult((Object)((ORawBuffer)dResult));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<ORawBuffer> readRecordIfVersionIsNotLatest(final ORecordId rid, final String fetchPlan, final boolean ignoreCache, final int recordVersion) throws ORecordNotFoundException {
        ORawBuffer memCopy;
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed() && (memCopy = this.localDistributedDatabase.getRecordIfLocked((ORID)rid)) != null) {
            return new OStorageOperationResult((Object)memCopy);
        }
        try {
            String clusterName = this.getClusterNameByRID(rid);
            ODistributedConfiguration dbCfg = this.distributedConfiguration;
            List nodes = dbCfg.getServers(clusterName, null);
            int availableNodes = nodes.size();
            String localNodeName = this.dManager.getLocalNodeName();
            if (nodes.isEmpty() || nodes.contains(this.dManager.getLocalNodeName()) && dbCfg.getReadQuorum(clusterName, availableNodes, localNodeName) <= 1) {
                return (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                    public Object call() throws Exception {
                        return ODistributedStorage.this.wrapped.readRecordIfVersionIsNotLatest(rid, fetchPlan, ignoreCache, recordVersion);
                    }
                });
            }
            OReadRecordIfNotLatestTask task = (OReadRecordIfNotLatestTask)this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(2);
            task.init(rid, recordVersion);
            Object result = this.dManager.sendRequest(this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null).getPayload();
            if (result instanceof ONeedRetryException) {
                throw (ONeedRetryException)((Object)result);
            }
            if (result instanceof Exception) {
                throw OException.wrapException((OException)new ODistributedException("Error on execution distributed read record"), (Throwable)((Exception)result));
            }
            return new OStorageOperationResult((Object)((ORawBuffer)result));
        }
        catch (ONeedRetryException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route read record operation for %s to the distributed node", e, rid);
            return null;
        }
    }

    public OStorageOperationResult<Integer> updateRecord(final ORecordId iRecordId, final boolean updateContent, final byte[] iContent, final int iVersion, final byte iRecordType, final int iMode, final ORecordCallback<Integer> iCallback) {
        this.resetLastValidBackup();
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
        }
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        final String clusterName = this.getClusterNameByRID(iRecordId);
        final String localNodeName = this.dManager.getLocalNodeName();
        this.checkWriteQuorum(dbCfg, clusterName, localNodeName);
        try {
            this.checkNodeIsMaster(localNodeName, dbCfg, "Update record " + iRecordId);
            final List nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty()) {
                return this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
            }
            final Set<String> clusterNames = Collections.singleton(clusterName);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(clusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            final boolean syncMode = executionModeSynch;
            return (OStorageOperationResult)this.executeRecordOperationInLock(syncMode, iRecordId, new OCallable<Object, OCallable<Void, ODistributedRequestId>>(){

                public Object call(OCallable<Void, ODistributedRequestId> unlockCallback) {
                    OStorageOperationResult localResult;
                    final OUpdateRecordTask task = (OUpdateRecordTask)ODistributedStorage.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(3);
                    task.init(iRecordId, iContent, iVersion, iRecordType);
                    boolean executedLocally = nodes.contains(localNodeName);
                    if (executedLocally) {
                        try {
                            task.checkRecordExists();
                            localResult = (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                                public Object call() throws Exception {
                                    task.setLastLSN(ODistributedStorage.this.wrapped.getLSN());
                                    return ODistributedStorage.this.wrapped.updateRecord(iRecordId, updateContent, iContent, iVersion, iRecordType, iMode, iCallback);
                                }
                            });
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw OException.wrapException((OException)new ODistributedException("Cannot delete record " + iRecordId), (Throwable)e);
                        }
                        nodes.remove(localNodeName);
                    } else {
                        localResult = null;
                    }
                    if (nodes.isEmpty()) {
                        unlockCallback.call(null);
                        if (!executedLocally) {
                            throw new ODistributedException("Cannot execute distributed update on record " + iRecordId + " because no nodes are available");
                        }
                    } else {
                        Integer localResultPayload;
                        Integer n = localResultPayload = localResult != null ? (Integer)localResult.getResult() : null;
                        if (syncMode || localResult == null) {
                            try {
                                ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(ODistributedStorage.this.getName(), (Collection)clusterNames, (Collection)nodes, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResultPayload, unlockCallback, null);
                                Object payload = dResponse.getPayload();
                                if (payload instanceof Exception) {
                                    if (payload instanceof ORecordNotFoundException) {
                                        ODistributedStorage.this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)((ORecordNotFoundException)payload).getRid());
                                    }
                                    ODistributedStorage.this.executeUndoOnLocalServer(dResponse.getRequestId(), (OAbstractReplicatedTask)task);
                                    if (payload instanceof ONeedRetryException) {
                                        throw (ONeedRetryException)payload;
                                    }
                                    throw OException.wrapException((OException)new ODistributedException("Error on execution distributed update record"), (Throwable)((Exception)payload));
                                }
                                return new OStorageOperationResult((Object)((Integer)payload));
                            }
                            catch (RuntimeException e) {
                                ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                throw e;
                            }
                            catch (Exception e) {
                                ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                throw ODatabaseException.wrapException((OException)new ODistributedException("Cannot execute distributed update record"), (Throwable)e);
                            }
                        }
                        ODistributedStorage.this.asynchronousExecution(new OAsynchDistributedOperation(ODistributedStorage.this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), (Object)localResultPayload, unlockCallback, null));
                    }
                    return localResult;
                }
            });
        }
        catch (ONeedRetryException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            throw e;
        }
        catch (InterruptedException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Current node has been interrupted"), (Throwable)e);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            this.handleDistributedException("Cannot route UPDATE_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OStorageOperationResult<Boolean> deleteRecord(final ORecordId iRecordId, final int iVersion, final int iMode, final ORecordCallback<Boolean> iCallback) {
        this.resetLastValidBackup();
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
        }
        final String clusterName = this.getClusterNameByRID(iRecordId);
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        final String localNodeName = this.dManager.getLocalNodeName();
        this.checkWriteQuorum(dbCfg, clusterName, localNodeName);
        try {
            this.checkNodeIsMaster(localNodeName, dbCfg, "Delete record " + iRecordId);
            final List nodes = dbCfg.getServers(clusterName, null);
            if (nodes.isEmpty()) {
                return this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
            }
            final Set<String> clusterNames = Collections.singleton(clusterName);
            Boolean executionModeSynch = dbCfg.isExecutionModeSynchronous(clusterName);
            if (executionModeSynch == null) {
                executionModeSynch = iMode == 0;
            }
            final boolean syncMode = executionModeSynch;
            return (OStorageOperationResult)this.executeRecordOperationInLock(syncMode, iRecordId, new OCallable<Object, OCallable<Void, ODistributedRequestId>>(){

                public Object call(OCallable<Void, ODistributedRequestId> unlockCallback) {
                    OStorageOperationResult localResult;
                    final ODeleteRecordTask task = (ODeleteRecordTask)ODistributedStorage.this.dManager.getTaskFactoryManager().getFactoryByServerNames((Collection)nodes).createTask(4);
                    task.init(iRecordId, iVersion);
                    boolean executedLocally = nodes.contains(localNodeName);
                    if (executedLocally) {
                        try {
                            task.checkRecordExists();
                            localResult = (OStorageOperationResult)OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                                public Object call() throws Exception {
                                    task.setLastLSN(ODistributedStorage.this.wrapped.getLSN());
                                    return ODistributedStorage.this.wrapped.deleteRecord(iRecordId, iVersion, iMode, iCallback);
                                }
                            });
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw OException.wrapException((OException)new ODistributedException("Cannot delete record " + iRecordId), (Throwable)e);
                        }
                        nodes.remove(localNodeName);
                    } else {
                        localResult = null;
                    }
                    if (nodes.isEmpty()) {
                        unlockCallback.call(null);
                        if (!executedLocally) {
                            throw new ODistributedException("Cannot execute distributed delete on record " + iRecordId + " because no nodes are available");
                        }
                    } else {
                        Boolean localResultPayload;
                        Boolean bl = localResultPayload = localResult != null ? (Boolean)localResult.getResult() : null;
                        if (syncMode || localResult == null) {
                            try {
                                ODistributedResponse dResponse = ODistributedStorage.this.dManager.sendRequest(ODistributedStorage.this.getName(), (Collection)clusterNames, (Collection)nodes, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)localResultPayload, unlockCallback, null);
                                Object payload = dResponse.getPayload();
                                if (payload instanceof Exception) {
                                    if (payload instanceof ORecordNotFoundException) {
                                        ODistributedStorage.this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord((ORecordId)((ORecordNotFoundException)payload).getRid());
                                    }
                                    ODistributedStorage.this.executeUndoOnLocalServer(dResponse.getRequestId(), (OAbstractReplicatedTask)task);
                                    if (payload instanceof ONeedRetryException) {
                                        throw (ONeedRetryException)payload;
                                    }
                                    throw OException.wrapException((OException)new ODistributedException("Error on execution distributed delete record"), (Throwable)((Exception)payload));
                                }
                                return new OStorageOperationResult((Object)true);
                            }
                            catch (RuntimeException e) {
                                ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                throw e;
                            }
                            catch (Exception e) {
                                ODistributedStorage.this.executeUndoOnLocalServer(null, (OAbstractReplicatedTask)task);
                                throw ODatabaseException.wrapException((OException)new ODistributedException("Cannot execute distributed delete record"), (Throwable)e);
                            }
                        }
                        if (!nodes.isEmpty()) {
                            ODistributedStorage.this.asynchronousExecution(new OAsynchDistributedOperation(ODistributedStorage.this.getName(), Collections.singleton(clusterName), (Collection)nodes, (ORemoteTask)task, ODistributedStorage.this.dManager.getNextMessageIdCounter(), (Object)localResultPayload, unlockCallback, null));
                        }
                    }
                    return localResult;
                }
            });
        }
        catch (ONeedRetryException e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            throw e;
        }
        catch (InterruptedException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Current node has been interrupted"), (Throwable)e);
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.localDistributedDatabase.getDatabaseRepairer().enqueueRepairRecord(iRecordId);
            this.handleDistributedException("Cannot route DELETE_RECORD operation for %s to the distributed node", e, iRecordId);
            return null;
        }
    }

    public OSBTreeCollectionManager getSBtreeCollectionManager() {
        return this.wrapped.getSBtreeCollectionManager();
    }

    protected void checkWriteQuorum(ODistributedConfiguration dbCfg, String clusterName, String localNodeName) {
        int availableNodes;
        List clusterServers = dbCfg.getServers(clusterName, null);
        int writeQuorum = dbCfg.getWriteQuorum(clusterName, clusterServers.size(), localNodeName);
        if (writeQuorum > (availableNodes = this.dManager.getAvailableNodes(this.getName()))) {
            throw new ODistributedException("Quorum (" + writeQuorum + ") cannot be reached on server '" + localNodeName + "' because it is major than available nodes (" + availableNodes + ")");
        }
    }

    public void recyclePosition(ORecordId iRecordId, byte[] content, int recordVersion, byte recordType) {
        this.wrapped.recyclePosition(iRecordId, content, recordVersion, recordType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeRecordOperationInLock(boolean iUnlockAtTheEnd, ORecordId rid, final OCallable<Object, OCallable<Void, ODistributedRequestId>> callback) throws Exception {
        Object object;
        OLogSequenceNumber lastLSN;
        block9: {
            final ORecordId rid2Lock = !rid.isPersistent() ? new ORecordId(rid.getClusterId(), -1L) : rid;
            ODistributedRequestId requestId = null;
            lastLSN = this.wrapped.getLSN();
            final AtomicBoolean lockReleased = new AtomicBoolean(false);
            try {
                final ODistributedRequestId finalReqId = requestId = this.acquireRecordLock(rid2Lock);
                OCallable<Void, ODistributedRequestId> unlockCallback = new OCallable<Void, ODistributedRequestId>(){

                    public Void call(ODistributedRequestId requestId) {
                        if (lockReleased.compareAndSet(false, true)) {
                            ODistributedStorage.this.releaseRecordLock(rid2Lock, finalReqId);
                            lockReleased.set(true);
                        }
                        return null;
                    }
                };
                object = OScenarioThreadLocal.executeAsDistributed((Callable)new Callable((OCallable)unlockCallback){
                    final /* synthetic */ OCallable val$unlockCallback;
                    {
                        this.val$unlockCallback = oCallable2;
                    }

                    public Object call() throws Exception {
                        return callback.call((Object)this.val$unlockCallback);
                    }
                });
                if (!iUnlockAtTheEnd || !lockReleased.compareAndSet(false, true)) break block9;
                this.releaseRecordLock(rid2Lock, requestId);
            }
            catch (Throwable throwable) {
                if (iUnlockAtTheEnd && lockReleased.compareAndSet(false, true)) {
                    this.releaseRecordLock(rid2Lock, requestId);
                }
                OLogSequenceNumber currentLSN = this.wrapped.getLSN();
                if (lastLSN == null || !lastLSN.equals((Object)currentLSN)) {
                    try {
                        this.localDistributedDatabase.getSyncConfiguration().setLastLSN(this.getDistributedManager().getLocalNodeName(), ((OLocalPaginatedStorage)this.getUnderlying()).getLSN(), true);
                    }
                    catch (IOException e) {
                        ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on updating local LSN configuration for database '%s'", (Object[])new Object[]{this.wrapped.getName()});
                    }
                }
                throw throwable;
            }
        }
        OLogSequenceNumber currentLSN = this.wrapped.getLSN();
        if (lastLSN == null || !lastLSN.equals((Object)currentLSN)) {
            try {
                this.localDistributedDatabase.getSyncConfiguration().setLastLSN(this.getDistributedManager().getLocalNodeName(), ((OLocalPaginatedStorage)this.getUnderlying()).getLSN(), true);
            }
            catch (IOException e) {
                ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on updating local LSN configuration for database '%s'", (Object[])new Object[]{this.wrapped.getName()});
            }
        }
        return object;
    }

    public int getConfigurationUpdated() {
        return this.distributedConfiguration.getVersion();
    }

    public OStorageOperationResult<Boolean> hideRecord(ORecordId recordId, int mode, ORecordCallback<Boolean> callback) {
        throw new UnsupportedOperationException();
    }

    public ORecordMetadata getRecordMetadata(ORID rid) {
        return this.wrapped.getRecordMetadata(rid);
    }

    public boolean cleanOutRecord(ORecordId recordId, int recordVersion, int iMode, ORecordCallback<Boolean> callback) {
        return this.wrapped.cleanOutRecord(recordId, recordVersion, iMode, callback);
    }

    public boolean existsResource(String iName) {
        return this.wrapped.existsResource(iName);
    }

    public OCluster getClusterByName(String iName) {
        return this.wrapped.getClusterByName(iName);
    }

    public ORecordConflictStrategy getConflictStrategy() {
        return this.getUnderlying().getConflictStrategy();
    }

    public void setConflictStrategy(ORecordConflictStrategy iResolver) {
        this.getUnderlying().setConflictStrategy(iResolver);
    }

    public <T> T removeResource(String iName) {
        return (T)this.wrapped.removeResource(iName);
    }

    public <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.wrapped.getResource(iName, iCallback);
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        this.wrapped.open(iUserName, iUserPassword, iProperties);
    }

    public void create(Map<String, Object> iProperties) {
        this.wrapped.create(iProperties);
    }

    public boolean exists() {
        return this.wrapped.exists();
    }

    public void reload() {
        this.wrapped.reload();
    }

    public void delete() {
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.delete();
    }

    public String incrementalBackup(String backupDirectory) {
        return this.wrapped.incrementalBackup(backupDirectory);
    }

    public void restoreFromIncrementalBackup(String filePath) {
        this.wrapped.restoreFromIncrementalBackup(filePath);
    }

    public void close() {
        this.close(false, false);
    }

    public void closeAndMove(OCallable<Void, String> mover) {
        if (this.wrapped == null) {
            return;
        }
        if (this.wrapped instanceof OLocalPaginatedStorage) {
            ((OLocalPaginatedStorage)this.wrapped).closeAndMove(mover);
        } else {
            this.wrapped.close(true, false);
        }
    }

    public void close(boolean iForce, boolean onDelete) {
        if (this.wrapped == null) {
            return;
        }
        if (onDelete && this.wrapped instanceof OLocalPaginatedStorage) {
            this.dropStorageFiles();
        }
        this.wrapped.close(iForce, onDelete);
        if (this.isClosed()) {
            this.shutdownAsynchronousWorker();
        }
    }

    public boolean isClosed() {
        if (this.wrapped == null) {
            return true;
        }
        return this.wrapped.isClosed();
    }

    public List<ORecordOperation> commit(final OTransaction iTx, final Runnable callback) {
        this.resetLastValidBackup();
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            try {
                return this.wrapped.commit(iTx, callback);
            }
            catch (ORecordDuplicatedException e) {
                ODistributedDatabase dDatabase = this.dManager.getMessageService().getDatabase(this.getName());
                if (dDatabase.getRecordIfLocked(e.getRid()) != null) {
                    throw new OPossibleDuplicatedRecordException(e);
                }
                throw e;
            }
        }
        ODistributedConfiguration dbCfg = this.distributedConfiguration;
        String localNodeName = this.dManager.getLocalNodeName();
        this.checkNodeIsMaster(localNodeName, dbCfg, "Transaction Commit");
        try {
            if (dbCfg.isReplicationActive(null, localNodeName)) {
                int autoRetryDelay;
                int maxAutoRetry = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY.getValueAsInteger();
                if (maxAutoRetry <= 0) {
                    maxAutoRetry = 1;
                }
                if ((autoRetryDelay = OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY.getValueAsInteger()) <= 0) {
                    autoRetryDelay = 1;
                }
                Exception lastException = null;
                for (int retry = 1; retry <= maxAutoRetry; ++retry) {
                    try {
                        List<ORecordOperation> result = this.txManager.commit((ODatabaseDocumentTx)ODatabaseRecordThreadLocal.instance().get(), iTx, callback, this.eventListener);
                        if (result != null) {
                            for (ORecordOperation r : result) {
                                this.localDistributedDatabase.replaceRecordContentIfLocked(r.getRID(), r.getRecord().toStream());
                            }
                        }
                        return result;
                    }
                    catch (Exception e) {
                        lastException = e;
                        if (retry >= maxAutoRetry) {
                            ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction retries exceed maximum auto-retries (%d)", (Object[])new Object[]{maxAutoRetry});
                            break;
                        }
                        if (e instanceof OConcurrentModificationException || !(e instanceof ONeedRetryException) && !(e instanceof ORecordNotFoundException) || e instanceof ODistributedRedirectException) break;
                        long wait = autoRetryDelay / 2 + new Random().nextInt(autoRetryDelay);
                        ODistributedServerLog.debug((Object)this, (String)localNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Distributed transaction cannot be completed, wait %dms and retry again (%d/%d)", (Object[])new Object[]{wait, retry, maxAutoRetry});
                        Thread.sleep(wait);
                        Orient.instance().getProfiler().updateCounter("db." + this.getName() + ".distributedTxRetries", "Number of retries executed in distributed transaction", 1L, "db.*.distributedTxRetries");
                        continue;
                    }
                }
                if (lastException instanceof RuntimeException) {
                    throw (RuntimeException)lastException;
                }
                throw OException.wrapException((OException)new ODistributedException("Error on executing distributed transaction"), (Throwable)lastException);
            }
            OScenarioThreadLocal.executeAsDistributed((Callable)new Callable(){

                public Object call() throws Exception {
                    return ODistributedStorage.this.wrapped.commit(iTx, callback);
                }
            });
        }
        catch (InterruptedException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Current node has been interrupted"), (Throwable)e);
        }
        catch (OValidationException e) {
            throw e;
        }
        catch (HazelcastInstanceNotActiveException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (HazelcastException e) {
            throw OException.wrapException((OException)new OOfflineNodeException("Hazelcast instance is not available"), (Throwable)e);
        }
        catch (Exception e) {
            this.handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
        }
        return null;
    }

    protected ODistributedRequestId acquireRecordLock(ORecordId rid) {
        ODistributedRequestId localReqId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
        this.localDistributedDatabase.lockRecord((ORID)rid, localReqId, OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong() / 2L);
        if (this.eventListener != null) {
            try {
                this.eventListener.onAfterRecordLock(rid);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Caught exception during ODistributedStorageEventListener.onAfterRecordLock", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return localReqId;
    }

    protected void releaseRecordLock(ORecordId rid, ODistributedRequestId requestId) {
        this.localDistributedDatabase.unlockRecord((OIdentifiable)rid, requestId);
        if (this.eventListener != null) {
            try {
                this.eventListener.onAfterRecordUnlock(rid);
            }
            catch (Exception e) {
                ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Caught exception during ODistributedStorageEventListener.onAfterRecordUnlock", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    public void rollback(OTransaction iTx) {
        this.wrapped.rollback(iTx);
    }

    public OStorageConfiguration getConfiguration() {
        return this.wrapped.getConfiguration();
    }

    public int getClusters() {
        return this.wrapped.getClusters();
    }

    public Set<String> getClusterNames() {
        return this.wrapped.getClusterNames();
    }

    public OCluster getClusterById(int iId) {
        return this.wrapped.getClusterById(iId);
    }

    public Collection<? extends OCluster> getClusterInstances() {
        return this.wrapped.getClusterInstances();
    }

    public int addCluster(final String iClusterName, boolean forceListBased, final Object ... iParameters) {
        this.resetLastValidBackup();
        for (int retry = 0; retry < 10; ++retry) {
            final AtomicInteger clId = new AtomicInteger();
            if (!OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
                final StringBuilder cmd = new StringBuilder("create cluster `");
                cmd.append(iClusterName);
                cmd.append("`");
                Object result = null;
                try {
                    result = this.dManager.executeInDistributedDatabaseLock(this.getName(), 20000L, this.dManager.getDatabaseConfiguration(this.getName()).modify(), (OCallable)new OCallable<Object, OModifiableDistributedConfiguration>(){

                        public Object call(OModifiableDistributedConfiguration iArgument) {
                            clId.set(ODistributedStorage.this.wrapped.addCluster(iClusterName, false, iParameters));
                            OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                            commandSQL.addExcludedNode(ODistributedStorage.this.getNodeId());
                            return ODistributedStorage.this.command((OCommandRequestText)commandSQL);
                        }
                    });
                }
                catch (Exception e) {
                    this.wrapped.dropCluster(iClusterName, false);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (result != null && ((Integer)result).intValue() != clId.get()) {
                    ODistributedServerLog.warn((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating cluster '%s' on distributed nodes: ids are different (local=%d and remote=%d). Local clusters %s. Retrying %d/%d...", (Object[])new Object[]{iClusterName, clId.get(), (int)((Integer)result), this.getClusterNames(), retry, 10});
                    this.wrapped.dropCluster(clId.get(), false);
                    cmd.setLength(0);
                    cmd.append("drop cluster ");
                    cmd.append(iClusterName);
                    OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                    commandSQL.addExcludedNode(this.getNodeId());
                    this.command((OCommandRequestText)commandSQL);
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.wrapped.reload();
                    continue;
                }
            } else {
                clId.set(this.wrapped.addCluster(iClusterName, false, iParameters));
            }
            return clId.get();
        }
        throw new ODistributedException("Error on creating cluster '" + iClusterName + "' on distributed nodes: local and remote ids assigned are different");
    }

    public int addCluster(String iClusterName, int iRequestedId, boolean forceListBased, Object ... iParameters) {
        this.resetLastValidBackup();
        return this.wrapped.addCluster(iClusterName, iRequestedId, forceListBased, iParameters);
    }

    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        this.resetLastValidBackup();
        return this.wrapped.dropCluster(iClusterName, iTruncate);
    }

    public boolean dropCluster(int iId, boolean iTruncate) {
        return this.wrapped.dropCluster(iId, iTruncate);
    }

    public long count(int iClusterId) {
        return this.wrapped.count(iClusterId);
    }

    public long count(int iClusterId, boolean countTombstones) {
        return this.wrapped.count(iClusterId, countTombstones);
    }

    public long count(int[] iClusterIds) {
        return this.wrapped.count(iClusterIds);
    }

    public long count(int[] iClusterIds, boolean countTombstones) {
        return this.wrapped.count(iClusterIds, countTombstones);
    }

    public long getSize() {
        return this.wrapped.getSize();
    }

    public long countRecords() {
        return this.wrapped.countRecords();
    }

    public int getDefaultClusterId() {
        return this.wrapped.getDefaultClusterId();
    }

    public void setDefaultClusterId(int defaultClusterId) {
        this.wrapped.setDefaultClusterId(defaultClusterId);
    }

    public int getClusterIdByName(String iClusterName) {
        return this.wrapped.getClusterIdByName(iClusterName);
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        return this.wrapped.getPhysicalClusterNameById(iClusterId);
    }

    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return this.wrapped.checkForRecordValidity(ppos);
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.wrapped.getURL();
    }

    public long getVersion() {
        return this.wrapped.getVersion();
    }

    public void synch() {
        this.wrapped.synch();
    }

    public long[] getClusterDataRange(int currentClusterId) {
        return this.wrapped.getClusterDataRange(currentClusterId);
    }

    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        return (V)this.wrapped.callInLock(iCallable, iExclusiveLock);
    }

    public OStorage.STATUS getStatus() {
        return this.wrapped.getStatus();
    }

    public ODistributedStorageEventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(ODistributedStorageEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void checkForClusterPermissions(String iClusterName) {
        this.wrapped.checkForClusterPermissions(iClusterName);
    }

    public OPhysicalPosition[] higherPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.higherPhysicalPositions(currentClusterId, entry);
    }

    public OServer getServer() {
        return this.serverInstance;
    }

    public ODistributedServerManager getDistributedManager() {
        return this.dManager;
    }

    public ODistributedConfiguration getDistributedConfiguration() {
        if (this.distributedConfiguration == null) {
            Map map = this.dManager.getConfigurationMap();
            if (map == null) {
                return null;
            }
            ODocument doc = (ODocument)map.get("database." + this.getName());
            if (doc != null) {
                ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Downloaded configuration for database '%s' from the cluster", (Object[])new Object[]{this.getName()});
                this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
            } else {
                doc = this.loadDatabaseConfiguration(this.getDistributedConfigFile());
                if (doc == null) {
                    doc = this.loadDatabaseConfiguration(this.dManager.getDefaultDatabaseConfigFile());
                    if (doc == null) {
                        throw new OConfigurationException("Cannot load default distributed for database '" + this.getName() + "' config file: " + this.dManager.getDefaultDatabaseConfigFile());
                    }
                    this.setDistributedConfiguration(new OModifiableDistributedConfiguration(doc));
                } else {
                    this.distributedConfiguration = new ODistributedConfiguration(doc);
                }
                this.dManager.updateCachedDatabaseConfiguration(this.getName(), new OModifiableDistributedConfiguration(doc), true);
            }
        }
        return this.distributedConfiguration;
    }

    public void setDistributedConfiguration(OModifiableDistributedConfiguration distributedConfiguration) {
        if (this.distributedConfiguration == null || distributedConfiguration.getVersion() > this.distributedConfiguration.getVersion()) {
            this.distributedConfiguration = new ODistributedConfiguration(distributedConfiguration.getDocument().copy());
            String cfgOutput = ODistributedOutput.formatClusterTable(this.dManager, this.getName(), (ODistributedConfiguration)distributedConfiguration, this.dManager.getTotalNodes(this.getName()));
            ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Setting new distributed configuration for database: %s (version=%d)%s\n", (Object[])new Object[]{this.getName(), distributedConfiguration.getVersion(), cfgOutput});
            this.saveDatabaseConfiguration();
        }
    }

    public OPhysicalPosition[] ceilingPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.ceilingPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] floorPhysicalPositions(int clusterId, OPhysicalPosition physicalPosition) {
        return this.wrapped.floorPhysicalPositions(clusterId, physicalPosition);
    }

    public OPhysicalPosition[] lowerPhysicalPositions(int currentClusterId, OPhysicalPosition entry) {
        return this.wrapped.lowerPhysicalPositions(currentClusterId, entry);
    }

    public OStorage getUnderlying() {
        return this.wrapped;
    }

    public boolean isRemote() {
        return false;
    }

    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.wrapped.getComponentsFactory();
    }

    public String getType() {
        return "distributed";
    }

    public void freeze(boolean throwException) {
        String localNode = this.dManager.getLocalNodeName();
        this.prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        this.getFreezableStorage().freeze(throwException);
    }

    public boolean isFrozen() {
        return this.getFreezableStorage().isFrozen();
    }

    public void release() {
        String localNode = this.dManager.getLocalNodeName();
        if (this.prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.ONLINE);
        }
        this.getFreezableStorage().release();
    }

    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) throws IOException {
        String localNode = this.dManager.getLocalNodeName();
        ODistributedServerManager.DB_STATUS prevStatus = this.dManager.getDatabaseStatus(localNode, this.getName());
        if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
            this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.BACKUP);
        }
        try {
            List list = this.wrapped.backup(out, options, callable, iListener, compressionLevel, bufferSize);
            return list;
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OIOException("Error on executing backup"), (Throwable)e);
        }
        finally {
            if (prevStatus == ODistributedServerManager.DB_STATUS.ONLINE) {
                this.dManager.setDatabaseStatus(localNode, this.getName(), ODistributedServerManager.DB_STATUS.ONLINE);
            }
        }
    }

    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) throws IOException {
        this.wrapped.restore(in, options, callable, iListener);
    }

    public String getClusterNameByRID(ORecordId iRid) {
        OCluster cluster = this.getClusterById(iRid.getClusterId());
        return cluster != null ? cluster.getName() : "*";
    }

    public String getStorageId() {
        return this.dManager.getLocalNodeName() + "." + this.getName();
    }

    public String getNodeId() {
        return this.dManager != null ? this.dManager.getLocalNodeName() : "?";
    }

    public void shutdown() {
        this.close(true, false);
    }

    public void shutdownAsynchronousWorker() {
        this.running = false;
        if (this.asynchWorker != null) {
            this.asynchWorker.interrupt();
            try {
                this.asynchWorker.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.asynchronousOperationsQueue != null) {
            this.asynchronousOperationsQueue.clear();
        }
    }

    protected void checkNodeIsMaster(String localNodeName, ODistributedConfiguration dbCfg, String operation) {
        ODistributedConfiguration.ROLES nodeRole = dbCfg.getServerRole(localNodeName);
        if (nodeRole != ODistributedConfiguration.ROLES.MASTER) {
            throw new OWriteOperationNotPermittedException("Cannot execute write operation (" + operation + ") on node '" + localNodeName + "' because is non a master");
        }
    }

    public File getLastValidBackup() {
        return this.lastValidBackup;
    }

    public void setLastValidBackup(File lastValidBackup) {
        this.lastValidBackup = lastValidBackup;
    }

    protected void asynchronousExecution(OAsynchDistributedOperation iOperation) {
        this.asynchronousOperationsQueue.offer(iOperation);
    }

    protected OAsyncReplicationError getAsyncReplicationError() {
        if (((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationError != null) {
            final OAsyncReplicationError subCallback = ((OExecutionThreadLocal.OExecutionThreadData)OExecutionThreadLocal.INSTANCE.get()).onAsyncReplicationError;
            ODatabaseDocumentTx currentDatabase = (ODatabaseDocumentTx)ODatabaseRecordThreadLocal.instance().get();
            final ODatabaseDocumentTx copyDatabase = currentDatabase.copy();
            currentDatabase.activateOnCurrentThread();
            return new OAsyncReplicationError(){

                public OAsyncReplicationError.ACTION onAsyncReplicationError(Throwable iException, int iRetry) {
                    copyDatabase.activateOnCurrentThread();
                    switch (subCallback.onAsyncReplicationError(iException, iRetry)) {
                        case RETRY: {
                            break;
                        }
                    }
                    return OAsyncReplicationError.ACTION.IGNORE;
                }
            };
        }
        return null;
    }

    protected void handleDistributedException(String iMessage, Exception e, Object ... iParams) {
        if (e != null) {
            if (e instanceof OException) {
                throw (OException)e;
            }
            if (e.getCause() instanceof OException) {
                throw (OException)e.getCause();
            }
            if (e.getCause() != null && e.getCause().getCause() instanceof OException) {
                throw (OException)e.getCause().getCause();
            }
        }
        OLogManager.instance().error((Object)this, iMessage, (Throwable)e, iParams);
        throw OException.wrapException((OException)new OStorageException(String.format(iMessage, iParams)), (Throwable)e);
    }

    private OFreezableStorageComponent getFreezableStorage() {
        if (this.wrapped instanceof OFreezableStorageComponent) {
            return (OFreezableStorageComponent)this.wrapped;
        }
        throw new UnsupportedOperationException("Storage engine " + this.wrapped.getType() + " does not support freeze operation");
    }

    private void resetLastValidBackup() {
        if (this.lastValidBackup != null) {
            this.lastValidBackup = null;
        }
    }

    void executeUndoOnLocalServer(final ODistributedRequestId reqId, OAbstractReplicatedTask task) {
        final ORemoteTask undoTask = task.getUndoTask(this.dManager, reqId, OMultiValue.getSingletonList((Object)this.dManager.getLocalNodeName()));
        if (undoTask != null) {
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Undo operation on local server (reqId=%s task=%s)", (Object[])new Object[]{reqId, undoTask});
            OScenarioThreadLocal.executeAsDistributed((Callable)new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    boolean databaseAlreadyDefined;
                    ODatabaseDocumentTx database = (ODatabaseDocumentTx)ODatabaseRecordThreadLocal.instance().getIfDefined();
                    if (database == null) {
                        databaseAlreadyDefined = false;
                        database = new ODatabaseDocumentTx(ODistributedStorage.this.getURL());
                        database.setProperty(ODatabase.OPTIONS.SECURITY.toString(), OSecurityServerUser.class);
                        database.open("system", "system");
                    } else {
                        databaseAlreadyDefined = true;
                    }
                    try {
                        undoTask.execute(reqId, ODistributedStorage.this.dManager.getServerInstance(), ODistributedStorage.this.dManager, (ODatabaseDocumentInternal)database);
                    }
                    catch (Exception e) {
                        ODistributedServerLog.error((Object)this, (String)ODistributedStorage.this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on undo operation on local node (reqId=%s)", (Throwable)e, (Object[])new Object[]{reqId});
                    }
                    finally {
                        if (!databaseAlreadyDefined) {
                            database.close();
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected void dropStorageFiles() {
        StringBuilder stringBuilder = new StringBuilder().append(((OLocalPaginatedStorage)this.wrapped).getStoragePath()).append("/");
        this.getDistributedManager();
        File dCfg = new File(stringBuilder.append("distributed-config.json").toString());
        try {
            File dCfg2;
            if (dCfg.exists()) {
                for (int i = 0; i < 10 && !dCfg.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
            if ((dCfg2 = new File(((OLocalPaginatedStorage)this.wrapped).getStoragePath() + "/" + "distributed-sync.json")).exists()) {
                for (int i = 0; i < 10 && !dCfg2.delete(); ++i) {
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected String checkForCluster(ORecord record, String localNodeName, ODistributedConfiguration dbCfg) {
        if (!(record instanceof ODocument)) {
            return null;
        }
        ORecordId rid = (ORecordId)record.getIdentity();
        if (rid.getClusterId() < 0) {
            throw new IllegalArgumentException("RID " + rid + " is not valid");
        }
        String clusterName = this.getClusterNameByRID(rid);
        String ownerServer = dbCfg.getClusterOwner(clusterName);
        if (ownerServer.equals(localNodeName)) {
            return null;
        }
        OCluster cl = this.getClusterByName(clusterName);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        OClass cls = db.getMetadata().getSchema().getClassByClusterId(cl.getId());
        String newClusterName = null;
        if (cls != null) {
            ODocument doc;
            String ownerUUID;
            OClusterSelectionStrategy clSel = cls.getClusterSelection();
            if (!(clSel instanceof OLocalClusterWrapperStrategy)) {
                this.dManager.propagateSchemaChanges((ODatabaseInternal)db);
                clSel = cls.getClusterSelection();
            }
            if (!(clSel instanceof OLocalClusterWrapperStrategy)) {
                throw new ODistributedException("Cannot install local cluster strategy on class '" + cls.getName() + "'");
            }
            dbCfg = ((OLocalClusterWrapperStrategy)clSel).readConfiguration();
            String newOwnerNode = dbCfg.getClusterOwner(clusterName);
            if (newOwnerNode.equals(localNodeName)) {
                return null;
            }
            if (!OScenarioThreadLocal.INSTANCE.isRunModeDistributed() && this.dManager.isNodeAvailable(ownerServer, this.getName()) && (ownerUUID = this.dManager.getNodeUuidByName(ownerServer)) != null && (doc = this.dManager.getNodeConfigurationByUuid(ownerUUID, true)) != null) {
                String ownerServerIPAddress = ODistributedAbstractPlugin.getListeningBinaryAddress(doc);
                OLogManager.instance().debug((Object)this, "Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "'). Sending a redirect to the client to connect it directly to the owner server", new Object[0]);
                throw new ODistributedRedirectException(this.getDistributedManager().getLocalNodeName(), ownerServer, ownerServerIPAddress, "Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "')");
            }
            throw new ODistributedConfigurationChangedException("Local node '" + localNodeName + "' is not the owner for cluster '" + clusterName + "' (it is '" + ownerServer + "')");
        }
        if (!ownerServer.equals(localNodeName)) {
            throw new ODistributedException("Error on inserting into cluster '" + clusterName + "' where local node '" + localNodeName + "' is not the master of it, but it is '" + ownerServer + "'");
        }
        clusterName = newClusterName;
        ORecordId oldRID = rid.copy();
        rid.setClusterId(db.getClusterIdByName(newClusterName));
        OLogManager.instance().info((Object)this, "Reassigned local cluster '%s' to the record %s. New RID is %s", new Object[]{newClusterName, oldRID, rid});
        return clusterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODocument loadDatabaseConfiguration(File file) {
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        ODistributedServerLog.info((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Loaded configuration for database '%s' from disk: %s", (Object[])new Object[]{this.getName(), file});
        FileInputStream f = null;
        try {
            f = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            f.read(buffer);
            ODocument doc = new ODocument().fromJSON(new String(buffer), "noMap");
            doc.field("version", (Object)1);
            ODocument oDocument = doc;
            return oDocument;
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on loading distributed configuration file in: %s", (Throwable)e, (Object[])new Object[]{file.getAbsolutePath()});
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    protected void saveDatabaseConfiguration() {
        FileOutputStream f = null;
        try {
            File file = this.getDistributedConfigFile();
            ODistributedServerLog.debug((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Saving distributed configuration file for database '%s' to: %s", (Object[])new Object[]{this.getName(), file});
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            f = new FileOutputStream(file);
            f.write(this.distributedConfiguration.getDocument().toJSON().getBytes());
            f.flush();
        }
        catch (Exception e) {
            ODistributedServerLog.error((Object)this, (String)this.dManager.getLocalNodeName(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on saving distributed configuration file", (Throwable)e, (Object[])new Object[0]);
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getDistributedConfigFile() {
        return new File(this.serverInstance.getDatabaseDirectory() + this.getName() + "/" + "distributed-config.json");
    }

    public void updateConfiguration() {
        this.wrapped.updateConfiguration();
    }

    public void setRecordSerializer(String recordSerializer, int version) {
        this.wrapped.setRecordSerializer(recordSerializer, version);
    }

    public void setProperty(String property, String value) {
        this.wrapped.setProperty(property, value);
    }

    public void setDateFormat(String dateFormat) {
        this.wrapped.setDateFormat(dateFormat);
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.wrapped.setDateTimeFormat(dateTimeFormat);
    }

    public void setTimeZone(TimeZone timeZone) {
        this.wrapped.setTimeZone(timeZone);
    }

    public void setLocaleCountry(String localeCountry) {
        this.wrapped.setLocaleCountry(localeCountry);
    }

    public void setLocaleLanguage(String localeLanguage) {
        this.wrapped.setLocaleLanguage(localeLanguage);
    }

    public void setCharset(String charset) {
        this.wrapped.setCharset(charset);
    }

    public void setClusterSelection(String clusterSelection) {
        this.wrapped.setClusterSelection(clusterSelection);
    }

    public void setMinimumClusters(int minimumClusters) {
        this.wrapped.setMinimumClusters(minimumClusters);
    }

    public void setValidation(boolean validation) {
        this.wrapped.setValidation(validation);
    }

    public void clearProperties() {
        this.wrapped.clearProperties();
    }

    public void removeProperty(String property) {
        this.wrapped.removeProperty(property);
    }

    public void setSchemaRecordId(String schemaRecordId) {
        this.wrapped.setSchemaRecordId(schemaRecordId);
    }

    public void setIndexMgrRecordId(String indexMgrRecordId) {
        this.wrapped.setIndexMgrRecordId(indexMgrRecordId);
    }
}

