/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OCompleted2pcTaskV1
extends OCompleted2pcTask {
    private int[] partitionKey;

    @Override
    public OCompleted2pcTaskV1 init(ODistributedRequestId iRequestId, boolean iSuccess, int[] partitionKey) {
        this.requestId = iRequestId;
        this.success = iSuccess;
        this.partitionKey = partitionKey;
        return this;
    }

    @Override
    public int[] getPartitionKey() {
        return this.partitionKey;
    }

    @Override
    public void toStream(DataOutput out) throws IOException {
        this.requestId.toStream(out);
        out.writeBoolean(this.success);
        out.writeInt(this.fixTasks.size());
        for (ORemoteTask task : this.fixTasks) {
            out.writeByte(task.getFactoryId());
            task.toStream(out);
        }
        out.writeInt(this.partitionKey.length);
        for (Object p : (Object)this.partitionKey) {
            out.writeInt((int)p);
        }
    }

    @Override
    public void fromStream(DataInput in, ORemoteTaskFactory taskFactory) throws IOException {
        this.requestId = new ODistributedRequestId();
        this.requestId.fromStream(in);
        this.success = in.readBoolean();
        int tasksSize = in.readInt();
        for (int i = 0; i < tasksSize; ++i) {
            ORemoteTask task = taskFactory.createTask((int)in.readByte());
            task.fromStream(in, taskFactory);
            this.fixTasks.add(task);
        }
        int partitionKeyLength = in.readInt();
        this.partitionKey = new int[partitionKeyLength];
        for (int i = 0; i < partitionKeyLength; ++i) {
            this.partitionKey[i] = in.readInt();
        }
    }
}

