/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OHaSyncDatabaseStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.util.Map;

public class OCommandExecutorSQLHASyncDatabase
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "HA SYNC DATABASE";
    private OHaSyncDatabaseStatement parsedStatement;

    public OCommandExecutorSQLHASyncDatabase parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        try {
            this.parsedStatement = (OHaSyncDatabaseStatement)OStatementCache.get((String)this.parserText, (ODatabaseDocumentInternal)OCommandExecutorSQLHASyncDatabase.getDatabase());
            this.preParsedStatement = this.parsedStatement;
        }
        catch (OCommandSQLParsingException sqlx) {
            throw sqlx;
        }
        catch (Exception e) {
            this.throwParsingException("Error parsing query: \n" + this.parserText + "\n" + e.getMessage(), e);
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLHASyncDatabase.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.DATABASE, "sync", ORole.PERMISSION_UPDATE);
        OStorage stg = database.getStorage();
        if (!(stg instanceof ODistributedStorage)) {
            throw new ODistributedException("SYNC DATABASE command cannot be executed against a non distributed server");
        }
        ODistributedStorage dStg = (ODistributedStorage)stg;
        OHazelcastPlugin dManager = (OHazelcastPlugin)dStg.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = database.getName();
        return dManager.installDatabase(true, databaseName, this.parsedStatement.isForce(), !this.parsedStatement.isFull());
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public String getSyntax() {
        return "HA SYNC DATABASE [-force] [-full]";
    }
}

